/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.saml;

import coldfusion.filter.FusionContext;
import coldfusion.runtime.AppHelper;
import coldfusion.runtime.ApplicationException;
import coldfusion.runtime.SessionScope;
import coldfusion.saml.RequestOptions;
import coldfusion.saml.SpConfiguration;
import coldfusion.server.ServiceFactory;
import coldfusion.tagext.io.cache.CacheTagHelper;
import coldfusion.tagext.io.cache.GenericCache;
import coldfusion.tagext.io.cache.GenericCacheFactory;
import java.io.File;
import java.io.Serializable;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.config.Configuration;
import net.sf.ehcache.config.ConfigurationFactory;
import net.sf.ehcache.event.CacheEventListener;
import net.sf.ehcache.event.NotificationScope;

public class SamlCacheHelper {
    private static final String AUTH_CACHE_NAME = "samlcache";
    private static CacheManager cacheMngr = null;
    private static Cache authCache = null;

    public static void initSamlAuthCache(String rootDir) {
        String authConfigFile = rootDir + File.separatorChar + "lib" + File.separatorChar + "auth-ehcache.xml";
        Configuration cacheConfig = ConfigurationFactory.parseConfiguration((File)new File(authConfigFile));
        cacheConfig.setName("SamlCacheManager");
        if (cacheMngr == null) {
            cacheMngr = CacheManager.getCacheManager((String)cacheConfig.getName());
            if (cacheMngr == null) {
                cacheMngr = new CacheManager(cacheConfig);
            }
            if ((authCache = cacheMngr.getCache(AUTH_CACHE_NAME)) != null) {
                authCache.getCacheEventNotificationService().registerListener((CacheEventListener)new SamlCacheEventListener(), NotificationScope.ALL);
                Runnable SamlExpiredRequestHandler = new Runnable(){

                    @Override
                    public void run() {
                        authCache.evictExpiredElements();
                    }
                };
                final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
                final ScheduledFuture<?> schedulerHandle = scheduler.scheduleAtFixedRate(SamlExpiredRequestHandler, 0L, 1L, TimeUnit.SECONDS);
                Runtime.getRuntime().addShutdownHook(new Thread(){

                    @Override
                    public void run() {
                        try {
                            schedulerHandle.cancel(true);
                            scheduler.shutdownNow();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                });
            }
        }
    }

    public static void updateCache(String key, RequestOptions value, SpConfiguration sp) {
        if (sp.getStateStore() != null && sp.getStateStore().toLowerCase().equals("redis")) {
            SamlCacheHelper.checkSessionStorageModuleAccessibilty();
            AppHelper appHelper = FusionContext.getCurrent().getAppHelper();
            if (!appHelper.isSessionManagmentEnabled() || !ServiceFactory.getRuntimeService().getSessionStorage().equals("redis")) {
                throw new SessionManagementException();
            }
            SessionScope sessionScope = (SessionScope)FusionContext.getCurrent().hiddenScope.get((Object)"SESSION");
            if (sessionScope != null) {
                sessionScope.put((Object)key, (Object)value);
            }
        } else if (sp.getStateStore() != null && sp.getStateStore().toLowerCase().equals("cache")) {
            SamlCacheHelper.checkCacheModuleAccessibilty();
            SamlCacheHelper.createCacheRegion();
            CacheTagHelper.addToObjectCache((Object)key, (Object)value, (String)"saml", (Object)value.getLifetime(), (Object)value.getLifetime(), (boolean)true);
        } else {
            authCache.put(SamlCacheHelper.createElement(key, value));
        }
    }

    public static RequestOptions getCacheValue(String key, SpConfiguration sp, String functionName) {
        if (sp.getStateStore() != null && sp.getStateStore().toLowerCase().equals("redis")) {
            SamlCacheHelper.checkSessionStorageModuleAccessibilty();
            AppHelper appHelper = FusionContext.getCurrent().getAppHelper();
            if (!appHelper.isSessionManagmentEnabled()) {
                throw new SessionManagementException();
            }
            SessionScope sessionScope = (SessionScope)FusionContext.getCurrent().hiddenScope.get((Object)"SESSION");
            if (sessionScope != null) {
                RequestOptions rq = (RequestOptions)sessionScope.get((Object)key);
                return rq;
            }
            return null;
        }
        if (sp.getStateStore() != null && sp.getStateStore().toLowerCase().equals("cache")) {
            SamlCacheHelper.checkCacheModuleAccessibilty();
            SamlCacheHelper.createCacheRegion();
            return (RequestOptions)CacheTagHelper.getFromCache((Object)key, (String)"OBJECT", (String)functionName, (String)"saml", (boolean)true);
        }
        Element element = authCache.get((Serializable)((Object)key));
        if (element != null) {
            return (RequestOptions)element.getObjectValue();
        }
        return null;
    }

    public static boolean removeCacheValue(String key, SpConfiguration sp, String functionName) {
        if (sp.getStateStore() != null && sp.getStateStore().toLowerCase().equals("redis")) {
            AppHelper appHelper = FusionContext.getCurrent().getAppHelper();
            if (!appHelper.isSessionManagmentEnabled()) {
                throw new SessionManagementException();
            }
            SessionScope sessionScope = (SessionScope)FusionContext.getCurrent().hiddenScope.get((Object)"SESSION");
            if (sessionScope != null) {
                sessionScope.remove((Object)key);
                return true;
            }
            return false;
        }
        if (sp.getStateStore() != null && sp.getStateStore().toLowerCase().equals("cache")) {
            SamlCacheHelper.checkCacheModuleAccessibilty();
            SamlCacheHelper.createCacheRegion();
            CacheTagHelper.deleteFromObjectCache((Object)key, (boolean)true, (String)functionName, (String)"saml", (boolean)true);
            return true;
        }
        return authCache.remove((Serializable)((Object)key));
    }

    private static void checkCacheModuleAccessibilty() {
        ServiceFactory.getCachingService((boolean)true);
    }

    private static void checkSessionStorageModuleAccessibilty() {
        ServiceFactory.getSessionStorageService((boolean)true);
        String host = ServiceFactory.getRuntimeService().getSessionStorageHost();
        int port = ServiceFactory.getRuntimeService().getSessionStoragePort();
        ServiceFactory.getRuntimeService().verifySessionStorageConnection(host, port, null, new String[0]);
    }

    private static void createCacheRegion() {
        GenericCache cache = GenericCacheFactory.getCache();
        if (!cache.cacheExists("saml")) {
            cache.createCache("saml", "OBJECT", null, null);
        }
    }

    public static Element createElement(String key, RequestOptions value) {
        Element element = new Element((Serializable)((Object)key), (Serializable)value);
        CacheConfiguration config = authCache.getCacheConfiguration();
        if (value.getLifetime() > 0) {
            element.setTimeToIdle(value.getLifetime());
        } else if (value.getLifetime() < 0) {
            element.setTimeToIdle((int)config.getTimeToIdleSeconds());
        }
        if (value.getLifetime() > 0) {
            element.setTimeToLive(value.getLifetime());
        } else if (value.getLifetime() < 0) {
            element.setTimeToLive((int)config.getTimeToLiveSeconds());
        }
        if (element.getTimeToIdle() == 0 && element.getTimeToLive() == 0) {
            element.setEternal(true);
        }
        return element;
    }

    public static class SessionManagementException
    extends ApplicationException {
    }

    static class SamlCacheEventListener
    implements CacheEventListener {
        SamlCacheEventListener() {
        }

        public void notifyElementEvicted(Ehcache cache, Element elementEvicted) {
        }

        public void notifyElementExpired(Ehcache cache, Element elementExpired) {
        }

        public void notifyElementRemoved(Ehcache cache, Element elementRemoved) throws CacheException {
        }

        public void notifyElementPut(Ehcache cache, Element elementPut) throws CacheException {
        }

        public void notifyElementUpdated(Ehcache cache, Element arg1) throws CacheException {
        }

        public void notifyRemoveAll(Ehcache cache) {
        }

        public void dispose() {
        }

        public Object clone() throws CloneNotSupportedException {
            throw new CloneNotSupportedException();
        }
    }
}

