/*
 * Decompiled with CFR 0.152.
 */
package macromedia.slutil;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import macromedia.slutil.UtilByteArray;
import macromedia.slutil.UtilException;
import macromedia.slutil.UtilTransliterator;

public class UtilTransliteratorForUCS2
extends UtilTransliterator {
    private boolean isBigEndian;
    private byte[] temp;
    private int[] rl;
    private InputStream _in;

    public UtilTransliteratorForUCS2() {
        this.setDefaultCacheSize();
        this.isBigEndian = true;
    }

    public boolean isFixedBytesPerChar() {
        return true;
    }

    public int getMaxBytesPerChar() {
        return 2;
    }

    public int getMaxCharsPerByte() {
        return 1;
    }

    public void setToBigEndian() {
        this.isBigEndian = true;
    }

    public void setToLittleEndian() {
        this.isBigEndian = false;
    }

    public byte[] encode(String string) throws UtilException {
        if (this.rl == null) {
            this.rl = new int[1];
        }
        return UtilByteArray.duplicate(this.encode(string, this.rl), string.length() * 2);
    }

    public byte[] encode(String string, int[] nArray) throws UtilException {
        int n2 = string.length();
        this.setCacheSize(n2);
        string.getChars(0, n2, this.charsCache, 0);
        if (this.isBigEndian) {
            for (int i2 = 0; i2 < n2; ++i2) {
                char c2 = this.charsCache[i2];
                this.bytesCache[i2 * 2] = (byte)(c2 >>> 8);
                this.bytesCache[i2 * 2 + 1] = (byte)c2;
            }
        } else {
            for (int i3 = 0; i3 < n2; ++i3) {
                char c3 = this.charsCache[i3];
                this.bytesCache[i3 * 2] = (byte)c3;
                this.bytesCache[i3 * 2 + 1] = (byte)(c3 >>> 8);
            }
        }
        nArray[0] = n2 * 2;
        return this.bytesCache;
    }

    public void encode(InputStream inputStream, int n2, OutputStream outputStream) throws UtilException {
        this.setCacheSize(this.streamChunkSize);
        try {
            if (this.temp == null) {
                this.temp = new byte[this.streamChunkSize];
            }
            while (n2 > 0) {
                int n3;
                int n4 = Math.min(n2, this.streamChunkSize);
                int n5 = inputStream.read(this.temp, 0, n4);
                if (n5 == -1) {
                    throw new UtilException(1002);
                }
                if (this.isBigEndian) {
                    for (n3 = 0; n3 < n5; ++n3) {
                        this.bytesCache[n3 * 2] = 0;
                        this.bytesCache[n3 * 2 + 1] = this.temp[n3];
                    }
                } else {
                    for (n3 = 0; n3 < n5; ++n3) {
                        this.bytesCache[n3 * 2] = this.temp[n3];
                        this.bytesCache[n3 * 2 + 1] = 0;
                    }
                }
                outputStream.write(this.bytesCache, 0, n5 * 2);
                n2 -= n5;
            }
        }
        catch (IOException iOException) {
            throw UtilException.createTransliterationFailedException(iOException.getMessage());
        }
    }

    public void encode(Reader reader, int n2, OutputStream outputStream) throws UtilException {
        this.setCacheSize(this.streamChunkSize);
        try {
            while (n2 > 0) {
                char c2;
                int n3;
                int n4 = Math.min(n2, this.streamChunkSize);
                int n5 = reader.read(this.charsCache, 0, n4);
                if (n5 == -1) {
                    throw new UtilException(1002);
                }
                if (this.isBigEndian) {
                    for (n3 = 0; n3 < n5; ++n3) {
                        c2 = this.charsCache[n3];
                        this.bytesCache[n3 * 2] = (byte)(c2 >>> 8);
                        this.bytesCache[n3 * 2 + 1] = (byte)c2;
                    }
                } else {
                    for (n3 = 0; n3 < n5; ++n3) {
                        c2 = this.charsCache[n3];
                        this.bytesCache[n3 * 2] = (byte)c2;
                        this.bytesCache[n3 * 2 + 1] = (byte)(c2 >>> 8);
                    }
                }
                outputStream.write(this.bytesCache, 0, n5 * 2);
                n2 -= n5;
            }
        }
        catch (IOException iOException) {
            throw UtilException.createTransliterationFailedException(iOException.getMessage());
        }
    }

    private void _decode(byte[] byArray, int n2, char[] cArray, int n3, int n4) {
        int n5;
        int n6 = 0;
        if (this.isBigEndian) {
            for (n5 = 0; n5 < n4; ++n5) {
                cArray[n5 + n3] = (char)((byArray[n6 + n2] & 0xFF) << 8 | byArray[n6 + 1 + n2] & 0xFF);
                n6 += 2;
            }
        } else {
            while (n5 < n4) {
                cArray[n5 + n3] = (char)((byArray[n6 + 1 + n2] & 0xFF) << 8 | byArray[n6 + n2] & 0xFF);
                n6 += 2;
                ++n5;
            }
        }
    }

    public String decode(byte[] byArray, int n2, int n3) throws UtilException {
        if (n3 == 0) {
            return EMPTY_STRING;
        }
        int n4 = n3 / 2;
        this.setCacheSize(n4);
        this._decode(byArray, n2, this.charsCache, 0, n4);
        return new String(this.charsCache, 0, n4);
    }

    public int decode(byte[] byArray, int n2, int n3, char[] cArray) throws UtilException {
        if (n3 == 0) {
            return 0;
        }
        int n4 = n3 / 2;
        if (n4 > cArray.length) {
            n4 = cArray.length;
        }
        this._decode(byArray, n2, cArray, 0, n4);
        return n4;
    }

    public String decode(byte[] byArray, int n2, int n3, int n4) throws UtilException {
        int n5 = n3 / 2;
        int n6 = Math.max(n5, n4);
        this.setCacheSize(n6);
        this._decode(byArray, n2, this.charsCache, 0, n5);
        for (int i2 = n5; i2 < n4; ++i2) {
            this.charsCache[i2] = 32;
        }
        return new String(this.charsCache, 0, n4);
    }

    public synchronized Reader decodeAsReader(InputStream inputStream) throws UtilException {
        this._in = inputStream;
        return new Reader(){
            private InputStream in;
            private int length;
            private byte[] cache;
            {
                this.in = UtilTransliteratorForUCS2.this._in;
            }

            public int read() throws IOException {
                int n2 = this.in.read();
                int n3 = this.in.read();
                if (n2 == -1 || n3 == -1) {
                    return -1;
                }
                if (UtilTransliteratorForUCS2.this.isBigEndian) {
                    return (char)((n2 & 0xFF) << 8 | n3 & 0xFF);
                }
                return (char)((n3 & 0xFF) << 8 | n2 & 0xFF);
            }

            public int read(char[] cArray, int n2, int n3) throws IOException {
                int n4;
                int n5 = n3 * 2;
                if (this.cache == null || this.cache.length < n5) {
                    this.cache = new byte[n5];
                }
                if ((n4 = this.in.read(this.cache, 0, n5)) <= 0) {
                    return n4;
                }
                int n6 = n4 / 2;
                UtilTransliteratorForUCS2.this._decode(this.cache, 0, cArray, n2, n6);
                return n6;
            }

            public void close() throws IOException {
                this.in.close();
            }
        };
    }
}

