/*
 * Decompiled with CFR 0.152.
 */
package macromedia.sequelink.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import macromedia.sequelink.net.NetOutput;
import macromedia.sequelink.util.BufferManager;
import macromedia.sequelink.util.UtilMessage;

public class RandomAccessFileOutputStream
extends NetOutput {
    private RandomAccessFile raf;
    long position;

    public RandomAccessFileOutputStream(RandomAccessFile randomAccessFile) {
        this.raf = randomAccessFile;
    }

    public void write(int n2) throws IOException {
        this.raf.write(n2);
    }

    public void write(byte[] byArray) throws IOException {
        this.raf.write(byArray);
    }

    public void write(byte[] byArray, int n2, int n3) throws IOException {
        this.raf.write(byArray, n2, n3);
    }

    public void flush() throws IOException {
    }

    public void close() throws IOException {
        this.raf.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int write(InputStream inputStream, int n2) throws IOException {
        if (n2 <= 0) {
            return 0;
        }
        byte[] byArray = BufferManager.GetBuffer(n2);
        try {
            n2 = inputStream.read(byArray, 0, n2);
            this.raf.write(byArray, 0, n2);
        }
        finally {
            BufferManager.ReturnBuffer(byArray);
        }
        return n2;
    }

    public int getPosition() throws IOException {
        long l2 = this.raf.getFilePointer();
        if (l2 > Integer.MAX_VALUE) {
            throw new IOException(UtilMessage.Gen.getPrefixedMessage("err.raf.oor"));
        }
        return (int)l2;
    }

    public void setPosition(int n2) throws IOException {
        this.raf.seek(n2);
    }

    public int getFreeSpace() {
        return 0;
    }

    public int getIncrement() {
        return 0;
    }
}

