/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbcx.oracle;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import macromedia.jdbc.oracle.OracleImplConnection;
import macromedia.jdbc.oracle.base.BaseConnection;
import macromedia.jdbc.oracle.base.BaseConnectionProperties;
import macromedia.jdbc.oracle.net8.ah;
import macromedia.jdbc.oracle.net8.ai;
import macromedia.jdbc.oracle.net8.ao;
import macromedia.jdbc.oracle.net8.at;
import macromedia.jdbc.oracle.net8.l;
import macromedia.jdbc.oracle.util.ac;
import macromedia.jdbcx.oracle.OracleXid;
import macromedia.jdbcx.oracle.base.g;

public class OracleImplXAResource
extends g {
    private static String footprint = "$Revision$";
    OracleImplConnection implConn;
    at gTTIoer;
    ah ttifunStartEnd;
    ai ttifunTran;
    ao ttifunRPC;
    l NSPTDAPacket;
    BaseConnectionProperties connectProps;
    int timeout;
    boolean localTxnIsAutoCommit;
    private byte[] context;
    Xid currentTxnXid = null;
    boolean recursiveMode = false;
    Vector suspendedXids = new Vector();
    static final short ERROR = 0;
    static final short INVALID_FLAG = 1;
    static final short INVALID_XID = 2;
    static final short INVALID_VERSION = 3;
    static final short TXN_NOT_ENDED = 4;
    static final short INVALID_TIMEOUT = 5;

    public OracleImplXAResource(BaseConnection baseConnection) {
        this.connection = baseConnection;
        this.connectProps = baseConnection.ee();
        this.timeout = 60;
        this.requiredLocalAutoCommit = 0;
        this.implConn = (OracleImplConnection)baseConnection.tg;
        this.gTTIoer = new at(this.implConn);
        this.NSPTDAPacket = new l(this.implConn.gV);
        this.ttifunStartEnd = new ah(this.implConn);
        this.ttifunTran = new ai(this.implConn);
        this.ttifunRPC = new ao(this.implConn);
    }

    @Override
    protected void reset() throws SQLException {
        if (this.currentTxnXid == null) {
            return;
        }
        this.saveAutoCommitMode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void start(Xid xid, int n2) throws XAException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            block13: {
                if (n2 != 0 && n2 != 0x8000000 && n2 != 0x200000 && (n2 & 2) != 2) {
                    throw this.getXAException(1);
                }
                this.saveAutoCommitMode();
                try {
                    int n3 = 0;
                    switch (n2) {
                        case 0: {
                            n3 = 1;
                            break;
                        }
                        case 0x200000: 
                        case 0x8000000: {
                            n3 = 4;
                        }
                    }
                    this.ttifunStartEnd.a((byte)1, this.timeout, n3, xid);
                    this.NSPTDAPacket.a(this.ttifunStartEnd);
                    this.NSPTDAPacket.qd();
                    this.NSPTDAPacket.pN();
                    this.implConn.a(this.ttifunStartEnd, this.gTTIoer);
                    this.checkErrorPacket();
                    this.context = this.ttifunStartEnd.getContext();
                    this.setCurrentTransaction(xid);
                }
                catch (SQLException sQLException) {
                    this.resumeAutoCommitMode();
                    if (!sQLException.getSQLState().regionMatches(false, 0, "08", 0, 2)) break block13;
                    XAException xAException = new XAException(sQLException.getMessage());
                    xAException.errorCode = -7;
                    throw xAException;
                }
            }
            if (n2 == 0x8000000) {
                this.suspendedXids.remove(xid);
            }
            if (this.recursiveMode) {
                return;
            }
            if (this.ttifunStartEnd.apv != 0) {
                this.generateXAException(this.ttifunStartEnd.apv);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void end(Xid xid, int n2) throws XAException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            block14: {
                if (n2 != 0x4000000 && n2 != 0x2000000 && n2 != 0x20000000 && (n2 & 2) != 2) {
                    throw this.getXAException(1);
                }
                try {
                    if ((n2 == 0x4000000 || n2 == 0x20000000) && this.suspendedXids.contains(xid)) {
                        this.start(xid, 0x8000000);
                    }
                    this.clearCurrentTransaction(xid);
                    int n3 = 0;
                    switch (n2) {
                        case 0x4000000: {
                            n3 = 0;
                            break;
                        }
                        case 0x2000000: 
                        case 0x20000000: {
                            n3 = 4;
                        }
                    }
                    this.ttifunStartEnd.a((byte)2, this.timeout, n3, xid);
                    this.NSPTDAPacket.a(this.ttifunStartEnd);
                    this.NSPTDAPacket.qd();
                    this.NSPTDAPacket.pN();
                    this.implConn.a(this.ttifunStartEnd, this.gTTIoer);
                    this.checkErrorPacket();
                }
                catch (SQLException sQLException) {
                    if (!sQLException.getSQLState().regionMatches(false, 0, "08", 0, 2)) break block14;
                    XAException xAException = new XAException(sQLException.getMessage());
                    xAException.errorCode = -7;
                    throw xAException;
                }
            }
            if (this.recursiveMode) {
                return;
            }
            if (this.ttifunStartEnd.apv != 0) {
                this.generateXAException(this.ttifunStartEnd.apv);
            }
            this.resumeAutoCommitMode();
            if (n2 == 0x2000000) {
                this.suspendedXids.add(xid);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int prepare(Xid xid) throws XAException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            block8: {
                try {
                    this.suspendCurrentTransaction(xid);
                    this.ttifunTran.a((byte)3, this.timeout, 0, this.context, xid);
                    this.NSPTDAPacket.a(this.ttifunTran);
                    this.NSPTDAPacket.qd();
                    this.NSPTDAPacket.pN();
                    this.implConn.a(this.ttifunTran, this.gTTIoer);
                    this.checkErrorPacket();
                    this.resumeCurrentTransaction(xid);
                }
                catch (SQLException sQLException) {
                    if (!sQLException.getSQLState().regionMatches(false, 0, "08", 0, 2)) break block8;
                    XAException xAException = new XAException(sQLException.getMessage());
                    xAException.errorCode = -7;
                    throw xAException;
                }
            }
            if (this.ttifunTran.apv == 24767 || this.ttifunTran.apv == 4) {
                return 3;
            }
            if (this.ttifunTran.apv == 1) {
                return 0;
            }
            if (this.ttifunStartEnd.apv != 0) {
                this.generateXAException(this.ttifunStartEnd.apv);
            }
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void commit(Xid xid, boolean bl2) throws XAException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            boolean bl3;
            block12: {
                bl3 = false;
                try {
                    this.suspendCurrentTransaction(xid);
                    int n2 = bl2 ? 4 : 2;
                    this.ttifunTran.a((byte)1, this.timeout, n2, this.context, xid);
                    this.NSPTDAPacket.a(this.ttifunTran);
                    this.NSPTDAPacket.qd();
                    this.NSPTDAPacket.pN();
                    this.implConn.a(this.ttifunTran, this.gTTIoer);
                    if (this.gTTIoer.aqh == 24756 && this.xidIsInSecondaryOracleTable(xid)) {
                        n2 = 3;
                        this.ttifunTran.a((byte)5, this.timeout, n2, this.context, xid);
                        this.NSPTDAPacket.a(this.ttifunTran);
                        this.NSPTDAPacket.qd();
                        this.NSPTDAPacket.pN();
                        this.implConn.a(this.ttifunTran, this.gTTIoer);
                        bl3 = true;
                        if (this.gTTIoer.aqh == 0) {
                            this.NSPTDAPacket.a(this.ttifunRPC);
                            this.NSPTDAPacket.qd();
                            this.NSPTDAPacket.pN();
                            this.implConn.a(this.ttifunRPC, this.gTTIoer);
                        }
                    }
                    this.checkErrorPacket();
                    this.resumeCurrentTransaction(xid);
                }
                catch (SQLException sQLException) {
                    if (!sQLException.getSQLState().regionMatches(false, 0, "08", 0, 2)) break block12;
                    XAException xAException = new XAException(sQLException.getMessage());
                    xAException.errorCode = -7;
                    throw xAException;
                }
            }
            if (bl2) {
                if (this.ttifunTran.apv == 2 || this.ttifunTran.apv == 4 || this.ttifunTran.apv == 3 && bl3) {
                    return;
                }
            } else if (this.ttifunTran.apv == 5 || this.ttifunTran.apv == 3 && bl3) {
                return;
            }
            if (this.ttifunStartEnd.apv != 0) {
                this.generateXAException(this.ttifunStartEnd.apv);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void rollback(Xid xid) throws XAException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            block9: {
                try {
                    this.suspendCurrentTransaction(xid);
                    int n2 = 3;
                    this.ttifunTran.a((byte)2, this.timeout, n2, this.context, xid);
                    this.NSPTDAPacket.a(this.ttifunTran);
                    this.NSPTDAPacket.qd();
                    this.NSPTDAPacket.pN();
                    this.implConn.a(this.ttifunTran, this.gTTIoer);
                    if (this.gTTIoer.aqh == 24756 && this.xidIsInSecondaryOracleTable(xid)) {
                        n2 = 0;
                        this.ttifunTran.a((byte)5, this.timeout, n2, this.context, xid);
                        this.NSPTDAPacket.a(this.ttifunTran);
                        this.NSPTDAPacket.qd();
                        this.NSPTDAPacket.pN();
                        this.implConn.a(this.ttifunTran, this.gTTIoer);
                        if (this.gTTIoer.aqh == 0) {
                            this.NSPTDAPacket.a(this.ttifunRPC);
                            this.NSPTDAPacket.qd();
                            this.NSPTDAPacket.pN();
                            this.implConn.a(this.ttifunRPC, this.gTTIoer);
                        }
                    }
                    this.checkErrorPacket();
                    this.resumeCurrentTransaction(xid);
                }
                catch (SQLException sQLException) {
                    if (!sQLException.getSQLState().regionMatches(false, 0, "08", 0, 2)) break block9;
                    XAException xAException = new XAException(sQLException.getMessage());
                    xAException.errorCode = -7;
                    throw xAException;
                }
            }
            if (this.ttifunTran.apv == 3) {
                return;
            }
            if (this.ttifunStartEnd.apv != 0) {
                this.generateXAException(this.ttifunStartEnd.apv);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void forget(Xid xid) throws XAException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            block6: {
                try {
                    this.suspendCurrentTransaction(xid);
                    int n2 = 4;
                    this.ttifunStartEnd.a((byte)1, this.timeout, n2, xid);
                    this.NSPTDAPacket.a(this.ttifunStartEnd);
                    this.NSPTDAPacket.qd();
                    this.NSPTDAPacket.pN();
                    this.implConn.a(this.ttifunStartEnd, this.gTTIoer);
                    this.checkErrorPacket();
                    n2 = 2;
                    this.ttifunTran.a((byte)5, this.timeout, n2, this.context, xid);
                    this.NSPTDAPacket.a(this.ttifunTran);
                    this.NSPTDAPacket.qd();
                    this.NSPTDAPacket.pN();
                    this.implConn.a(this.ttifunTran, this.gTTIoer);
                    this.checkErrorPacket();
                    this.resumeCurrentTransaction(xid);
                    if (this.ttifunTran.apv == 5) {
                        this.NSPTDAPacket.a(this.ttifunRPC);
                        this.NSPTDAPacket.qd();
                        this.NSPTDAPacket.pN();
                        this.implConn.a(this.ttifunRPC, this.gTTIoer);
                    }
                }
                catch (SQLException sQLException) {
                    if (!sQLException.getSQLState().regionMatches(false, 0, "08", 0, 2)) break block6;
                    XAException xAException = new XAException(sQLException.getMessage());
                    xAException.errorCode = -7;
                    throw xAException;
                }
            }
        }
    }

    @Override
    protected Xid[] recover(int n2) throws XAException {
        boolean bl2 = false;
        Xid[] xidArray = null;
        if (n2 != 0 && (n2 & 0x1000000) != 0x1000000 && (n2 & 0x800000) != 0x800000) {
            throw this.getXAException(1);
        }
        try {
            Statement statement = this.connection.createStatement();
            ResultSet resultSet = statement.executeQuery("SELECT count (*) FROM SYS.DBA_PENDING_TRANSACTIONS");
            resultSet.next();
            int n3 = resultSet.getInt(1);
            resultSet.close();
            xidArray = new Xid[n3];
            if (n3 == 0) {
                return xidArray;
            }
            int n4 = 0;
            resultSet = statement.executeQuery("SELECT formatid, globalid, branchid FROM SYS.DBA_PENDING_TRANSACTIONS");
            while (resultSet.next()) {
                int n5 = resultSet.getInt(1);
                byte[] byArray = resultSet.getBytes(2);
                byte[] byArray2 = resultSet.getBytes(3);
                xidArray[n4] = new OracleXid(n5, byArray, byArray2);
                if (++n4 != n3) continue;
                break;
            }
            resultSet.close();
            statement.close();
            return xidArray;
        }
        catch (SQLException sQLException) {
            throw this.getXAException(0, sQLException.getMessage());
        }
    }

    boolean xidIsInSecondaryOracleTable(Xid xid) {
        try {
            Statement statement = this.connection.createStatement();
            StringBuilder stringBuilder = new StringBuilder(xid.getFormatId() + ".");
            byte[] byArray = xid.getGlobalTransactionId();
            for (int i2 = 0; i2 < byArray.length; ++i2) {
                stringBuilder.append(ac.m(byArray[i2]).toUpperCase());
            }
            String string = "SELECT count (*) FROM SYS.DBA_2PC_PENDING WHERE GLOBAL_TRAN_ID = '" + stringBuilder + "'";
            ResultSet resultSet = statement.executeQuery(string);
            resultSet.next();
            int n2 = resultSet.getInt(1);
            resultSet.close();
            return n2 != 0;
        }
        catch (SQLException sQLException) {
            return false;
        }
    }

    void saveAutoCommitMode() {
        if (this.recursiveMode) {
            return;
        }
        try {
            this.localTxnIsAutoCommit = this.connection.getAutoCommit();
            if (this.localTxnIsAutoCommit) {
                this.connection.setAutoCommit(false);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    void resumeAutoCommitMode() {
        if (this.recursiveMode || !this.localTxnIsAutoCommit) {
            return;
        }
        try {
            this.connection.setAutoCommit(true);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    void setCurrentTransaction(Xid xid) {
        if (this.recursiveMode) {
            return;
        }
        this.currentTxnXid = xid;
    }

    void clearCurrentTransaction(Xid xid) {
        if (this.recursiveMode || this.currentTxnXid == null || !this.currentTxnXid.equals(xid)) {
            return;
        }
        this.currentTxnXid = null;
    }

    void suspendCurrentTransaction(Xid xid) throws XAException {
        if (this.currentTxnXid == null || this.currentTxnXid.equals(xid)) {
            return;
        }
        this.recursiveMode = true;
        this.end(this.currentTxnXid, 0x2000000);
        this.recursiveMode = false;
    }

    void resumeCurrentTransaction(Xid xid) throws XAException {
        if (this.currentTxnXid == null || this.currentTxnXid.equals(xid)) {
            return;
        }
        this.recursiveMode = true;
        this.start(this.currentTxnXid, 0x8000000);
        this.recursiveMode = false;
    }

    byte[] getSerializedBytes(Xid xid) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(xid);
            objectOutputStream.flush();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    int getVersionNumber(String string) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string.trim(), " .", false);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            n3 = Integer.decode(string2);
            n2 = n2 * 10 + n3;
            if (++n4 != 4) continue;
            break;
        }
        return n2;
    }

    @Override
    protected boolean setTransactionTimeout(int n2) throws XAException {
        if (n2 < 0) {
            throw this.getXAException(5);
        }
        this.timeout = n2;
        return true;
    }

    @Override
    protected int getTransactionTimeout() throws XAException {
        return this.timeout;
    }

    @Override
    protected String getRmIdentification() throws XAException {
        String string = this.connectProps.R("serverName");
        String string2 = this.connectProps.R("portNumber");
        String string3 = this.connectProps.R("SID");
        String string4 = new String(this.connectProps.et());
        return string + "_" + string2 + "_" + string3 + "_" + string4;
    }

    void checkErrorPacket() throws XAException, SQLException {
        if (this.gTTIoer.aqh == 0) {
            return;
        }
        if (this.gTTIoer.aqh != 2091 && this.gTTIoer.aqh != 24756 && this.gTTIoer.aqh != 24757 && this.gTTIoer.aqh != 24776) {
            String[] stringArray = new String[]{this.gTTIoer.aqC};
            throw this.implConn.gV.exceptions.a(6001, stringArray, this.gTTIoer.getSQLState(), this.gTTIoer.aqh);
        }
        this.generateXAException(this.gTTIoer.aqh);
    }

    void generateXAException(int n2) throws XAException {
        int n3 = -3;
        Object var3_3 = null;
        switch (n2 & 0xFFFF) {
            case 2091: {
                n3 = 100;
                break;
            }
            case 24756: {
                n3 = -4;
                break;
            }
            case 25351: {
                n3 = 4;
                break;
            }
            case 24757: {
                n3 = -8;
                break;
            }
            case 24764: {
                n3 = 7;
                break;
            }
            case 24765: {
                n3 = 6;
                break;
            }
            case 24766: {
                n3 = 5;
                break;
            }
            case 24767: {
                n3 = 3;
                break;
            }
            case 3113: 
            case 3114: {
                n3 = -7;
                break;
            }
            case 24763: 
            case 24769: 
            case 24770: 
            case 24776: {
                n3 = -6;
            }
        }
        String[] stringArray = new String[]{Integer.toString(n2)};
        XAException xAException = new XAException(this.exceptions.a(10412, stringArray).getMessage());
        xAException.errorCode = n3;
        throw xAException;
    }

    XAException getXAException(int n2) {
        return this.getXAException(n2, null);
    }

    XAException getXAException(int n2, String string) {
        XAException xAException;
        switch (n2) {
            case 1: {
                xAException = new XAException(this.exceptions.bm(10413).getMessage());
                xAException.errorCode = -5;
                break;
            }
            case 2: {
                xAException = new XAException(this.exceptions.bm(10414).getMessage());
                xAException.errorCode = -6;
                break;
            }
            case 3: {
                xAException = new XAException(this.exceptions.bm(10415).getMessage());
                xAException.errorCode = -6;
                break;
            }
            case 4: {
                xAException = new XAException(this.exceptions.bm(10416).getMessage());
                xAException.errorCode = -3;
                break;
            }
            case 5: {
                xAException = new XAException(this.exceptions.bm(10417).getMessage());
                xAException.errorCode = -5;
            }
            default: {
                xAException = new XAException(string);
                xAException.errorCode = -3;
            }
        }
        return xAException;
    }
}

