/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.slbase;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.sql.SQLException;
import macromedia.jdbc.slbase.BaseData;
import macromedia.jdbc.slbase.BaseExceptions;
import macromedia.jdbc.slbase.BaseImplBlob;
import macromedia.jdbc.slbase.BaseImplClob;
import macromedia.jdbc.slbase.BaseImplStatement;
import macromedia.jdbc.slbase.BaseWarnings;

public abstract class BaseImplResultSet {
    public int type;
    protected BaseImplStatement implStatement;
    protected BaseExceptions exceptions;
    protected BaseWarnings warnings;
    protected int cursorPosition;
    protected int maxCursorPosition;
    protected static final int COLUMN_ACCESS_IN_ORDER = 1;
    protected static final int COLUMN_ACCESS_UNLIMITED = 2;

    public BaseImplResultSet() {
        this.reset();
    }

    public void setMaxCursorPosition(int n2) {
        this.maxCursorPosition = n2;
    }

    public void setImplStatement(BaseImplStatement baseImplStatement) {
        this.implStatement = baseImplStatement;
        this.exceptions = baseImplStatement.implConnection.exceptions;
    }

    public void setWarnings(BaseWarnings baseWarnings) {
        this.warnings = baseWarnings;
    }

    public void postSetupInitialize() throws SQLException {
    }

    public void reset() {
        this.cursorPosition = 0;
        this.maxCursorPosition = -1;
        this.exceptions = null;
        if (this.warnings != null) {
            this.warnings.clear();
        }
    }

    public void close() throws SQLException {
        this.reset();
        this.implStatement.implConnection.cacheImplResultSet(this);
    }

    public int getColumnAccess() {
        return 1;
    }

    public int getConcurrency() {
        return 1007;
    }

    public int getScrollType() {
        return 1003;
    }

    public void setFetchSize(int n2) {
    }

    public abstract BaseData getData(int var1, int var2) throws SQLException;

    public void updateData(int n2, BaseData baseData) throws SQLException {
    }

    public void updateRow() throws SQLException {
    }

    public void deleteRow() throws SQLException {
    }

    public void prepareInsertRow() throws SQLException {
    }

    public void cancelInsertRow() throws SQLException {
    }

    public void insertRow() throws SQLException {
    }

    public void cancelUpdates() throws SQLException {
    }

    public boolean fetchAtPosition(int n2) throws SQLException {
        return true;
    }

    protected boolean next() throws SQLException {
        boolean bl2 = true;
        if (this.maxCursorPosition == 0) {
            this.cursorPosition = 1;
            bl2 = false;
        } else if (this.maxCursorPosition > -1) {
            if (this.maxCursorPosition == this.cursorPosition) {
                ++this.cursorPosition;
                bl2 = false;
            } else if (this.maxCursorPosition < this.cursorPosition) {
                bl2 = false;
            }
        }
        if (bl2) {
            ++this.cursorPosition;
            bl2 = this.fetchAtPosition(this.cursorPosition);
            if (!bl2) {
                this.maxCursorPosition = this.cursorPosition - 1;
            }
        }
        return bl2;
    }

    protected boolean previous() throws SQLException {
        boolean bl2 = true;
        if (this.maxCursorPosition == 0) {
            bl2 = false;
        } else {
            if (this.cursorPosition > 0) {
                --this.cursorPosition;
            }
            bl2 = this.cursorPosition == 0 ? false : this.fetchAtPosition(this.cursorPosition);
        }
        return bl2;
    }

    protected boolean absolute(int n2) throws SQLException {
        boolean bl2 = true;
        if (n2 == 0) {
            throw this.exceptions.getException(6041, "HY107");
        }
        if (this.maxCursorPosition == 0) {
            bl2 = false;
        } else if (n2 > 0) {
            boolean bl3 = false;
            if (this.maxCursorPosition != -1 && n2 > this.maxCursorPosition) {
                this.cursorPosition = this.maxCursorPosition + 1;
                bl2 = false;
            }
            if (bl2 && !(bl2 = this.fetchAtPosition(n2)) && n2 > this.maxCursorPosition) {
                this.cursorPosition = this.maxCursorPosition + 1;
            }
        } else {
            bl2 = this.last();
            if (bl2) {
                if ((n2 = this.maxCursorPosition + n2 + 1) < 1) {
                    bl2 = false;
                    this.cursorPosition = 0;
                } else {
                    bl2 = this.fetchAtPosition(n2);
                }
            }
        }
        if (bl2) {
            this.cursorPosition = n2;
        }
        return bl2;
    }

    protected boolean relative(int n2) throws SQLException {
        boolean bl2 = true;
        if (this.maxCursorPosition == 0) {
            bl2 = false;
            throw this.exceptions.getException(6042, "HY109");
        }
        if (this.cursorPosition == 0 || this.maxCursorPosition > -1 && this.cursorPosition > this.maxCursorPosition) {
            throw this.exceptions.getException(6042, "HY109");
        }
        if (n2 == 0) {
            bl2 = true;
        } else {
            int n3 = this.cursorPosition + n2;
            if (n3 == 0) {
                this.cursorPosition = 0;
                bl2 = false;
            } else {
                bl2 = this.absolute(n3);
            }
        }
        return bl2;
    }

    protected boolean first() throws SQLException {
        boolean bl2 = false;
        bl2 = this.fetchAtPosition(1);
        if (bl2) {
            this.cursorPosition = 1;
        }
        return bl2;
    }

    protected boolean last() throws SQLException {
        boolean bl2 = false;
        this.afterLast();
        if (this.cursorPosition > 1 && (bl2 = this.fetchAtPosition(this.maxCursorPosition))) {
            this.cursorPosition = this.maxCursorPosition;
        }
        return bl2;
    }

    protected void beforeFirst() throws SQLException {
        this.cursorPosition = 0;
    }

    protected void afterLast() throws SQLException {
        if (this.maxCursorPosition == -1) {
            while (this.next()) {
            }
        } else if (this.maxCursorPosition != 0) {
            this.fetchAtPosition(this.maxCursorPosition);
        }
        this.cursorPosition = this.maxCursorPosition + 1;
    }

    protected boolean isFirst() throws SQLException {
        return this.maxCursorPosition != 0 && this.cursorPosition == 1;
    }

    protected boolean isLast() throws SQLException {
        return this.maxCursorPosition > 0 && this.cursorPosition == this.maxCursorPosition;
    }

    protected boolean isBeforeFirst() throws SQLException {
        if (this.maxCursorPosition == 0) {
            return false;
        }
        return this.cursorPosition == 0;
    }

    protected boolean isAfterLast() throws SQLException {
        return this.maxCursorPosition > 0 && this.cursorPosition > this.maxCursorPosition;
    }

    public boolean onDeletedRow() throws SQLException {
        return false;
    }

    protected int getRow() throws SQLException {
        if (this.cursorPosition == 0 || this.maxCursorPosition > -1 && this.cursorPosition > this.maxCursorPosition) {
            return 0;
        }
        return this.cursorPosition;
    }

    protected void refreshRow() throws SQLException {
    }

    protected boolean isCursorPositionValid() throws SQLException {
        return this.cursorPosition > 0 && (this.maxCursorPosition == -1 || this.cursorPosition <= this.maxCursorPosition);
    }

    public void writeBlob(RandomAccessFile randomAccessFile, BaseImplBlob baseImplBlob) throws SQLException, IOException {
    }

    public BaseImplBlob readBlob(RandomAccessFile randomAccessFile) throws SQLException, IOException {
        return null;
    }

    public void writeClob(RandomAccessFile randomAccessFile, BaseImplClob baseImplClob) throws SQLException, IOException {
    }

    public BaseImplClob readClob(RandomAccessFile randomAccessFile) throws SQLException, IOException {
        return null;
    }

    protected boolean setupForNextResultSetInMultipleResult(int n2) throws SQLException {
        return false;
    }
}

