/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.oracle.externals.org.bouncycastle.pqc.crypto.sphincsplus;

import macromedia.jdbc.oracle.externals.org.bouncycastle.pqc.crypto.sphincsplus.ADRS;
import macromedia.jdbc.oracle.externals.org.bouncycastle.pqc.crypto.sphincsplus.SPHINCSPlusEngine;
import macromedia.jdbc.oracle.externals.org.bouncycastle.util.Arrays;
import macromedia.jdbc.oracle.externals.org.bouncycastle.util.Pack;

class WotsPlus {
    private final SPHINCSPlusEngine engine;
    private final int w;

    WotsPlus(SPHINCSPlusEngine sPHINCSPlusEngine) {
        this.engine = sPHINCSPlusEngine;
        this.w = this.engine.WOTS_W;
    }

    byte[] pkGen(byte[] byArray, byte[] byArray2, ADRS aDRS) {
        ADRS aDRS2 = new ADRS(aDRS);
        byte[][] byArrayArray = new byte[this.engine.WOTS_LEN][];
        for (int i2 = 0; i2 < this.engine.WOTS_LEN; ++i2) {
            ADRS aDRS3 = new ADRS(aDRS);
            aDRS3.setChainAddress(i2);
            aDRS3.setHashAddress(0);
            byte[] byArray3 = this.engine.PRF(byArray2, byArray, aDRS3);
            byArrayArray[i2] = this.chain(byArray3, 0, this.w - 1, byArray2, aDRS3);
        }
        aDRS2.setType(1);
        aDRS2.setKeyPairAddress(aDRS.getKeyPairAddress());
        return this.engine.T_l(byArray2, aDRS2, Arrays.concatenate(byArrayArray));
    }

    byte[] chain(byte[] byArray, int n2, int n3, byte[] byArray2, ADRS aDRS) {
        if (n3 == 0) {
            return Arrays.clone(byArray);
        }
        if (n2 + n3 > this.w - 1) {
            return null;
        }
        byte[] byArray3 = this.chain(byArray, n2, n3 - 1, byArray2, aDRS);
        aDRS.setHashAddress(n2 + n3 - 1);
        byArray3 = this.engine.F(byArray2, aDRS, byArray3);
        return byArray3;
    }

    public byte[] sign(byte[] byArray, byte[] byArray2, byte[] byArray3, ADRS aDRS) {
        int n2;
        ADRS aDRS2 = new ADRS(aDRS);
        int n3 = 0;
        int[] nArray = this.base_w(byArray, this.w, this.engine.WOTS_LEN1);
        for (n2 = 0; n2 < this.engine.WOTS_LEN1; ++n2) {
            n3 += this.w - 1 - nArray[n2];
        }
        if (this.engine.WOTS_LOGW % 8 != 0) {
            n3 <<= 8 - this.engine.WOTS_LEN2 * this.engine.WOTS_LOGW % 8;
        }
        n2 = (this.engine.WOTS_LEN2 * this.engine.WOTS_LOGW + 7) / 8;
        byte[] byArray4 = Pack.intToBigEndian(n3);
        nArray = Arrays.concatenate(nArray, this.base_w(Arrays.copyOfRange(byArray4, n2, byArray4.length), this.w, this.engine.WOTS_LEN2));
        byte[][] byArrayArray = new byte[this.engine.WOTS_LEN][];
        for (int i2 = 0; i2 < this.engine.WOTS_LEN; ++i2) {
            aDRS2.setChainAddress(i2);
            aDRS2.setHashAddress(0);
            byte[] byArray5 = this.engine.PRF(byArray3, byArray2, aDRS2);
            byArrayArray[i2] = this.chain(byArray5, 0, nArray[i2], byArray3, aDRS2);
        }
        return Arrays.concatenate(byArrayArray);
    }

    int[] base_w(byte[] byArray, int n2, int n3) {
        int n4 = 0;
        int n5 = 0;
        byte by2 = 0;
        int n6 = 0;
        int[] nArray = new int[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            if (n6 == 0) {
                by2 = byArray[n4];
                ++n4;
                n6 += 8;
            }
            nArray[n5] = by2 >>> (n6 -= this.engine.WOTS_LOGW) & n2 - 1;
            ++n5;
        }
        return nArray;
    }

    public byte[] pkFromSig(byte[] byArray, byte[] byArray2, byte[] byArray3, ADRS aDRS) {
        int n2;
        int n3 = 0;
        ADRS aDRS2 = new ADRS(aDRS);
        int[] nArray = this.base_w(byArray2, this.w, this.engine.WOTS_LEN1);
        for (n2 = 0; n2 < this.engine.WOTS_LEN1; ++n2) {
            n3 += this.w - 1 - nArray[n2];
        }
        n2 = (this.engine.WOTS_LEN2 * this.engine.WOTS_LOGW + 7) / 8;
        nArray = Arrays.concatenate(nArray, this.base_w(Arrays.copyOfRange(Pack.intToBigEndian(n3 <<= 8 - this.engine.WOTS_LEN2 * this.engine.WOTS_LOGW % 8), 4 - n2, 4), this.w, this.engine.WOTS_LEN2));
        byte[] byArray4 = new byte[this.engine.N];
        byte[][] byArrayArray = new byte[this.engine.WOTS_LEN][];
        for (int i2 = 0; i2 < this.engine.WOTS_LEN; ++i2) {
            aDRS.setChainAddress(i2);
            System.arraycopy(byArray, i2 * this.engine.N, byArray4, 0, this.engine.N);
            byArrayArray[i2] = this.chain(byArray4, nArray[i2], this.w - 1 - nArray[i2], byArray3, aDRS);
        }
        aDRS2.setType(1);
        aDRS2.setKeyPairAddress(aDRS.getKeyPairAddress());
        return this.engine.T_l(byArray3, aDRS2, Arrays.concatenate(byArrayArray));
    }
}

