/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.oracle.externals.org.bouncycastle.pqc.crypto.sphincsplus;

import macromedia.jdbc.oracle.externals.org.bouncycastle.pqc.crypto.sphincsplus.PK;
import macromedia.jdbc.oracle.externals.org.bouncycastle.pqc.crypto.sphincsplus.SK;
import macromedia.jdbc.oracle.externals.org.bouncycastle.pqc.crypto.sphincsplus.SPHINCSPlusKeyParameters;
import macromedia.jdbc.oracle.externals.org.bouncycastle.pqc.crypto.sphincsplus.SPHINCSPlusParameters;
import macromedia.jdbc.oracle.externals.org.bouncycastle.util.Arrays;
import macromedia.jdbc.oracle.externals.org.bouncycastle.util.Pack;

public class SPHINCSPlusPrivateKeyParameters
extends SPHINCSPlusKeyParameters {
    final SK sk;
    final PK pk;

    public SPHINCSPlusPrivateKeyParameters(SPHINCSPlusParameters sPHINCSPlusParameters, byte[] byArray) {
        super(true, sPHINCSPlusParameters);
        int n2 = sPHINCSPlusParameters.getEngine().N;
        if (byArray.length != 4 * n2) {
            throw new IllegalArgumentException("private key encoding does not match parameters");
        }
        this.sk = new SK(Arrays.copyOfRange(byArray, 0, n2), Arrays.copyOfRange(byArray, n2, 2 * n2));
        this.pk = new PK(Arrays.copyOfRange(byArray, 2 * n2, 3 * n2), Arrays.copyOfRange(byArray, 3 * n2, 4 * n2));
    }

    SPHINCSPlusPrivateKeyParameters(SPHINCSPlusParameters sPHINCSPlusParameters, SK sK, PK pK) {
        super(true, sPHINCSPlusParameters);
        this.sk = sK;
        this.pk = pK;
    }

    public byte[] getSeed() {
        return Arrays.clone(this.sk.seed);
    }

    public byte[] getPrf() {
        return Arrays.clone(this.sk.prf);
    }

    public byte[] getPublicSeed() {
        return Arrays.clone(this.pk.seed);
    }

    public byte[] getPublicKey() {
        return Arrays.concatenate(this.pk.seed, this.pk.root);
    }

    public byte[] getEncoded() {
        return Arrays.concatenate(Pack.intToBigEndian(SPHINCSPlusParameters.getID(this.getParameters())), Arrays.concatenate(this.sk.seed, this.sk.prf, this.pk.seed, this.pk.root));
    }

    public byte[] getEncodedPublicKey() {
        return Arrays.concatenate(Pack.intToBigEndian(SPHINCSPlusParameters.getID(this.getParameters())), this.pk.seed, this.pk.root);
    }
}

