/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.oracle.externals.org.bouncycastle.asn1;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import macromedia.jdbc.oracle.externals.org.bouncycastle.asn1.ASN1Encodable;
import macromedia.jdbc.oracle.externals.org.bouncycastle.asn1.ASN1OctetString;
import macromedia.jdbc.oracle.externals.org.bouncycastle.asn1.ASN1OutputStream;
import macromedia.jdbc.oracle.externals.org.bouncycastle.asn1.ASN1Primitive;
import macromedia.jdbc.oracle.externals.org.bouncycastle.asn1.ASN1RelativeOID;
import macromedia.jdbc.oracle.externals.org.bouncycastle.asn1.ASN1TaggedObject;
import macromedia.jdbc.oracle.externals.org.bouncycastle.asn1.ASN1UniversalType;
import macromedia.jdbc.oracle.externals.org.bouncycastle.asn1.DEROctetString;
import macromedia.jdbc.oracle.externals.org.bouncycastle.asn1.OIDTokenizer;
import macromedia.jdbc.oracle.externals.org.bouncycastle.util.Arrays;

public class ASN1ObjectIdentifier
extends ASN1Primitive {
    static final ASN1UniversalType TYPE = new ASN1UniversalType(ASN1ObjectIdentifier.class, 6){

        @Override
        ASN1Primitive fromImplicitPrimitive(DEROctetString dEROctetString) {
            return ASN1ObjectIdentifier.createPrimitive(dEROctetString.getOctets(), false);
        }
    };
    private static final long LONG_LIMIT = 0xFFFFFFFFFFFF80L;
    private static final ConcurrentMap<OidHandle, ASN1ObjectIdentifier> pool = new ConcurrentHashMap<OidHandle, ASN1ObjectIdentifier>();
    private final String identifier;
    private byte[] contents;

    public static ASN1ObjectIdentifier fromContents(byte[] byArray) {
        return ASN1ObjectIdentifier.createPrimitive(byArray, true);
    }

    public static ASN1ObjectIdentifier getInstance(Object object) {
        if (object == null || object instanceof ASN1ObjectIdentifier) {
            return (ASN1ObjectIdentifier)object;
        }
        if (object instanceof ASN1Encodable) {
            ASN1Primitive aSN1Primitive = ((ASN1Encodable)object).toASN1Primitive();
            if (aSN1Primitive instanceof ASN1ObjectIdentifier) {
                return (ASN1ObjectIdentifier)aSN1Primitive;
            }
        } else if (object instanceof byte[]) {
            try {
                return (ASN1ObjectIdentifier)TYPE.fromByteArray((byte[])object);
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("failed to construct object identifier from byte[]: " + iOException.getMessage());
            }
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + object.getClass().getName());
    }

    public static ASN1ObjectIdentifier getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl2) {
        ASN1Primitive aSN1Primitive;
        if (!(bl2 || aSN1TaggedObject.isParsed() || (aSN1Primitive = aSN1TaggedObject.getObject()) instanceof ASN1ObjectIdentifier)) {
            return ASN1ObjectIdentifier.fromContents(ASN1OctetString.getInstance(aSN1Primitive).getOctets());
        }
        return (ASN1ObjectIdentifier)TYPE.getContextInstance(aSN1TaggedObject, bl2);
    }

    ASN1ObjectIdentifier(byte[] byArray, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer();
        long l2 = 0L;
        BigInteger bigInteger = null;
        boolean bl3 = true;
        for (int i2 = 0; i2 != byArray.length; ++i2) {
            int n2 = byArray[i2] & 0xFF;
            if (l2 <= 0xFFFFFFFFFFFF80L) {
                l2 += (long)(n2 & 0x7F);
                if ((n2 & 0x80) == 0) {
                    if (bl3) {
                        if (l2 < 40L) {
                            stringBuffer.append('0');
                        } else if (l2 < 80L) {
                            stringBuffer.append('1');
                            l2 -= 40L;
                        } else {
                            stringBuffer.append('2');
                            l2 -= 80L;
                        }
                        bl3 = false;
                    }
                    stringBuffer.append('.');
                    stringBuffer.append(l2);
                    l2 = 0L;
                    continue;
                }
                l2 <<= 7;
                continue;
            }
            if (bigInteger == null) {
                bigInteger = BigInteger.valueOf(l2);
            }
            bigInteger = bigInteger.or(BigInteger.valueOf(n2 & 0x7F));
            if ((n2 & 0x80) == 0) {
                if (bl3) {
                    stringBuffer.append('2');
                    bigInteger = bigInteger.subtract(BigInteger.valueOf(80L));
                    bl3 = false;
                }
                stringBuffer.append('.');
                stringBuffer.append(bigInteger);
                bigInteger = null;
                l2 = 0L;
                continue;
            }
            bigInteger = bigInteger.shiftLeft(7);
        }
        this.identifier = stringBuffer.toString();
        this.contents = bl2 ? Arrays.clone(byArray) : byArray;
    }

    public ASN1ObjectIdentifier(String string) {
        if (string == null) {
            throw new NullPointerException("'identifier' cannot be null");
        }
        if (!ASN1ObjectIdentifier.isValidIdentifier(string)) {
            throw new IllegalArgumentException("string " + string + " not an OID");
        }
        this.identifier = string;
    }

    ASN1ObjectIdentifier(ASN1ObjectIdentifier aSN1ObjectIdentifier, String string) {
        if (!ASN1RelativeOID.isValidIdentifier(string, 0)) {
            throw new IllegalArgumentException("string " + string + " not a valid OID branch");
        }
        this.identifier = aSN1ObjectIdentifier.getId() + "." + string;
    }

    public String getId() {
        return this.identifier;
    }

    public ASN1ObjectIdentifier branch(String string) {
        return new ASN1ObjectIdentifier(this, string);
    }

    public boolean on(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        String string = this.getId();
        String string2 = aSN1ObjectIdentifier.getId();
        return string.length() > string2.length() && string.charAt(string2.length()) == '.' && string.startsWith(string2);
    }

    private void doOutput(ByteArrayOutputStream byteArrayOutputStream) {
        OIDTokenizer oIDTokenizer = new OIDTokenizer(this.identifier);
        int n2 = Integer.parseInt(oIDTokenizer.nextToken()) * 40;
        String string = oIDTokenizer.nextToken();
        if (string.length() <= 18) {
            ASN1RelativeOID.writeField(byteArrayOutputStream, (long)n2 + Long.parseLong(string));
        } else {
            ASN1RelativeOID.writeField(byteArrayOutputStream, new BigInteger(string).add(BigInteger.valueOf(n2)));
        }
        while (oIDTokenizer.hasMoreTokens()) {
            String string2 = oIDTokenizer.nextToken();
            if (string2.length() <= 18) {
                ASN1RelativeOID.writeField(byteArrayOutputStream, Long.parseLong(string2));
                continue;
            }
            ASN1RelativeOID.writeField(byteArrayOutputStream, new BigInteger(string2));
        }
    }

    private synchronized byte[] getContents() {
        if (this.contents == null) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            this.doOutput(byteArrayOutputStream);
            this.contents = byteArrayOutputStream.toByteArray();
        }
        return this.contents;
    }

    @Override
    boolean encodeConstructed() {
        return false;
    }

    @Override
    int encodedLength(boolean bl2) {
        return ASN1OutputStream.getLengthOfEncodingDL(bl2, this.getContents().length);
    }

    @Override
    void encode(ASN1OutputStream aSN1OutputStream, boolean bl2) throws IOException {
        aSN1OutputStream.writeEncodingDL(bl2, 6, this.getContents());
    }

    @Override
    public int hashCode() {
        return this.identifier.hashCode();
    }

    @Override
    boolean asn1Equals(ASN1Primitive aSN1Primitive) {
        if (aSN1Primitive == this) {
            return true;
        }
        if (!(aSN1Primitive instanceof ASN1ObjectIdentifier)) {
            return false;
        }
        return this.identifier.equals(((ASN1ObjectIdentifier)aSN1Primitive).identifier);
    }

    public String toString() {
        return this.getId();
    }

    private static boolean isValidIdentifier(String string) {
        if (string.length() < 3 || string.charAt(1) != '.') {
            return false;
        }
        char c2 = string.charAt(0);
        if (c2 < '0' || c2 > '2') {
            return false;
        }
        return ASN1RelativeOID.isValidIdentifier(string, 2);
    }

    public ASN1ObjectIdentifier intern() {
        OidHandle oidHandle = new OidHandle(this.getContents());
        ASN1ObjectIdentifier aSN1ObjectIdentifier = (ASN1ObjectIdentifier)pool.get(oidHandle);
        if (aSN1ObjectIdentifier == null && (aSN1ObjectIdentifier = pool.putIfAbsent(oidHandle, this)) == null) {
            aSN1ObjectIdentifier = this;
        }
        return aSN1ObjectIdentifier;
    }

    static ASN1ObjectIdentifier createPrimitive(byte[] byArray, boolean bl2) {
        OidHandle oidHandle = new OidHandle(byArray);
        ASN1ObjectIdentifier aSN1ObjectIdentifier = (ASN1ObjectIdentifier)pool.get(oidHandle);
        if (aSN1ObjectIdentifier == null) {
            return new ASN1ObjectIdentifier(byArray, bl2);
        }
        return aSN1ObjectIdentifier;
    }

    private static class OidHandle {
        private final int key;
        private final byte[] contents;

        OidHandle(byte[] byArray) {
            this.key = Arrays.hashCode(byArray);
            this.contents = byArray;
        }

        public int hashCode() {
            return this.key;
        }

        public boolean equals(Object object) {
            if (object instanceof OidHandle) {
                return Arrays.areEqual(this.contents, ((OidHandle)object).contents);
            }
            return false;
        }
    }
}

