/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.oracle.externals.org.bouncycastle.asn1;

import java.io.IOException;
import macromedia.jdbc.oracle.externals.org.bouncycastle.asn1.ASN1ApplicationSpecificParser;
import macromedia.jdbc.oracle.externals.org.bouncycastle.asn1.ASN1Encodable;
import macromedia.jdbc.oracle.externals.org.bouncycastle.asn1.ASN1Exception;
import macromedia.jdbc.oracle.externals.org.bouncycastle.asn1.ASN1OutputStream;
import macromedia.jdbc.oracle.externals.org.bouncycastle.asn1.ASN1Primitive;
import macromedia.jdbc.oracle.externals.org.bouncycastle.asn1.ASN1Sequence;
import macromedia.jdbc.oracle.externals.org.bouncycastle.asn1.ASN1TaggedObject;
import macromedia.jdbc.oracle.externals.org.bouncycastle.asn1.ASN1TaggedObjectParser;
import macromedia.jdbc.oracle.externals.org.bouncycastle.asn1.DERApplicationSpecific;
import macromedia.jdbc.oracle.externals.org.bouncycastle.asn1.DLApplicationSpecific;

public abstract class ASN1ApplicationSpecific
extends ASN1TaggedObject
implements ASN1ApplicationSpecificParser {
    final ASN1TaggedObject taggedObject;

    public static ASN1ApplicationSpecific getInstance(Object object) {
        if (object == null || object instanceof ASN1ApplicationSpecific) {
            return (ASN1ApplicationSpecific)object;
        }
        if (object instanceof byte[]) {
            try {
                return ASN1ApplicationSpecific.getInstance(ASN1Primitive.fromByteArray((byte[])object));
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("Failed to construct object from byte[]: " + iOException.getMessage());
            }
        }
        throw new IllegalArgumentException("unknown object in getInstance: " + object.getClass().getName());
    }

    ASN1ApplicationSpecific(ASN1TaggedObject aSN1TaggedObject) {
        super(aSN1TaggedObject.explicitness, ASN1ApplicationSpecific.checkTagClass(aSN1TaggedObject.tagClass), aSN1TaggedObject.tagNo, aSN1TaggedObject.obj);
        this.taggedObject = aSN1TaggedObject;
    }

    public int getApplicationTag() {
        return this.taggedObject.getTagNo();
    }

    @Override
    public byte[] getContents() {
        return this.taggedObject.getContents();
    }

    public ASN1Primitive getEnclosedObject() throws IOException {
        return this.taggedObject.getBaseObject().toASN1Primitive();
    }

    public ASN1Primitive getObject(int n2) throws IOException {
        return this.taggedObject.getBaseUniversal(false, n2);
    }

    @Override
    public ASN1Encodable getObjectParser(int n2, boolean bl2) throws IOException {
        throw new ASN1Exception("this method only valid for CONTEXT_SPECIFIC tags");
    }

    @Override
    public ASN1Encodable parseBaseUniversal(boolean bl2, int n2) throws IOException {
        return this.taggedObject.parseBaseUniversal(bl2, n2);
    }

    @Override
    public ASN1Encodable parseExplicitBaseObject() throws IOException {
        return this.taggedObject.parseExplicitBaseObject();
    }

    @Override
    public ASN1TaggedObjectParser parseExplicitBaseTagged() throws IOException {
        return this.taggedObject.parseExplicitBaseTagged();
    }

    @Override
    public ASN1TaggedObjectParser parseImplicitBaseTagged(int n2, int n3) throws IOException {
        return this.taggedObject.parseImplicitBaseTagged(n2, n3);
    }

    public boolean hasApplicationTag(int n2) {
        return this.tagNo == n2;
    }

    @Override
    public boolean hasContextTag(int n2) {
        return false;
    }

    public ASN1TaggedObject getTaggedObject() {
        return this.taggedObject;
    }

    @Override
    public boolean isConstructed() {
        return this.taggedObject.isConstructed();
    }

    @Override
    public ASN1Encodable readObject() throws IOException {
        return this.parseExplicitBaseObject();
    }

    @Override
    boolean encodeConstructed() {
        return this.taggedObject.encodeConstructed();
    }

    @Override
    int encodedLength(boolean bl2) throws IOException {
        return this.taggedObject.encodedLength(bl2);
    }

    @Override
    void encode(ASN1OutputStream aSN1OutputStream, boolean bl2) throws IOException {
        this.taggedObject.encode(aSN1OutputStream, bl2);
    }

    @Override
    String getASN1Encoding() {
        return this.taggedObject.getASN1Encoding();
    }

    @Override
    ASN1Sequence rebuildConstructed(ASN1Primitive aSN1Primitive) {
        return this.taggedObject.rebuildConstructed(aSN1Primitive);
    }

    @Override
    ASN1TaggedObject replaceTag(int n2, int n3) {
        return this.taggedObject.replaceTag(n2, n3);
    }

    @Override
    ASN1Primitive toDERObject() {
        return new DERApplicationSpecific((ASN1TaggedObject)this.taggedObject.toDERObject());
    }

    @Override
    ASN1Primitive toDLObject() {
        return new DLApplicationSpecific((ASN1TaggedObject)this.taggedObject.toDLObject());
    }

    private static int checkTagClass(int n2) {
        if (64 != n2) {
            throw new IllegalArgumentException();
        }
        return n2;
    }
}

