/*
 * Decompiled with CFR 0.152.
 */
package macromedia.sequelink.util;

import macromedia.sequelink.util.UnSyncVector;
import macromedia.sequelink.util.UtilMessage;

public class BufferManager {
    private static final int MinBufferSize = 32000;
    private static final int SizeIncrement = 32000;
    private static final int InitialPoolSize = 1;
    private static final int MaxPoolSize = 4;
    private static final UnSyncVector Pool = new UnSyncVector();

    public static final byte[] GetBuffer() {
        return BufferManager.GetBuffer(32000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final byte[] GetBuffer(int n2) {
        if (n2 >= 2147451647) {
            throw new ArrayIndexOutOfBoundsException(UtilMessage.Gen.getPrefixedMessage("err.bm.toobig"));
        }
        if (n2 <= 32000) {
            UnSyncVector unSyncVector = Pool;
            synchronized (unSyncVector) {
                if (Pool.size() > 0) {
                    byte[] byArray = (byte[])Pool.elementAt(0);
                    Pool.removeElementAt(0);
                    return byArray;
                }
            }
            return new byte[32000];
        }
        int n3 = (n2 - 32000 - 1) / 32000 + 1;
        return new byte[32000 + n3 * 32000];
    }

    public static final byte[] GetBiggerBuffer(byte[] byArray) {
        int n2 = byArray.length + 32000;
        if (n2 >= 2147451647) {
            throw new ArrayIndexOutOfBoundsException(UtilMessage.Gen.getPrefixedMessage("err.bm.toobig"));
        }
        byte[] byArray2 = new byte[byArray.length + 32000];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        BufferManager.ReturnBuffer(byArray);
        return byArray2;
    }

    public static final byte[] GetBiggerBuffer(byte[] byArray, int n2) {
        if (n2 <= byArray.length) {
            return byArray;
        }
        if (n2 >= 2147451647) {
            throw new ArrayIndexOutOfBoundsException(UtilMessage.Gen.getPrefixedMessage("err.bm.toobig"));
        }
        int n3 = (n2 - 32000 - 1) / 32000 + 1;
        byte[] byArray2 = new byte[32000 + n3 * 32000];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        BufferManager.ReturnBuffer(byArray);
        return byArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void ReturnBuffer(byte[] byArray) {
        UnSyncVector unSyncVector = Pool;
        synchronized (unSyncVector) {
            if (Pool.size() <= 4 && byArray.length <= 32000) {
                byte[] byArray2 = byArray;
                Pool.addElement(byArray2);
            }
        }
    }

    public static final int getIncrement() {
        return 32000;
    }

    static {
        for (int i2 = 0; i2 < 1; ++i2) {
            Pool.addElement(new byte[32000]);
        }
    }
}

