/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.net.minidev.json;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONArray;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONAwareEx;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONStreamAwareEx;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONStyle;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONValue;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.reader.JsonWriter;

public class JSONObject
extends HashMap<String, Object>
implements JSONAwareEx,
JSONStreamAwareEx {
    private static final long serialVersionUID = -503443796854799292L;

    public JSONObject() {
    }

    public JSONObject(int n2) {
        super(n2);
    }

    public static String escape(String string) {
        return JSONValue.escape(string);
    }

    public static String toJSONString(Map<String, ? extends Object> map) {
        return JSONObject.toJSONString(map, JSONValue.COMPRESSION);
    }

    public static String toJSONString(Map<String, ? extends Object> map, JSONStyle jSONStyle) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            JSONObject.writeJSON(map, stringBuilder, jSONStyle);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return stringBuilder.toString();
    }

    public static void writeJSONKV(String string, Object object, Appendable appendable, JSONStyle jSONStyle) throws IOException {
        if (string == null) {
            appendable.append("null");
        } else if (!jSONStyle.mustProtectKey(string)) {
            appendable.append(string);
        } else {
            appendable.append('\"');
            JSONValue.escape(string, appendable, jSONStyle);
            appendable.append('\"');
        }
        appendable.append(':');
        if (object instanceof String) {
            jSONStyle.writeString(appendable, (String)object);
        } else {
            JSONValue.writeJSONString(object, appendable, jSONStyle);
        }
    }

    public JSONObject appendField(String string, Object object) {
        this.put(string, object);
        return this;
    }

    public String getAsString(String string) {
        Object v2 = this.get(string);
        if (v2 == null) {
            return null;
        }
        return v2.toString();
    }

    public Number getAsNumber(String string) {
        Object v2 = this.get(string);
        if (v2 == null) {
            return null;
        }
        if (v2 instanceof Number) {
            return (Number)v2;
        }
        return Long.valueOf(v2.toString());
    }

    public JSONObject(Map<String, ?> map) {
        super(map);
    }

    public static void writeJSON(Map<String, ? extends Object> map, Appendable appendable) throws IOException {
        JSONObject.writeJSON(map, appendable, JSONValue.COMPRESSION);
    }

    public static void writeJSON(Map<String, ? extends Object> map, Appendable appendable, JSONStyle jSONStyle) throws IOException {
        if (map == null) {
            appendable.append("null");
            return;
        }
        JsonWriter.JSONMapWriter.writeJSONString(map, appendable, jSONStyle);
    }

    @Override
    public void writeJSONString(Appendable appendable) throws IOException {
        JSONObject.writeJSON(this, appendable, JSONValue.COMPRESSION);
    }

    @Override
    public void writeJSONString(Appendable appendable, JSONStyle jSONStyle) throws IOException {
        JSONObject.writeJSON(this, appendable, jSONStyle);
    }

    public void merge(Object object) {
        JSONObject.merge(this, object);
    }

    protected static JSONObject merge(JSONObject jSONObject, Object object) {
        if (object == null) {
            return jSONObject;
        }
        if (object instanceof JSONObject) {
            return JSONObject.merge(jSONObject, (JSONObject)object);
        }
        throw new RuntimeException("JSON merge can not merge JSONObject with " + object.getClass());
    }

    private static JSONObject merge(JSONObject jSONObject, JSONObject jSONObject2) {
        if (jSONObject2 == null) {
            return jSONObject;
        }
        for (String string : jSONObject.keySet()) {
            Object v2 = jSONObject.get(string);
            Object v3 = jSONObject2.get(string);
            if (v3 == null) continue;
            if (v2 instanceof JSONArray) {
                jSONObject.put(string, JSONObject.merge((JSONArray)v2, v3));
                continue;
            }
            if (v2 instanceof JSONObject) {
                jSONObject.put(string, JSONObject.merge((JSONObject)v2, v3));
                continue;
            }
            if (v2.equals(v3)) continue;
            if (v2.getClass().equals(v3.getClass())) {
                throw new RuntimeException("JSON merge can not merge two " + v2.getClass().getName() + " Object together");
            }
            throw new RuntimeException("JSON merge can not merge " + v2.getClass().getName() + " with " + v3.getClass().getName());
        }
        for (String string : jSONObject2.keySet()) {
            if (jSONObject.containsKey(string)) continue;
            jSONObject.put(string, jSONObject2.get(string));
        }
        return jSONObject;
    }

    protected static JSONArray merge(JSONArray jSONArray, Object object) {
        if (object == null) {
            return jSONArray;
        }
        if (jSONArray instanceof JSONArray) {
            return JSONObject.merge(jSONArray, (JSONArray)object);
        }
        jSONArray.add(object);
        return jSONArray;
    }

    private static JSONArray merge(JSONArray jSONArray, JSONArray jSONArray2) {
        jSONArray.addAll(jSONArray2);
        return jSONArray;
    }

    @Override
    public String toJSONString() {
        return JSONObject.toJSONString(this, JSONValue.COMPRESSION);
    }

    @Override
    public String toJSONString(JSONStyle jSONStyle) {
        return JSONObject.toJSONString(this, jSONStyle);
    }

    public String toString(JSONStyle jSONStyle) {
        return JSONObject.toJSONString(this, jSONStyle);
    }

    @Override
    public String toString() {
        return JSONObject.toJSONString(this, JSONValue.COMPRESSION);
    }
}

