/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.validators;

import java.net.URL;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JOSEException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JOSEObjectType;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWSAlgorithm;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.JWKSet;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.source.ImmutableJWKSet;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.source.ImmutableSecret;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.source.JWKSource;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.source.RemoteJWKSet;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.proc.BadJOSEException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.proc.JOSEObjectTypeVerifier;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.proc.JWEKeySelector;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.proc.JWSKeySelector;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.proc.JWSVerificationKeySelector;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.proc.SecurityContext;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.ResourceRetriever;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.EncryptedJWT;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.JWT;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.JWTClaimsSet;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.PlainJWT;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.SignedJWT;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.proc.BadJWTException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.proc.DefaultJWTProcessor;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.GeneralException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.auth.Secret;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.ClientID;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.Issuer;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.claims.LogoutTokenClaimsSet;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.op.OIDCProviderMetadata;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.rp.OIDCClientInformation;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.validators.AbstractJWTValidator;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.validators.IDTokenValidator;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.validators.LogoutTokenClaimsVerifier;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class LogoutTokenValidator
extends AbstractJWTValidator {
    public static final JOSEObjectType TYPE = new JOSEObjectType("logout+jwt");
    private final boolean requireTypedTokens;

    public LogoutTokenValidator(Issuer issuer, ClientID clientID, JWSAlgorithm jWSAlgorithm, JWKSet jWKSet) {
        this(issuer, clientID, new JWSVerificationKeySelector(jWSAlgorithm, new ImmutableJWKSet(jWKSet)), null);
    }

    public LogoutTokenValidator(Issuer issuer, ClientID clientID, JWSAlgorithm jWSAlgorithm, URL uRL) {
        this(issuer, clientID, jWSAlgorithm, uRL, null);
    }

    public LogoutTokenValidator(Issuer issuer, ClientID clientID, JWSAlgorithm jWSAlgorithm, URL uRL, ResourceRetriever resourceRetriever) {
        this(issuer, clientID, new JWSVerificationKeySelector(jWSAlgorithm, new RemoteJWKSet(uRL, resourceRetriever)), null);
    }

    public LogoutTokenValidator(Issuer issuer, ClientID clientID, JWSAlgorithm jWSAlgorithm, Secret secret) {
        this(issuer, clientID, new JWSVerificationKeySelector(jWSAlgorithm, new ImmutableSecret(secret.getValueBytes())), null);
    }

    @Deprecated
    public LogoutTokenValidator(Issuer issuer, ClientID clientID, JWSKeySelector<?> jWSKeySelector, JWEKeySelector<?> jWEKeySelector) {
        this(issuer, clientID, false, jWSKeySelector, jWEKeySelector);
    }

    public LogoutTokenValidator(Issuer issuer, ClientID clientID, boolean bl2, JWSKeySelector<?> jWSKeySelector, JWEKeySelector<?> jWEKeySelector) {
        super(TYPE, issuer, clientID, jWSKeySelector, jWEKeySelector);
        this.requireTypedTokens = bl2;
    }

    public LogoutTokenClaimsSet validate(JWT jWT) throws BadJOSEException, JOSEException {
        if (jWT instanceof PlainJWT) {
            throw new BadJWTException("Unsecured (plain) logout tokens are illegal");
        }
        if (jWT instanceof SignedJWT) {
            return this.validate((SignedJWT)jWT);
        }
        if (jWT instanceof EncryptedJWT) {
            return this.validate((EncryptedJWT)jWT);
        }
        throw new JOSEException("Unexpected JWT type: " + jWT.getClass());
    }

    private LogoutTokenClaimsSet validate(SignedJWT signedJWT) throws BadJOSEException, JOSEException {
        if (this.getJWSKeySelector() == null) {
            throw new BadJWTException("Verification of signed JWTs not configured");
        }
        DefaultJWTProcessor defaultJWTProcessor = new DefaultJWTProcessor();
        defaultJWTProcessor.setJWSTypeVerifier(new TypeVerifier(this.requireTypedTokens));
        defaultJWTProcessor.setJWSKeySelector(this.getJWSKeySelector());
        defaultJWTProcessor.setJWTClaimsSetVerifier(new LogoutTokenClaimsVerifier(this.getExpectedIssuer(), this.getClientID()));
        JWTClaimsSet jWTClaimsSet = defaultJWTProcessor.process(signedJWT, null);
        return LogoutTokenValidator.toLogoutTokenClaimsSet(jWTClaimsSet);
    }

    private LogoutTokenClaimsSet validate(EncryptedJWT encryptedJWT) throws BadJOSEException, JOSEException {
        if (this.getJWEKeySelector() == null) {
            throw new BadJWTException("Decryption of JWTs not configured");
        }
        if (this.getJWSKeySelector() == null) {
            throw new BadJWTException("Verification of signed JWTs not configured");
        }
        DefaultJWTProcessor defaultJWTProcessor = new DefaultJWTProcessor();
        defaultJWTProcessor.setJWETypeVerifier(new TypeVerifier(this.requireTypedTokens));
        defaultJWTProcessor.setJWSKeySelector(this.getJWSKeySelector());
        defaultJWTProcessor.setJWEKeySelector(this.getJWEKeySelector());
        defaultJWTProcessor.setJWTClaimsSetVerifier(new LogoutTokenClaimsVerifier(this.getExpectedIssuer(), this.getClientID()));
        JWTClaimsSet jWTClaimsSet = defaultJWTProcessor.process(encryptedJWT, null);
        return LogoutTokenValidator.toLogoutTokenClaimsSet(jWTClaimsSet);
    }

    private static LogoutTokenClaimsSet toLogoutTokenClaimsSet(JWTClaimsSet jWTClaimsSet) throws JOSEException {
        try {
            return new LogoutTokenClaimsSet(jWTClaimsSet);
        }
        catch (ParseException parseException) {
            throw new JOSEException(parseException.getMessage(), parseException);
        }
    }

    public static LogoutTokenValidator create(OIDCProviderMetadata oIDCProviderMetadata, OIDCClientInformation oIDCClientInformation, JWKSource<?> jWKSource) throws GeneralException {
        JWSKeySelector jWSKeySelector = IDTokenValidator.createJWSKeySelector(oIDCProviderMetadata, oIDCClientInformation);
        JWEKeySelector jWEKeySelector = IDTokenValidator.createJWEKeySelector(oIDCProviderMetadata, oIDCClientInformation, jWKSource);
        return new LogoutTokenValidator(oIDCProviderMetadata.getIssuer(), oIDCClientInformation.getID(), jWSKeySelector, jWEKeySelector);
    }

    private static class TypeVerifier
    implements JOSEObjectTypeVerifier {
        private final boolean requireTypedTokens;

        public TypeVerifier(boolean bl2) {
            this.requireTypedTokens = bl2;
        }

        public void verify(JOSEObjectType jOSEObjectType, SecurityContext securityContext) throws BadJOSEException {
            if (this.requireTypedTokens) {
                if (!TYPE.equals(jOSEObjectType)) {
                    throw new BadJOSEException("Invalid / missing logout token typ (type) header, must be " + TYPE);
                }
            } else if (jOSEObjectType != null && !TYPE.equals(jOSEObjectType)) {
                throw new BadJOSEException("If set the logout token typ (type) header must be " + TYPE);
            }
        }
    }
}

