/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.op;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JOSEException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.proc.BadJOSEException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.proc.SecurityContext;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.ResourceRetriever;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.JWT;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.JWTClaimsSet;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.JWTParser;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.proc.JWTProcessor;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.OAuth2Error;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.AuthenticationRequest;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.op.ResolveException;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class AuthenticationRequestResolver<C extends SecurityContext> {
    private final JWTProcessor<C> jwtProcessor;
    private final ResourceRetriever jwtRetriever;

    public AuthenticationRequestResolver() {
        this.jwtProcessor = null;
        this.jwtRetriever = null;
    }

    public AuthenticationRequestResolver(JWTProcessor<C> jWTProcessor) {
        if (jWTProcessor == null) {
            throw new IllegalArgumentException("The JWT processor must not be null");
        }
        this.jwtProcessor = jWTProcessor;
        this.jwtRetriever = null;
    }

    public AuthenticationRequestResolver(JWTProcessor<C> jWTProcessor, ResourceRetriever resourceRetriever) {
        if (jWTProcessor == null) {
            throw new IllegalArgumentException("The JWT processor must not be null");
        }
        this.jwtProcessor = jWTProcessor;
        if (resourceRetriever == null) {
            throw new IllegalArgumentException("The JWT retriever must not be null");
        }
        this.jwtRetriever = resourceRetriever;
    }

    public JWTProcessor<C> getJWTProcessor() {
        return this.jwtProcessor;
    }

    public ResourceRetriever getJWTRetriever() {
        return this.jwtRetriever;
    }

    public static Map<String, List<String>> reformatClaims(JWTClaimsSet jWTClaimsSet) {
        Map<String, Object> map = jWTClaimsSet.getClaims();
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (entry.getValue() == null) continue;
            hashMap.put(entry.getKey(), Collections.singletonList(entry.getValue().toString()));
        }
        return Collections.unmodifiableMap(hashMap);
    }

    public AuthenticationRequest resolve(AuthenticationRequest authenticationRequest, C c2) throws ResolveException, JOSEException {
        JWTClaimsSet jWTClaimsSet;
        JWT jWT;
        if (!authenticationRequest.specifiesRequestObject()) {
            return authenticationRequest;
        }
        if (authenticationRequest.getRequestURI() != null) {
            if (this.jwtRetriever == null || this.jwtProcessor == null) {
                throw new ResolveException(OAuth2Error.REQUEST_URI_NOT_SUPPORTED, authenticationRequest);
            }
            try {
                jWT = JWTParser.parse(this.jwtRetriever.retrieveResource(authenticationRequest.getRequestURI().toURL()).getContent());
            }
            catch (MalformedURLException malformedURLException) {
                throw new ResolveException(OAuth2Error.INVALID_REQUEST_URI.setDescription("Malformed URL"), authenticationRequest);
            }
            catch (IOException iOException) {
                throw new ResolveException("Couldn't retrieve request_uri: " + iOException.getMessage(), "Network error, check the request_uri", authenticationRequest, iOException);
            }
            catch (java.text.ParseException parseException) {
                throw new ResolveException(OAuth2Error.INVALID_REQUEST_URI.setDescription("Invalid JWT"), authenticationRequest);
            }
        } else {
            if (this.jwtProcessor == null) {
                throw new ResolveException(OAuth2Error.REQUEST_NOT_SUPPORTED, authenticationRequest);
            }
            jWT = authenticationRequest.getRequestObject();
        }
        try {
            jWTClaimsSet = this.jwtProcessor.process(jWT, c2);
        }
        catch (BadJOSEException badJOSEException) {
            throw new ResolveException("Invalid request object: " + badJOSEException.getMessage(), "Bad JWT / signature / HMAC / encryption", authenticationRequest, badJOSEException);
        }
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
        hashMap.putAll(authenticationRequest.toParameters());
        hashMap.putAll(AuthenticationRequestResolver.reformatClaims(jWTClaimsSet));
        hashMap.remove("request");
        hashMap.remove("request_uri");
        try {
            return AuthenticationRequest.parse(authenticationRequest.getEndpointURI(), hashMap);
        }
        catch (ParseException parseException) {
            throw new ResolveException("Couldn't create final OpenID authentication request: " + parseException.getMessage(), "Invalid request object parameter(s): " + parseException.getMessage(), authenticationRequest, parseException);
        }
    }
}

