/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.policy;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.CollectionUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.StringUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.policy.language.OperationName;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.policy.language.PolicyOperation;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.policy.language.PolicyOperationApplication;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.policy.language.PolicyViolationException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.policy.operations.DefaultPolicyOperationCombinationValidator;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.policy.operations.DefaultPolicyOperationFactory;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.policy.operations.PolicyOperationCombinationValidator;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.policy.operations.PolicyOperationFactory;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONObject;

public class MetadataPolicyEntry
implements Map.Entry<String, List<PolicyOperation>> {
    public static final PolicyOperationFactory DEFAULT_POLICY_OPERATION_FACTORY = new DefaultPolicyOperationFactory();
    public static final PolicyOperationCombinationValidator DEFAULT_POLICY_COMBINATION_VALIDATOR = new DefaultPolicyOperationCombinationValidator();
    private final String parameterName;
    private final List<PolicyOperation> policyOperations;

    public MetadataPolicyEntry(String string, List<PolicyOperation> list) {
        if (StringUtils.isBlank(string)) {
            throw new IllegalArgumentException("The parameter name must not be null or empty");
        }
        this.parameterName = string;
        this.policyOperations = list;
    }

    public String getParameterName() {
        return this.getKey();
    }

    @Override
    public String getKey() {
        return this.parameterName;
    }

    public List<PolicyOperation> getPolicyOperations() {
        return this.getValue();
    }

    @Override
    public List<PolicyOperation> getValue() {
        return this.policyOperations;
    }

    @Override
    public List<PolicyOperation> setValue(List<PolicyOperation> list) {
        throw new UnsupportedOperationException();
    }

    public Map<OperationName, PolicyOperation> getOperationsMap() {
        HashMap<OperationName, PolicyOperation> hashMap = new HashMap<OperationName, PolicyOperation>();
        if (this.getPolicyOperations() == null) {
            return hashMap;
        }
        for (PolicyOperation policyOperation : this.getPolicyOperations()) {
            hashMap.put(policyOperation.getOperationName(), policyOperation);
        }
        return hashMap;
    }

    public MetadataPolicyEntry combine(MetadataPolicyEntry metadataPolicyEntry) throws PolicyViolationException {
        return this.combine(metadataPolicyEntry, DEFAULT_POLICY_COMBINATION_VALIDATOR);
    }

    public MetadataPolicyEntry combine(MetadataPolicyEntry metadataPolicyEntry, PolicyOperationCombinationValidator policyOperationCombinationValidator) throws PolicyViolationException {
        if (!this.getParameterName().equals(metadataPolicyEntry.getParameterName())) {
            throw new PolicyViolationException("The parameter name of the other policy doesn't match: " + metadataPolicyEntry.getParameterName());
        }
        LinkedList<PolicyOperation> linkedList = new LinkedList<PolicyOperation>();
        Map<OperationName, PolicyOperation> map = this.getOperationsMap();
        Map<OperationName, PolicyOperation> map2 = metadataPolicyEntry.getOperationsMap();
        for (OperationName operationName : map.keySet()) {
            if (map2.containsKey(operationName)) continue;
            linkedList.add(map.get(operationName));
        }
        for (OperationName operationName : map2.keySet()) {
            if (map.containsKey(operationName)) continue;
            linkedList.add(map2.get(operationName));
        }
        for (OperationName operationName : map.keySet()) {
            if (!map2.containsKey(operationName)) continue;
            PolicyOperation policyOperation = map.get(operationName);
            linkedList.add(policyOperation.merge(map2.get(operationName)));
        }
        List<PolicyOperation> list = policyOperationCombinationValidator.validate(linkedList);
        return new MetadataPolicyEntry(this.getParameterName(), list);
    }

    public Object apply(Object object) throws PolicyViolationException {
        if (CollectionUtils.isEmpty(this.getValue())) {
            return object;
        }
        Object object2 = object;
        Iterator iterator = this.getValue().iterator();
        while (iterator.hasNext()) {
            PolicyOperation policyOperation = (PolicyOperation)iterator.next();
            object2 = PolicyOperationApplication.apply(policyOperation, object2);
        }
        return object2;
    }

    public JSONObject toJSONObject() {
        if (CollectionUtils.isEmpty(this.getValue())) {
            return null;
        }
        JSONObject jSONObject = new JSONObject();
        Iterator iterator = this.getValue().iterator();
        while (iterator.hasNext()) {
            PolicyOperation policyOperation = (PolicyOperation)iterator.next();
            Map.Entry<String, Object> entry = policyOperation.toJSONObjectEntry();
            jSONObject.put(entry.getKey(), entry.getValue());
        }
        return jSONObject;
    }

    public static MetadataPolicyEntry parse(String string, JSONObject jSONObject) throws ParseException, PolicyViolationException {
        return MetadataPolicyEntry.parse(string, jSONObject, DEFAULT_POLICY_OPERATION_FACTORY, DEFAULT_POLICY_COMBINATION_VALIDATOR);
    }

    public static MetadataPolicyEntry parse(String string, JSONObject jSONObject, PolicyOperationFactory policyOperationFactory, PolicyOperationCombinationValidator policyOperationCombinationValidator) throws ParseException, PolicyViolationException {
        if (jSONObject == null) {
            throw new IllegalArgumentException("The entry spec must not be null");
        }
        LinkedList<PolicyOperation> linkedList = new LinkedList<PolicyOperation>();
        for (String string2 : jSONObject.keySet()) {
            PolicyOperation policyOperation = policyOperationFactory.createForName(new OperationName(string2));
            if (policyOperation == null) {
                throw new PolicyViolationException("Unsupported policy operation: " + string2);
            }
            policyOperation.parseConfiguration(jSONObject.get(string2));
            linkedList.add(policyOperation);
        }
        List<PolicyOperation> list = policyOperationCombinationValidator.validate(linkedList);
        return new MetadataPolicyEntry(string, list);
    }
}

