/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.api;

import macromedia.jdbc.sqlserver.externals.com.nimbusds.common.contenttype.ContentType;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.http.HTTPResponse;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.api.FetchEntityStatementResponse;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.entities.EntityStatement;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.Immutable;

@Immutable
public class FetchEntityStatementSuccessResponse
extends FetchEntityStatementResponse {
    private final EntityStatement entityStatement;

    public FetchEntityStatementSuccessResponse(EntityStatement entityStatement) {
        if (entityStatement == null) {
            throw new IllegalArgumentException("The federation entity statement must not be null");
        }
        this.entityStatement = entityStatement;
    }

    public EntityStatement getEntityStatement() {
        return this.entityStatement;
    }

    @Override
    public boolean indicatesSuccess() {
        return true;
    }

    @Override
    public HTTPResponse toHTTPResponse() {
        HTTPResponse hTTPResponse = new HTTPResponse(200);
        hTTPResponse.setEntityContentType(ContentType.APPLICATION_JOSE);
        hTTPResponse.setContent(this.getEntityStatement().getSignedStatement().serialize());
        return hTTPResponse;
    }

    public static FetchEntityStatementSuccessResponse parse(HTTPResponse hTTPResponse) throws ParseException {
        hTTPResponse.ensureStatusCode(200);
        hTTPResponse.ensureEntityContentType(ContentType.APPLICATION_JOSE);
        return new FetchEntityStatementSuccessResponse(EntityStatement.parse(hTTPResponse.getContent()));
    }
}

