/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.api;

import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ErrorObject;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.http.HTTPResponse;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.api.OperationType;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.Immutable;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONObject;

@Immutable
public class FederationAPIError
extends ErrorObject {
    private static final long serialVersionUID = 2116693118039606386L;
    private final OperationType operationType;

    public FederationAPIError(OperationType operationType, String string, String string2) {
        this(operationType, string, string2, 0);
    }

    public FederationAPIError(OperationType operationType, String string, String string2, int n2) {
        super(string, string2, n2);
        this.operationType = operationType;
    }

    public OperationType getOperationType() {
        return this.operationType;
    }

    public FederationAPIError withStatusCode(int n2) {
        return new FederationAPIError(this.getOperationType(), this.getCode(), this.getDescription(), n2);
    }

    @Override
    public JSONObject toJSONObject() {
        JSONObject jSONObject = super.toJSONObject();
        if (this.getOperationType() != null) {
            jSONObject.put("operation", this.getOperationType().getValue());
        }
        return jSONObject;
    }

    public static FederationAPIError parse(JSONObject jSONObject) {
        ErrorObject errorObject = ErrorObject.parse(jSONObject);
        OperationType operationType = null;
        try {
            operationType = new OperationType(JSONObjectUtils.getString(jSONObject, "operation"));
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return new FederationAPIError(operationType, errorObject.getCode(), errorObject.getDescription());
    }

    public static FederationAPIError parse(HTTPResponse hTTPResponse) {
        JSONObject jSONObject;
        try {
            jSONObject = hTTPResponse.getContentAsJSONObject();
        }
        catch (ParseException parseException) {
            jSONObject = new JSONObject();
        }
        return FederationAPIError.parse(jSONObject).withStatusCode(hTTPResponse.getStatusCode());
    }
}

