/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.api;

import java.net.URI;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.http.HTTPRequest;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.Issuer;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.MultivaluedMapUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.StringUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.api.EntityListingSpec;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.api.FederationAPIRequest;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.api.OperationType;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.Immutable;

@Immutable
public class EntityListingRequest
extends FederationAPIRequest {
    private final Issuer issuer;
    private final EntityListingSpec listingSpec;

    public EntityListingRequest(URI uRI, Issuer issuer, EntityListingSpec entityListingSpec) {
        super(uRI, OperationType.LISTING);
        if (issuer == null) {
            throw new IllegalArgumentException("The issuer must not be null");
        }
        this.issuer = issuer;
        if (entityListingSpec == null) {
            throw new IllegalArgumentException("The listing spec must not be null");
        }
        this.listingSpec = entityListingSpec;
    }

    public Issuer getIssuer() {
        return this.issuer;
    }

    public EntityListingSpec getListingSpec() {
        return this.listingSpec;
    }

    @Override
    public Map<String, List<String>> toParameters() {
        LinkedHashMap<String, List<String>> linkedHashMap = new LinkedHashMap<String, List<String>>();
        linkedHashMap.put("operation", Collections.singletonList(this.getOperationType().getValue()));
        linkedHashMap.put("iss", Collections.singletonList(this.getIssuer().getValue()));
        switch (this.getListingSpec()) {
            case LEAF_ENTITIES_ONLY: {
                linkedHashMap.put("is_leaf", Collections.singletonList("true"));
                break;
            }
            case INTERMEDIATES_ONLY: {
                linkedHashMap.put("is_leaf", Collections.singletonList("false"));
                break;
            }
        }
        return linkedHashMap;
    }

    public static EntityListingRequest parse(Map<String, List<String>> map) throws ParseException {
        String string = MultivaluedMapUtils.getFirstValue(map, "operation");
        if (StringUtils.isBlank(string)) {
            throw new ParseException("Missing operation type");
        }
        if (!OperationType.LISTING.getValue().equals(string)) {
            throw new ParseException("The operation type must be listing");
        }
        string = MultivaluedMapUtils.getFirstValue(map, "iss");
        if (string == null) {
            throw new ParseException("Missing iss (issuer) parameter");
        }
        Issuer issuer = new Issuer(string);
        string = MultivaluedMapUtils.getFirstValue(map, "is_leaf");
        EntityListingSpec entityListingSpec = EntityListingSpec.ALL;
        if ("true".equals(string)) {
            entityListingSpec = EntityListingSpec.LEAF_ENTITIES_ONLY;
        } else if ("false".equals(string)) {
            entityListingSpec = EntityListingSpec.INTERMEDIATES_ONLY;
        }
        return new EntityListingRequest(null, issuer, entityListingSpec);
    }

    public static EntityListingRequest parse(HTTPRequest hTTPRequest) throws ParseException {
        hTTPRequest.ensureMethod(HTTPRequest.Method.GET);
        EntityListingRequest entityListingRequest = EntityListingRequest.parse(hTTPRequest.getQueryParameters());
        return new EntityListingRequest(hTTPRequest.getURI(), entityListingRequest.getIssuer(), entityListingRequest.getListingSpec());
    }
}

