/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.claims;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.JWK;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.JWTClaimsSet;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ResponseType;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.Audience;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.Issuer;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.Subject;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.Nonce;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.claims.ACR;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.claims.AMR;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.claims.AccessTokenHash;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.claims.AuthorizedParty;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.claims.CodeHash;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.claims.CommonOIDCTokenClaimsSet;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.claims.StateHash;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONArray;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONObject;

public class IDTokenClaimsSet
extends CommonOIDCTokenClaimsSet {
    public static final String EXP_CLAIM_NAME = "exp";
    public static final String AUTH_TIME_CLAIM_NAME = "auth_time";
    public static final String NONCE_CLAIM_NAME = "nonce";
    public static final String AT_HASH_CLAIM_NAME = "at_hash";
    public static final String C_HASH_CLAIM_NAME = "c_hash";
    public static final String S_HASH_CLAIM_NAME = "s_hash";
    public static final String ACR_CLAIM_NAME = "acr";
    public static final String AMR_CLAIM_NAME = "amr";
    public static final String AZP_CLAIM_NAME = "azp";
    public static final String SUB_JWK_CLAIM_NAME = "sub_jwk";
    private static final Set<String> STD_CLAIM_NAMES;

    public static Set<String> getStandardClaimNames() {
        return STD_CLAIM_NAMES;
    }

    public IDTokenClaimsSet(Issuer issuer, Subject subject, List<Audience> list, Date date, Date date2) {
        this.setClaim("iss", issuer.getValue());
        this.setClaim("sub", subject.getValue());
        JSONArray jSONArray = new JSONArray();
        for (Audience audience : list) {
            jSONArray.add(audience.getValue());
        }
        this.setClaim("aud", jSONArray);
        this.setDateClaim(EXP_CLAIM_NAME, date);
        this.setDateClaim("iat", date2);
    }

    private IDTokenClaimsSet(JSONObject jSONObject) throws ParseException {
        super(jSONObject);
        if (this.getStringClaim("iss") == null) {
            throw new ParseException("Missing or invalid iss claim");
        }
        if (this.getStringClaim("sub") == null) {
            throw new ParseException("Missing or invalid sub claim");
        }
        if (this.getStringClaim("aud") == null && this.getStringListClaim("aud") == null || this.getStringListClaim("aud") != null && this.getStringListClaim("aud").isEmpty()) {
            throw new ParseException("Missing or invalid aud claim");
        }
        if (this.getDateClaim(EXP_CLAIM_NAME) == null) {
            throw new ParseException("Missing or invalid exp claim");
        }
        if (this.getDateClaim("iat") == null) {
            throw new ParseException("Missing or invalid iat claim");
        }
    }

    public IDTokenClaimsSet(JWTClaimsSet jWTClaimsSet) throws ParseException {
        this(JSONObjectUtils.toJSONObject(jWTClaimsSet));
    }

    public boolean hasRequiredClaims(ResponseType responseType, boolean bl2) {
        if (new ResponseType("code").equals(responseType)) {
            return true;
        }
        if (new ResponseType("id_token").equals(responseType)) {
            return this.getNonce() != null;
        }
        if (new ResponseType("id_token", "token").equals(responseType)) {
            if (this.getNonce() == null) {
                return false;
            }
            return this.getAccessTokenHash() != null;
        }
        if (new ResponseType("code", "id_token").equals(responseType)) {
            if (this.getNonce() == null) {
                return false;
            }
            if (!bl2) {
                return true;
            }
            return this.getCodeHash() != null;
        }
        if (new ResponseType("code", "token").equals(responseType)) {
            if (this.getNonce() == null) {
                return false;
            }
            if (!bl2) {
                return true;
            }
            return true;
        }
        if (new ResponseType("code", "id_token", "token").equals(responseType)) {
            if (this.getNonce() == null) {
                return false;
            }
            if (!bl2) {
                return true;
            }
            if (this.getAccessTokenHash() == null) {
                return false;
            }
            return this.getCodeHash() != null;
        }
        throw new IllegalArgumentException("Unsupported response_type: " + responseType);
    }

    @Deprecated
    public boolean hasRequiredClaims(ResponseType responseType) {
        return this.hasRequiredClaims(responseType, true);
    }

    public Date getExpirationTime() {
        return this.getDateClaim(EXP_CLAIM_NAME);
    }

    public Date getAuthenticationTime() {
        return this.getDateClaim(AUTH_TIME_CLAIM_NAME);
    }

    public void setAuthenticationTime(Date date) {
        this.setDateClaim(AUTH_TIME_CLAIM_NAME, date);
    }

    public Nonce getNonce() {
        String string = this.getStringClaim(NONCE_CLAIM_NAME);
        return string != null ? new Nonce(string) : null;
    }

    public void setNonce(Nonce nonce) {
        this.setClaim(NONCE_CLAIM_NAME, nonce != null ? nonce.getValue() : null);
    }

    public AccessTokenHash getAccessTokenHash() {
        String string = this.getStringClaim(AT_HASH_CLAIM_NAME);
        return string != null ? new AccessTokenHash(string) : null;
    }

    public void setAccessTokenHash(AccessTokenHash accessTokenHash) {
        this.setClaim(AT_HASH_CLAIM_NAME, accessTokenHash != null ? accessTokenHash.getValue() : null);
    }

    public CodeHash getCodeHash() {
        String string = this.getStringClaim(C_HASH_CLAIM_NAME);
        return string != null ? new CodeHash(string) : null;
    }

    public void setCodeHash(CodeHash codeHash) {
        this.setClaim(C_HASH_CLAIM_NAME, codeHash != null ? codeHash.getValue() : null);
    }

    public StateHash getStateHash() {
        String string = this.getStringClaim(S_HASH_CLAIM_NAME);
        return string != null ? new StateHash(string) : null;
    }

    public void setStateHash(StateHash stateHash) {
        this.setClaim(S_HASH_CLAIM_NAME, stateHash != null ? stateHash.getValue() : null);
    }

    public ACR getACR() {
        String string = this.getStringClaim(ACR_CLAIM_NAME);
        return string != null ? new ACR(string) : null;
    }

    public void setACR(ACR aCR) {
        this.setClaim(ACR_CLAIM_NAME, aCR != null ? aCR.getValue() : null);
    }

    public List<AMR> getAMR() {
        List<String> list = this.getStringListClaim(AMR_CLAIM_NAME);
        if (list == null || list.isEmpty()) {
            return null;
        }
        ArrayList<AMR> arrayList = new ArrayList<AMR>(list.size());
        for (String string : list) {
            arrayList.add(new AMR(string));
        }
        return arrayList;
    }

    public void setAMR(List<AMR> list) {
        if (list != null) {
            ArrayList<String> arrayList = new ArrayList<String>(list.size());
            for (AMR aMR : list) {
                arrayList.add(aMR.getValue());
            }
            this.setClaim(AMR_CLAIM_NAME, arrayList);
        } else {
            this.setClaim(AMR_CLAIM_NAME, null);
        }
    }

    public AuthorizedParty getAuthorizedParty() {
        String string = this.getStringClaim(AZP_CLAIM_NAME);
        return string != null ? new AuthorizedParty(string) : null;
    }

    public void setAuthorizedParty(AuthorizedParty authorizedParty) {
        this.setClaim(AZP_CLAIM_NAME, authorizedParty != null ? authorizedParty.getValue() : null);
    }

    public JWK getSubjectJWK() {
        JSONObject jSONObject = this.getClaim(SUB_JWK_CLAIM_NAME, JSONObject.class);
        if (jSONObject == null) {
            return null;
        }
        try {
            return JWK.parse(jSONObject);
        }
        catch (java.text.ParseException parseException) {
            return null;
        }
    }

    public void setSubjectJWK(JWK jWK) {
        if (jWK != null) {
            if (jWK.isPrivate()) {
                throw new IllegalArgumentException("The subject's JSON Web Key (JWK) must be public");
            }
            this.setClaim(SUB_JWK_CLAIM_NAME, new JSONObject(jWK.toJSONObject()));
        } else {
            this.setClaim(SUB_JWK_CLAIM_NAME, null);
        }
    }

    public static IDTokenClaimsSet parse(JSONObject jSONObject) throws ParseException {
        try {
            return new IDTokenClaimsSet(jSONObject);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ParseException(illegalArgumentException.getMessage(), illegalArgumentException);
        }
    }

    public static IDTokenClaimsSet parse(String string) throws ParseException {
        return IDTokenClaimsSet.parse(JSONObjectUtils.parse(string));
    }

    static {
        HashSet<String> hashSet = new HashSet<String>(CommonOIDCTokenClaimsSet.getStandardClaimNames());
        hashSet.add(EXP_CLAIM_NAME);
        hashSet.add(AUTH_TIME_CLAIM_NAME);
        hashSet.add(NONCE_CLAIM_NAME);
        hashSet.add(AT_HASH_CLAIM_NAME);
        hashSet.add(C_HASH_CLAIM_NAME);
        hashSet.add(S_HASH_CLAIM_NAME);
        hashSet.add(ACR_CLAIM_NAME);
        hashSet.add(AMR_CLAIM_NAME);
        hashSet.add(AZP_CLAIM_NAME);
        hashSet.add(SUB_JWK_CLAIM_NAME);
        STD_CLAIM_NAMES = Collections.unmodifiableSet(hashSet);
    }
}

