/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.evidences.attachment;

import java.io.IOException;
import java.net.URI;
import java.security.NoSuchAlgorithmException;
import java.util.Objects;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.Base64;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.http.HTTPRequest;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.http.HTTPResponse;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.token.BearerAccessToken;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.StringUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.evidences.attachment.Attachment;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.evidences.attachment.AttachmentType;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.evidences.attachment.Content;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.evidences.attachment.Digest;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.evidences.attachment.DigestMismatchException;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.Immutable;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONObject;

@Immutable
public class ExternalAttachment
extends Attachment {
    private final URI url;
    private final BearerAccessToken accessToken;
    private final long expiresIn;
    private final Digest digest;

    public ExternalAttachment(URI uRI, BearerAccessToken bearerAccessToken, long l2, Digest digest, String string) {
        super(AttachmentType.EXTERNAL, string);
        Objects.requireNonNull(uRI);
        this.url = uRI;
        this.accessToken = bearerAccessToken;
        this.expiresIn = l2;
        Objects.requireNonNull(digest);
        this.digest = digest;
    }

    public URI getURL() {
        return this.url;
    }

    public BearerAccessToken getBearerAccessToken() {
        return this.accessToken;
    }

    public long getExpiresIn() {
        return this.expiresIn;
    }

    public Digest getDigest() {
        return this.digest;
    }

    public Content retrieveContent(int n2, int n3) throws IOException, NoSuchAlgorithmException, DigestMismatchException {
        HTTPRequest hTTPRequest = new HTTPRequest(HTTPRequest.Method.GET, this.getURL());
        if (this.getBearerAccessToken() != null) {
            hTTPRequest.setAuthorization(this.getBearerAccessToken().toAuthorizationHeader());
        }
        hTTPRequest.setConnectTimeout(n2);
        hTTPRequest.setReadTimeout(n3);
        HTTPResponse hTTPResponse = hTTPRequest.send();
        try {
            hTTPResponse.ensureStatusCode(200);
        }
        catch (ParseException parseException) {
            throw new IOException(parseException.getMessage(), parseException);
        }
        if (hTTPResponse.getEntityContentType() == null) {
            throw new IOException("Missing Content-Type header in HTTP response: " + this.url);
        }
        if (StringUtils.isBlank(hTTPResponse.getContent())) {
            throw new IOException("The HTTP response has no content: " + this.url);
        }
        Base64 base64 = new Base64(hTTPResponse.getContent().trim());
        if (!this.getDigest().matches(base64)) {
            throw new DigestMismatchException("The computed " + this.digest.getHashAlgorithm() + " digest for the retrieved content doesn't match the expected: " + this.getURL());
        }
        return new Content(hTTPResponse.getEntityContentType(), base64, this.getDescriptionString());
    }

    @Override
    public JSONObject toJSONObject() {
        JSONObject jSONObject = super.toJSONObject();
        jSONObject.put("url", this.getURL().toString());
        if (this.getBearerAccessToken() != null) {
            jSONObject.put("access_token", this.getBearerAccessToken().getValue());
        }
        if (this.expiresIn > 0L) {
            jSONObject.put("expires_in", this.getExpiresIn());
        }
        jSONObject.put("digest", this.getDigest().toJSONObject());
        return jSONObject;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ExternalAttachment)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        ExternalAttachment externalAttachment = (ExternalAttachment)object;
        return this.getExpiresIn() == externalAttachment.getExpiresIn() && this.url.equals(externalAttachment.url) && Objects.equals(this.accessToken, externalAttachment.accessToken) && this.getDigest().equals(externalAttachment.getDigest());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.url, this.accessToken, this.getExpiresIn(), this.getDigest());
    }

    public static ExternalAttachment parse(JSONObject jSONObject) throws ParseException {
        String string;
        URI uRI = JSONObjectUtils.getURI(jSONObject, "url");
        long l2 = 0L;
        if (jSONObject.get("expires_in") != null && (l2 = JSONObjectUtils.getLong(jSONObject, "expires_in")) < 1L) {
            throw new ParseException("The expires_in parameter must be a positive integer");
        }
        BearerAccessToken bearerAccessToken = null;
        if (jSONObject.get("access_token") != null) {
            string = JSONObjectUtils.getString(jSONObject, "access_token");
            bearerAccessToken = l2 > 0L ? new BearerAccessToken(string, l2, null) : new BearerAccessToken(string);
        }
        string = JSONObjectUtils.getString(jSONObject, "desc", null);
        Digest digest = Digest.parse(JSONObjectUtils.getJSONObject(jSONObject, "digest"));
        return new ExternalAttachment(uRI, bearerAccessToken, l2, digest, string);
    }
}

