/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.evidences;

import java.util.Objects;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.date.DateWithTimeZoneOffset;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.date.SimpleDate;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.evidences.ElectronicRecordSource;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.evidences.ElectronicRecordType;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.evidences.PersonalNumber;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONObject;

public class ElectronicRecordDetails {
    private final ElectronicRecordType type;
    private final PersonalNumber personalNumber;
    private final DateWithTimeZoneOffset createdAt;
    private final SimpleDate dateOfExpiry;
    private final ElectronicRecordSource source;

    public ElectronicRecordDetails(ElectronicRecordType electronicRecordType, PersonalNumber personalNumber, DateWithTimeZoneOffset dateWithTimeZoneOffset, SimpleDate simpleDate, ElectronicRecordSource electronicRecordSource) {
        Objects.requireNonNull(electronicRecordType);
        this.type = electronicRecordType;
        this.personalNumber = personalNumber;
        this.createdAt = dateWithTimeZoneOffset;
        this.dateOfExpiry = simpleDate;
        this.source = electronicRecordSource;
    }

    public ElectronicRecordType getType() {
        return this.type;
    }

    public PersonalNumber getPersonalNumber() {
        return this.personalNumber;
    }

    public DateWithTimeZoneOffset getCreatedAt() {
        return this.createdAt;
    }

    public SimpleDate getDateOfExpiry() {
        return this.dateOfExpiry;
    }

    public ElectronicRecordSource getSource() {
        return this.source;
    }

    public JSONObject toJSONObject() {
        JSONObject jSONObject;
        JSONObject jSONObject2 = new JSONObject();
        jSONObject2.put("type", this.getType().getValue());
        if (this.getPersonalNumber() != null) {
            jSONObject2.put("personal_number", this.getPersonalNumber().getValue());
        }
        if (this.getCreatedAt() != null) {
            jSONObject2.put("created_at", this.getCreatedAt().toISO8601String());
        }
        if (this.getDateOfExpiry() != null) {
            jSONObject2.put("date_of_expiry", this.getDateOfExpiry().toISO8601String());
        }
        if (this.getSource() != null && !(jSONObject = this.getSource().toJSONObject()).isEmpty()) {
            jSONObject2.put("source", jSONObject);
        }
        return jSONObject2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ElectronicRecordDetails)) {
            return false;
        }
        ElectronicRecordDetails electronicRecordDetails = (ElectronicRecordDetails)object;
        return this.getType().equals(electronicRecordDetails.getType()) && Objects.equals(this.getPersonalNumber(), electronicRecordDetails.getPersonalNumber()) && Objects.equals(this.getCreatedAt(), electronicRecordDetails.getCreatedAt()) && Objects.equals(this.getDateOfExpiry(), electronicRecordDetails.getDateOfExpiry()) && Objects.equals(this.getSource(), electronicRecordDetails.getSource());
    }

    public int hashCode() {
        return Objects.hash(this.getType(), this.getPersonalNumber(), this.getCreatedAt(), this.getDateOfExpiry(), this.getSource());
    }

    public static ElectronicRecordDetails parse(JSONObject jSONObject) throws ParseException {
        try {
            ElectronicRecordType electronicRecordType = new ElectronicRecordType(JSONObjectUtils.getString(jSONObject, "type"));
            PersonalNumber personalNumber = null;
            if (jSONObject.get("personal_number") != null) {
                personalNumber = new PersonalNumber(JSONObjectUtils.getString(jSONObject, "personal_number"));
            }
            DateWithTimeZoneOffset dateWithTimeZoneOffset = null;
            if (jSONObject.get("created_at") != null) {
                dateWithTimeZoneOffset = DateWithTimeZoneOffset.parseISO8601String(JSONObjectUtils.getString(jSONObject, "created_at"));
            }
            SimpleDate simpleDate = null;
            if (jSONObject.get("date_of_expiry") != null) {
                simpleDate = SimpleDate.parseISO8601String(JSONObjectUtils.getString(jSONObject, "date_of_expiry"));
            }
            ElectronicRecordSource electronicRecordSource = null;
            if (jSONObject.get("source") != null) {
                electronicRecordSource = ElectronicRecordSource.parse(JSONObjectUtils.getJSONObject(jSONObject, "source"));
            }
            return new ElectronicRecordDetails(electronicRecordType, personalNumber, dateWithTimeZoneOffset, simpleDate, electronicRecordSource);
        }
        catch (Exception exception) {
            throw new ParseException(exception.getMessage(), exception);
        }
    }
}

