/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance;

import java.util.Objects;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.StringUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.Policy;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.Procedure;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.Status;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.Immutable;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONObject;

@Immutable
public final class IdentityAssuranceProcess {
    private final Policy policy;
    private final Procedure procedure;
    private final Status status;

    public IdentityAssuranceProcess(Policy policy, Procedure procedure, Status status) {
        if (policy == null && procedure == null && status == null) {
            throw new IllegalArgumentException("At least one assurance process element must be specified");
        }
        this.policy = policy;
        this.procedure = procedure;
        this.status = status;
    }

    public Policy getPolicy() {
        return this.policy;
    }

    public Procedure getProcedure() {
        return this.procedure;
    }

    public Status getStatus() {
        return this.status;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof IdentityAssuranceProcess)) {
            return false;
        }
        IdentityAssuranceProcess identityAssuranceProcess = (IdentityAssuranceProcess)object;
        return Objects.equals(this.getPolicy(), identityAssuranceProcess.getPolicy()) && Objects.equals(this.getProcedure(), identityAssuranceProcess.getProcedure()) && Objects.equals(this.getStatus(), identityAssuranceProcess.getStatus());
    }

    public int hashCode() {
        return Objects.hash(this.getPolicy(), this.getProcedure(), this.getStatus());
    }

    public JSONObject toJSONObject() {
        JSONObject jSONObject = new JSONObject();
        if (this.policy != null) {
            jSONObject.put("policy", this.policy.getValue());
        }
        if (this.procedure != null) {
            jSONObject.put("procedure", this.procedure.getValue());
        }
        if (this.status != null) {
            jSONObject.put("status", this.status.getValue());
        }
        return jSONObject;
    }

    public static IdentityAssuranceProcess parse(JSONObject jSONObject) throws ParseException {
        Policy policy = null;
        String string = JSONObjectUtils.getString(jSONObject, "policy", null);
        if (StringUtils.isNotBlank(string)) {
            policy = new Policy(string);
        }
        Procedure procedure = null;
        string = JSONObjectUtils.getString(jSONObject, "procedure", null);
        if (StringUtils.isNotBlank(string)) {
            procedure = new Procedure(string);
        }
        Status status = null;
        string = JSONObjectUtils.getString(jSONObject, "status", null);
        if (StringUtils.isNotBlank(string)) {
            status = new Status(string);
        }
        try {
            return new IdentityAssuranceProcess(policy, procedure, status);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ParseException(illegalArgumentException.getMessage());
        }
    }
}

