/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk;

import macromedia.jdbc.sqlserver.externals.com.nimbusds.common.contenttype.ContentType;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.JWT;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.SerializeException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.SuccessResponse;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.http.HTTPResponse;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.UserInfoResponse;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.claims.UserInfo;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.Immutable;

@Immutable
public class UserInfoSuccessResponse
extends UserInfoResponse
implements SuccessResponse {
    private final UserInfo claimsSet;
    private final JWT jwt;

    public UserInfoSuccessResponse(UserInfo userInfo) {
        if (userInfo == null) {
            throw new IllegalArgumentException("The claims must not be null");
        }
        this.claimsSet = userInfo;
        this.jwt = null;
    }

    public UserInfoSuccessResponse(JWT jWT) {
        if (jWT == null) {
            throw new IllegalArgumentException("The claims JWT must not be null");
        }
        this.jwt = jWT;
        this.claimsSet = null;
    }

    @Override
    public boolean indicatesSuccess() {
        return true;
    }

    public ContentType getEntityContentType() {
        if (this.claimsSet != null) {
            return ContentType.APPLICATION_JSON;
        }
        return ContentType.APPLICATION_JWT;
    }

    public UserInfo getUserInfo() {
        return this.claimsSet;
    }

    public JWT getUserInfoJWT() {
        return this.jwt;
    }

    @Override
    public HTTPResponse toHTTPResponse() {
        String string;
        HTTPResponse hTTPResponse = new HTTPResponse(200);
        hTTPResponse.setEntityContentType(this.getEntityContentType());
        if (this.claimsSet != null) {
            string = this.claimsSet.toJSONObject().toString();
        } else {
            try {
                string = this.jwt.serialize();
            }
            catch (IllegalStateException illegalStateException) {
                throw new SerializeException("Couldn't serialize UserInfo claims JWT: " + illegalStateException.getMessage(), illegalStateException);
            }
        }
        hTTPResponse.setContent(string);
        return hTTPResponse;
    }

    public static UserInfoSuccessResponse parse(HTTPResponse hTTPResponse) throws ParseException {
        UserInfoSuccessResponse userInfoSuccessResponse;
        hTTPResponse.ensureStatusCode(200);
        hTTPResponse.ensureEntityContentType();
        ContentType contentType = hTTPResponse.getEntityContentType();
        if (contentType.matches(ContentType.APPLICATION_JSON)) {
            UserInfo userInfo;
            try {
                userInfo = new UserInfo(hTTPResponse.getContentAsJSONObject());
            }
            catch (Exception exception) {
                throw new ParseException("Couldn't parse UserInfo claims: " + exception.getMessage(), exception);
            }
            userInfoSuccessResponse = new UserInfoSuccessResponse(userInfo);
        } else if (contentType.matches(ContentType.APPLICATION_JWT)) {
            JWT jWT;
            try {
                jWT = hTTPResponse.getContentAsJWT();
            }
            catch (ParseException parseException) {
                throw new ParseException("Couldn't parse UserInfo claims JWT: " + parseException.getMessage(), parseException);
            }
            userInfoSuccessResponse = new UserInfoSuccessResponse(jWT);
        } else {
            throw new ParseException("Unexpected Content-Type, must be " + ContentType.APPLICATION_JSON + " or " + ContentType.APPLICATION_JWT);
        }
        return userInfoSuccessResponse;
    }
}

