/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk;

import java.net.URI;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.common.contenttype.ContentType;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ProtectedResourceRequest;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.SerializeException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.http.HTTPRequest;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.token.AccessToken;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.Immutable;

@Immutable
public class UserInfoRequest
extends ProtectedResourceRequest {
    private final HTTPRequest.Method httpMethod;

    public UserInfoRequest(URI uRI, AccessToken accessToken) {
        this(uRI, HTTPRequest.Method.GET, accessToken);
    }

    public UserInfoRequest(URI uRI, HTTPRequest.Method method, AccessToken accessToken) {
        super(uRI, accessToken);
        if (method == null) {
            throw new IllegalArgumentException("The HTTP method must not be null");
        }
        this.httpMethod = method;
        if (accessToken == null) {
            throw new IllegalArgumentException("The access token must not be null");
        }
    }

    public HTTPRequest.Method getMethod() {
        return this.httpMethod;
    }

    @Override
    public HTTPRequest toHTTPRequest() {
        if (this.getEndpointURI() == null) {
            throw new SerializeException("The endpoint URI is not specified");
        }
        HTTPRequest hTTPRequest = new HTTPRequest(this.httpMethod, this.getEndpointURI());
        switch (this.httpMethod) {
            case GET: {
                hTTPRequest.setAuthorization(this.getAccessToken().toAuthorizationHeader());
                break;
            }
            case POST: {
                hTTPRequest.setEntityContentType(ContentType.APPLICATION_URLENCODED);
                hTTPRequest.setQuery("access_token=" + this.getAccessToken().getValue());
                break;
            }
            default: {
                throw new SerializeException("Unexpected HTTP method: " + (Object)((Object)this.httpMethod));
            }
        }
        return hTTPRequest;
    }

    public static UserInfoRequest parse(HTTPRequest hTTPRequest) throws ParseException {
        return new UserInfoRequest(hTTPRequest.getURI(), hTTPRequest.getMethod(), AccessToken.parse(hTTPRequest));
    }
}

