/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk;

import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ResponseType;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.OIDCResponseTypeValue;

class OIDCResponseTypeValidator {
    public static void validate(ResponseType responseType) {
        if (responseType.isEmpty()) {
            throw new IllegalArgumentException("The response type must contain at least one value");
        }
        if (responseType.contains(ResponseType.Value.TOKEN) && responseType.size() == 1) {
            throw new IllegalArgumentException("The OpenID Connect response type cannot have token as the only value");
        }
        for (ResponseType.Value value : responseType) {
            if (value.equals(ResponseType.Value.CODE) || value.equals(ResponseType.Value.TOKEN) || value.equals(OIDCResponseTypeValue.ID_TOKEN)) continue;
            throw new IllegalArgumentException("Unsupported OpenID Connect response type value: " + value);
        }
    }

    private OIDCResponseTypeValidator() {
    }
}

