/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ResponseType;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.Scope;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.CollectionUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.JSONArrayUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.AuthenticationRequest;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.OIDCResponseTypeValue;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.OIDCScopeValue;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.claims.VerifiedClaimsSetRequest;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.claims.ClaimRequirement;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.claims.ClaimsSetRequest;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.Immutable;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONArray;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONAware;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONObject;

@Immutable
public class OIDCClaimsRequest
implements JSONAware {
    private final ClaimsSetRequest idToken;
    private final ClaimsSetRequest userInfo;
    private final List<macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.request.VerifiedClaimsSetRequest> idTokenVerified;
    private final List<macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.request.VerifiedClaimsSetRequest> userInfoVerified;

    public OIDCClaimsRequest() {
        this(null, null, Collections.emptyList(), Collections.emptyList());
    }

    private OIDCClaimsRequest(ClaimsSetRequest claimsSetRequest, ClaimsSetRequest claimsSetRequest2, List<macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.request.VerifiedClaimsSetRequest> list, List<macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.request.VerifiedClaimsSetRequest> list2) {
        this.idToken = claimsSetRequest;
        this.userInfo = claimsSetRequest2;
        if (list == null) {
            throw new IllegalArgumentException("The ID token verified claims set request list must not be null");
        }
        this.idTokenVerified = Collections.unmodifiableList(list);
        if (list2 == null) {
            throw new IllegalArgumentException("The UserInfo verified claims set request list must not be null");
        }
        this.userInfoVerified = Collections.unmodifiableList(list2);
    }

    public OIDCClaimsRequest add(OIDCClaimsRequest oIDCClaimsRequest) {
        if (oIDCClaimsRequest == null) {
            return this;
        }
        LinkedList<ClaimsSetRequest.Entry> linkedList = new LinkedList<ClaimsSetRequest.Entry>();
        if (this.idToken != null) {
            linkedList.addAll(this.idToken.getEntries());
        }
        if (oIDCClaimsRequest.getIDTokenClaimsRequest() != null) {
            linkedList.addAll(oIDCClaimsRequest.getIDTokenClaimsRequest().getEntries());
        }
        LinkedList<ClaimsSetRequest.Entry> linkedList2 = new LinkedList<ClaimsSetRequest.Entry>();
        if (this.userInfo != null) {
            linkedList2.addAll(this.userInfo.getEntries());
        }
        if (oIDCClaimsRequest.getUserInfoClaimsRequest() != null) {
            linkedList2.addAll(oIDCClaimsRequest.getUserInfoClaimsRequest().getEntries());
        }
        LinkedList<macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.request.VerifiedClaimsSetRequest> linkedList3 = new LinkedList<macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.request.VerifiedClaimsSetRequest>(this.idTokenVerified);
        linkedList3.addAll(oIDCClaimsRequest.getIDTokenVerifiedClaimsRequests());
        LinkedList<macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.request.VerifiedClaimsSetRequest> linkedList4 = new LinkedList<macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.request.VerifiedClaimsSetRequest>(this.userInfoVerified);
        linkedList4.addAll(oIDCClaimsRequest.getUserInfoVerifiedClaimsRequests());
        return new OIDCClaimsRequest(linkedList.isEmpty() ? null : new ClaimsSetRequest(linkedList), linkedList2.isEmpty() ? null : new ClaimsSetRequest(linkedList2), linkedList3, linkedList4);
    }

    public ClaimsSetRequest getIDTokenClaimsRequest() {
        return this.idToken;
    }

    public OIDCClaimsRequest withIDTokenClaimsRequest(ClaimsSetRequest claimsSetRequest) {
        return new OIDCClaimsRequest(claimsSetRequest, this.getUserInfoClaimsRequest(), this.getIDTokenVerifiedClaimsRequests(), this.getUserInfoVerifiedClaimsRequests());
    }

    public ClaimsSetRequest getUserInfoClaimsRequest() {
        return this.userInfo;
    }

    public OIDCClaimsRequest withUserInfoClaimsRequest(ClaimsSetRequest claimsSetRequest) {
        return new OIDCClaimsRequest(this.getIDTokenClaimsRequest(), claimsSetRequest, this.getIDTokenVerifiedClaimsRequests(), this.getUserInfoVerifiedClaimsRequests());
    }

    private static List<macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.request.VerifiedClaimsSetRequest> toCurrent(List<VerifiedClaimsSetRequest> list) {
        if (CollectionUtils.isEmpty(list)) {
            return Collections.emptyList();
        }
        LinkedList<macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.request.VerifiedClaimsSetRequest> linkedList = new LinkedList<macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.request.VerifiedClaimsSetRequest>();
        for (VerifiedClaimsSetRequest verifiedClaimsSetRequest : list) {
            if (verifiedClaimsSetRequest == null) continue;
            try {
                linkedList.add(macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.request.VerifiedClaimsSetRequest.parse(verifiedClaimsSetRequest.toJSONObject()));
            }
            catch (ParseException parseException) {}
        }
        return linkedList;
    }

    private static List<VerifiedClaimsSetRequest> toDeprecated(List<macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.request.VerifiedClaimsSetRequest> list) {
        if (CollectionUtils.isEmpty(list)) {
            return Collections.emptyList();
        }
        LinkedList<VerifiedClaimsSetRequest> linkedList = new LinkedList<VerifiedClaimsSetRequest>();
        for (macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.request.VerifiedClaimsSetRequest verifiedClaimsSetRequest : list) {
            if (verifiedClaimsSetRequest == null) continue;
            try {
                linkedList.add(VerifiedClaimsSetRequest.parse(verifiedClaimsSetRequest.toJSONObject()));
            }
            catch (ParseException parseException) {}
        }
        return linkedList;
    }

    public List<macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.request.VerifiedClaimsSetRequest> getIDTokenVerifiedClaimsRequests() {
        return this.idTokenVerified;
    }

    @Deprecated
    public List<VerifiedClaimsSetRequest> getIDTokenVerifiedClaimsRequestList() {
        return OIDCClaimsRequest.toDeprecated(this.idTokenVerified);
    }

    public OIDCClaimsRequest withIDTokenVerifiedClaimsRequests(List<macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.request.VerifiedClaimsSetRequest> list) {
        return new OIDCClaimsRequest(this.getIDTokenClaimsRequest(), this.getUserInfoClaimsRequest(), list != null ? list : Collections.emptyList(), this.getUserInfoVerifiedClaimsRequests());
    }

    @Deprecated
    public OIDCClaimsRequest withIDTokenVerifiedClaimsRequestList(List<VerifiedClaimsSetRequest> list) {
        return new OIDCClaimsRequest(this.getIDTokenClaimsRequest(), this.getUserInfoClaimsRequest(), list != null ? OIDCClaimsRequest.toCurrent(list) : Collections.emptyList(), this.getUserInfoVerifiedClaimsRequests());
    }

    public OIDCClaimsRequest withIDTokenVerifiedClaimsRequest(macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.request.VerifiedClaimsSetRequest verifiedClaimsSetRequest) {
        return new OIDCClaimsRequest(this.getIDTokenClaimsRequest(), this.getUserInfoClaimsRequest(), verifiedClaimsSetRequest != null ? Collections.singletonList(verifiedClaimsSetRequest) : Collections.emptyList(), this.getUserInfoVerifiedClaimsRequests());
    }

    @Deprecated
    public OIDCClaimsRequest withIDTokenVerifiedClaimsRequest(VerifiedClaimsSetRequest verifiedClaimsSetRequest) {
        return new OIDCClaimsRequest(this.getIDTokenClaimsRequest(), this.getUserInfoClaimsRequest(), verifiedClaimsSetRequest != null ? OIDCClaimsRequest.toCurrent(Collections.singletonList(verifiedClaimsSetRequest)) : Collections.emptyList(), this.getUserInfoVerifiedClaimsRequests());
    }

    public List<macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.request.VerifiedClaimsSetRequest> getUserInfoVerifiedClaimsRequests() {
        return this.userInfoVerified;
    }

    @Deprecated
    public List<VerifiedClaimsSetRequest> getUserInfoVerifiedClaimsRequestList() {
        return OIDCClaimsRequest.toDeprecated(this.userInfoVerified);
    }

    public OIDCClaimsRequest withUserInfoVerifiedClaimsRequests(List<macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.request.VerifiedClaimsSetRequest> list) {
        return new OIDCClaimsRequest(this.getIDTokenClaimsRequest(), this.getUserInfoClaimsRequest(), this.getIDTokenVerifiedClaimsRequests(), list != null ? list : Collections.emptyList());
    }

    @Deprecated
    public OIDCClaimsRequest withUserInfoVerifiedClaimsRequestList(List<VerifiedClaimsSetRequest> list) {
        return new OIDCClaimsRequest(this.getIDTokenClaimsRequest(), this.getUserInfoClaimsRequest(), this.getIDTokenVerifiedClaimsRequests(), list != null ? OIDCClaimsRequest.toCurrent(list) : Collections.emptyList());
    }

    public OIDCClaimsRequest withUserInfoVerifiedClaimsRequest(macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.request.VerifiedClaimsSetRequest verifiedClaimsSetRequest) {
        return new OIDCClaimsRequest(this.getIDTokenClaimsRequest(), this.getUserInfoClaimsRequest(), this.getIDTokenVerifiedClaimsRequests(), verifiedClaimsSetRequest != null ? Collections.singletonList(verifiedClaimsSetRequest) : Collections.emptyList());
    }

    @Deprecated
    public OIDCClaimsRequest withUserInfoVerifiedClaimsRequest(VerifiedClaimsSetRequest verifiedClaimsSetRequest) {
        return new OIDCClaimsRequest(this.getIDTokenClaimsRequest(), this.getUserInfoClaimsRequest(), this.getIDTokenVerifiedClaimsRequests(), verifiedClaimsSetRequest != null ? OIDCClaimsRequest.toCurrent(Collections.singletonList(verifiedClaimsSetRequest)) : Collections.emptyList());
    }

    private static JSONObject addVerified(List<macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.request.VerifiedClaimsSetRequest> list, JSONObject jSONObject) {
        if (list != null) {
            if (list.size() == 1 && list.get(0) != null) {
                JSONObject jSONObject2 = new JSONObject();
                if (jSONObject != null) {
                    jSONObject2.putAll(jSONObject);
                }
                jSONObject2.put("verified_claims", list.get(0).toJSONObject());
                return jSONObject2;
            }
            if (list.size() > 1) {
                JSONObject jSONObject3 = new JSONObject();
                if (jSONObject != null) {
                    jSONObject3.putAll(jSONObject);
                }
                JSONArray jSONArray = new JSONArray();
                for (macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.request.VerifiedClaimsSetRequest verifiedClaimsSetRequest : list) {
                    jSONArray.add(verifiedClaimsSetRequest.toJSONObject());
                }
                jSONObject3.put("verified_claims", jSONArray);
                return jSONObject3;
            }
        }
        return jSONObject;
    }

    public JSONObject toJSONObject() {
        JSONObject jSONObject = new JSONObject();
        JSONObject jSONObject2 = null;
        if (this.idToken != null) {
            jSONObject2 = this.idToken.toJSONObject();
        }
        if ((jSONObject2 = OIDCClaimsRequest.addVerified(this.idTokenVerified, jSONObject2)) != null && !jSONObject2.isEmpty()) {
            jSONObject.put("id_token", jSONObject2);
        }
        JSONObject jSONObject3 = null;
        if (this.userInfo != null) {
            jSONObject3 = this.userInfo.toJSONObject();
        }
        if ((jSONObject3 = OIDCClaimsRequest.addVerified(this.userInfoVerified, jSONObject3)) != null && !jSONObject3.isEmpty()) {
            jSONObject.put("userinfo", jSONObject3);
        }
        return jSONObject;
    }

    @Override
    public String toJSONString() {
        return this.toJSONObject().toJSONString();
    }

    public String toString() {
        return this.toJSONString();
    }

    public static OIDCClaimsRequest resolve(ResponseType responseType, Scope scope) {
        return OIDCClaimsRequest.resolve(responseType, scope, Collections.emptyMap());
    }

    public static OIDCClaimsRequest resolve(ResponseType responseType, Scope scope, Map<Scope.Value, Set<String>> map) {
        boolean bl2;
        OIDCClaimsRequest oIDCClaimsRequest = new OIDCClaimsRequest();
        if (scope == null) {
            return oIDCClaimsRequest;
        }
        LinkedList<ClaimsSetRequest.Entry> linkedList = new LinkedList<ClaimsSetRequest.Entry>();
        for (Scope.Value value : scope) {
            Set<String> set;
            if (value.equals(OIDCScopeValue.PROFILE)) {
                linkedList.addAll(OIDCScopeValue.PROFILE.toClaimsSetRequestEntries());
                continue;
            }
            if (value.equals(OIDCScopeValue.EMAIL)) {
                linkedList.addAll(OIDCScopeValue.EMAIL.toClaimsSetRequestEntries());
                continue;
            }
            if (value.equals(OIDCScopeValue.PHONE)) {
                linkedList.addAll(OIDCScopeValue.PHONE.toClaimsSetRequestEntries());
                continue;
            }
            if (value.equals(OIDCScopeValue.ADDRESS)) {
                linkedList.addAll(OIDCScopeValue.ADDRESS.toClaimsSetRequestEntries());
                continue;
            }
            if (map == null || !map.containsKey(value) || (set = map.get(value)) == null || set.isEmpty()) continue;
            for (String string : set) {
                linkedList.add(new ClaimsSetRequest.Entry(string).withClaimRequirement(ClaimRequirement.VOLUNTARY));
            }
        }
        if (linkedList.isEmpty()) {
            return oIDCClaimsRequest;
        }
        ClaimsSetRequest claimsSetRequest = new ClaimsSetRequest(linkedList);
        boolean bl3 = bl2 = responseType.contains(OIDCResponseTypeValue.ID_TOKEN) && !responseType.contains(ResponseType.Value.CODE) && !responseType.contains(ResponseType.Value.TOKEN);
        if (bl2) {
            return oIDCClaimsRequest.withIDTokenClaimsRequest(claimsSetRequest);
        }
        return oIDCClaimsRequest.withUserInfoClaimsRequest(claimsSetRequest);
    }

    public static OIDCClaimsRequest resolve(ResponseType responseType, Scope scope, OIDCClaimsRequest oIDCClaimsRequest) {
        return OIDCClaimsRequest.resolve(responseType, scope, oIDCClaimsRequest, Collections.emptyMap());
    }

    public static OIDCClaimsRequest resolve(ResponseType responseType, Scope scope, OIDCClaimsRequest oIDCClaimsRequest, Map<Scope.Value, Set<String>> map) {
        return OIDCClaimsRequest.resolve(responseType, scope, map).add(oIDCClaimsRequest);
    }

    public static OIDCClaimsRequest resolve(AuthenticationRequest authenticationRequest) {
        return OIDCClaimsRequest.resolve(authenticationRequest.getResponseType(), authenticationRequest.getScope(), authenticationRequest.getOIDCClaims());
    }

    private static macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.request.VerifiedClaimsSetRequest parseVerifiedClaimsSetRequest(JSONObject jSONObject, int n2) throws ParseException {
        try {
            return macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.request.VerifiedClaimsSetRequest.parse(jSONObject);
        }
        catch (ParseException parseException) {
            throw new ParseException("Invalid verified claims request" + (n2 > -1 ? " at position " + n2 : "") + ": " + parseException.getMessage(), parseException);
        }
    }

    private static List<macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.request.VerifiedClaimsSetRequest> parseVerified(JSONObject jSONObject) throws ParseException {
        if (!jSONObject.containsKey("verified_claims")) {
            return Collections.emptyList();
        }
        if (jSONObject.get("verified_claims") instanceof JSONObject) {
            JSONObject jSONObject2 = JSONObjectUtils.getJSONObject(jSONObject, "verified_claims");
            return Collections.singletonList(OIDCClaimsRequest.parseVerifiedClaimsSetRequest(jSONObject2, -1));
        }
        JSONArray jSONArray = JSONObjectUtils.getJSONArray(jSONObject, "verified_claims");
        LinkedList<macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.request.VerifiedClaimsSetRequest> linkedList = new LinkedList<macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.request.VerifiedClaimsSetRequest>();
        int n2 = 0;
        for (JSONObject jSONObject3 : JSONArrayUtils.toJSONObjectList(jSONArray)) {
            linkedList.add(OIDCClaimsRequest.parseVerifiedClaimsSetRequest(jSONObject3, n2++));
        }
        return linkedList;
    }

    public static OIDCClaimsRequest parse(JSONObject jSONObject) throws ParseException {
        JSONAware jSONAware;
        OIDCClaimsRequest oIDCClaimsRequest = new OIDCClaimsRequest();
        JSONObject jSONObject2 = JSONObjectUtils.getJSONObject(jSONObject, "id_token", null);
        if (jSONObject2 != null) {
            jSONAware = ClaimsSetRequest.parse(jSONObject2);
            if (!jSONAware.getEntries().isEmpty()) {
                oIDCClaimsRequest = oIDCClaimsRequest.withIDTokenClaimsRequest((ClaimsSetRequest)jSONAware);
            }
            oIDCClaimsRequest = oIDCClaimsRequest.withIDTokenVerifiedClaimsRequests(OIDCClaimsRequest.parseVerified(jSONObject2));
        }
        if ((jSONAware = JSONObjectUtils.getJSONObject(jSONObject, "userinfo", null)) != null) {
            ClaimsSetRequest claimsSetRequest = ClaimsSetRequest.parse((JSONObject)jSONAware);
            if (!claimsSetRequest.getEntries().isEmpty()) {
                oIDCClaimsRequest = oIDCClaimsRequest.withUserInfoClaimsRequest(ClaimsSetRequest.parse((JSONObject)jSONAware));
            }
            oIDCClaimsRequest = oIDCClaimsRequest.withUserInfoVerifiedClaimsRequests(OIDCClaimsRequest.parseVerified((JSONObject)jSONAware));
        }
        return oIDCClaimsRequest;
    }

    public static OIDCClaimsRequest parse(String string) throws ParseException {
        return OIDCClaimsRequest.parse(JSONObjectUtils.parse(string));
    }
}

