/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk;

import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.JWT;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.JWTParser;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.AuthorizationCode;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.AuthorizationSuccessResponse;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ResponseMode;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ResponseType;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.SerializeException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.http.HTTPRequest;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.http.HTTPResponse;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.Issuer;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.State;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.token.AccessToken;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.MultivaluedMapUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.StringUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.URIUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.AuthenticationErrorResponse;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.AuthenticationResponse;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.OIDCResponseTypeValue;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.Immutable;

@Immutable
public class AuthenticationSuccessResponse
extends AuthorizationSuccessResponse
implements AuthenticationResponse {
    private final JWT idToken;
    private final State sessionState;

    public AuthenticationSuccessResponse(URI uRI, AuthorizationCode authorizationCode, JWT jWT, AccessToken accessToken, State state, State state2, ResponseMode responseMode) {
        this(uRI, authorizationCode, jWT, accessToken, state, state2, null, responseMode);
    }

    public AuthenticationSuccessResponse(URI uRI, AuthorizationCode authorizationCode, JWT jWT, AccessToken accessToken, State state, State state2, Issuer issuer, ResponseMode responseMode) {
        super(uRI, authorizationCode, accessToken, state, issuer, responseMode);
        this.idToken = jWT;
        this.sessionState = state2;
    }

    public AuthenticationSuccessResponse(URI uRI, JWT jWT, ResponseMode responseMode) {
        super(uRI, jWT, responseMode);
        this.idToken = null;
        this.sessionState = null;
    }

    @Override
    public ResponseType impliedResponseType() {
        ResponseType responseType = new ResponseType();
        if (this.getAuthorizationCode() != null) {
            responseType.add(ResponseType.Value.CODE);
        }
        if (this.getIDToken() != null) {
            responseType.add(OIDCResponseTypeValue.ID_TOKEN);
        }
        if (this.getAccessToken() != null) {
            responseType.add(ResponseType.Value.TOKEN);
        }
        return responseType;
    }

    @Override
    public ResponseMode impliedResponseMode() {
        if (this.getResponseMode() != null) {
            return this.getResponseMode();
        }
        if (this.getJWTResponse() != null) {
            return ResponseMode.JWT;
        }
        if (this.getAccessToken() != null || this.getIDToken() != null) {
            return ResponseMode.FRAGMENT;
        }
        return ResponseMode.QUERY;
    }

    public JWT getIDToken() {
        return this.idToken;
    }

    public State getSessionState() {
        return this.sessionState;
    }

    @Override
    public Map<String, List<String>> toParameters() {
        Map<String, List<String>> map = super.toParameters();
        if (this.getJWTResponse() != null) {
            return map;
        }
        if (this.idToken != null) {
            try {
                map.put("id_token", Collections.singletonList(this.idToken.serialize()));
            }
            catch (IllegalStateException illegalStateException) {
                throw new SerializeException("Couldn't serialize ID token: " + illegalStateException.getMessage(), illegalStateException);
            }
        }
        if (this.sessionState != null) {
            map.put("session_state", Collections.singletonList(this.sessionState.getValue()));
        }
        return map;
    }

    @Override
    public AuthenticationSuccessResponse toSuccessResponse() {
        return this;
    }

    @Override
    public AuthenticationErrorResponse toErrorResponse() {
        throw new ClassCastException("Cannot cast to AuthenticationErrorResponse");
    }

    public static AuthenticationSuccessResponse parse(URI uRI, Map<String, List<String>> map) throws ParseException {
        AuthorizationSuccessResponse authorizationSuccessResponse = AuthorizationSuccessResponse.parse(uRI, map);
        if (authorizationSuccessResponse.getJWTResponse() != null) {
            return new AuthenticationSuccessResponse(uRI, authorizationSuccessResponse.getJWTResponse(), authorizationSuccessResponse.getResponseMode());
        }
        String string = MultivaluedMapUtils.getFirstValue(map, "id_token");
        JWT jWT = null;
        if (string != null) {
            try {
                jWT = JWTParser.parse(string);
            }
            catch (java.text.ParseException parseException) {
                throw new ParseException("Invalid ID Token JWT: " + parseException.getMessage(), parseException);
            }
        }
        State state = null;
        if (StringUtils.isNotBlank(MultivaluedMapUtils.getFirstValue(map, "session_state"))) {
            state = new State(MultivaluedMapUtils.getFirstValue(map, "session_state"));
        }
        return new AuthenticationSuccessResponse(uRI, authorizationSuccessResponse.getAuthorizationCode(), jWT, authorizationSuccessResponse.getAccessToken(), authorizationSuccessResponse.getState(), state, authorizationSuccessResponse.getIssuer(), null);
    }

    public static AuthenticationSuccessResponse parse(URI uRI) throws ParseException {
        return AuthenticationSuccessResponse.parse(URIUtils.getBaseURI(uRI), AuthenticationSuccessResponse.parseResponseParameters(uRI));
    }

    public static AuthenticationSuccessResponse parse(HTTPResponse hTTPResponse) throws ParseException {
        URI uRI = hTTPResponse.getLocation();
        if (uRI == null) {
            throw new ParseException("Missing redirection URI / HTTP Location header");
        }
        return AuthenticationSuccessResponse.parse(uRI);
    }

    public static AuthenticationSuccessResponse parse(HTTPRequest hTTPRequest) throws ParseException {
        return AuthenticationSuccessResponse.parse(hTTPRequest.getURI(), AuthenticationSuccessResponse.parseResponseParameters(hTTPRequest));
    }
}

