/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk;

import java.net.URI;
import java.util.List;
import java.util.Map;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.JWTClaimsSet;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.AuthorizationResponse;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.http.HTTPRequest;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.http.HTTPResponse;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.jarm.JARMUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.jarm.JARMValidator;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.MultivaluedMapUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.StringUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.URIUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.AuthenticationErrorResponse;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.AuthenticationResponse;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.AuthenticationSuccessResponse;

public class AuthenticationResponseParser {
    public static AuthenticationResponse parse(URI uRI, Map<String, List<String>> map) throws ParseException {
        return AuthenticationResponseParser.parse(uRI, map, null);
    }

    public static AuthenticationResponse parse(URI uRI, Map<String, List<String>> map, JARMValidator jARMValidator) throws ParseException {
        Map<String, List<String>> map2 = map;
        String string = MultivaluedMapUtils.getFirstValue(map, "response");
        if (jARMValidator != null) {
            if (StringUtils.isBlank(string)) {
                throw new ParseException("Missing JWT-secured (JARM) authorization response parameter");
            }
            try {
                JWTClaimsSet jWTClaimsSet = jARMValidator.validate(string);
                map2 = JARMUtils.toMultiValuedStringParameters(jWTClaimsSet);
            }
            catch (Exception exception) {
                throw new ParseException("Invalid JWT-secured (JARM) authorization response: " + exception.getMessage());
            }
        }
        if (StringUtils.isNotBlank(MultivaluedMapUtils.getFirstValue(map2, "error"))) {
            return AuthenticationErrorResponse.parse(uRI, map2);
        }
        if (StringUtils.isNotBlank(MultivaluedMapUtils.getFirstValue(map2, "response"))) {
            boolean bl2 = JARMUtils.impliesAuthorizationErrorResponse(string);
            if (bl2) {
                return AuthenticationErrorResponse.parse(uRI, map2);
            }
            return AuthenticationSuccessResponse.parse(uRI, map2);
        }
        return AuthenticationSuccessResponse.parse(uRI, map2);
    }

    public static AuthenticationResponse parse(URI uRI) throws ParseException {
        return AuthenticationResponseParser.parse(URIUtils.getBaseURI(uRI), AuthorizationResponse.parseResponseParameters(uRI));
    }

    public static AuthenticationResponse parse(URI uRI, JARMValidator jARMValidator) throws ParseException {
        if (jARMValidator == null) {
            throw new IllegalArgumentException("The JARM validator must not be null");
        }
        return AuthenticationResponseParser.parse(URIUtils.getBaseURI(uRI), AuthorizationResponse.parseResponseParameters(uRI), jARMValidator);
    }

    public static AuthenticationResponse parse(HTTPResponse hTTPResponse) throws ParseException {
        URI uRI = hTTPResponse.getLocation();
        if (uRI == null) {
            throw new ParseException("Missing redirection URI / HTTP Location header");
        }
        return AuthenticationResponseParser.parse(uRI);
    }

    public static AuthenticationResponse parse(HTTPResponse hTTPResponse, JARMValidator jARMValidator) throws ParseException {
        URI uRI = hTTPResponse.getLocation();
        if (uRI == null) {
            throw new ParseException("Missing redirection URI / HTTP Location header");
        }
        return AuthenticationResponseParser.parse(uRI, jARMValidator);
    }

    public static AuthenticationResponse parse(HTTPRequest hTTPRequest) throws ParseException {
        return AuthenticationResponseParser.parse(hTTPRequest.getURI(), AuthorizationResponse.parseResponseParameters(hTTPRequest));
    }

    public static AuthenticationResponse parse(HTTPRequest hTTPRequest, JARMValidator jARMValidator) throws ParseException {
        if (jARMValidator == null) {
            throw new IllegalArgumentException("The JARM validator must not be null");
        }
        return AuthenticationResponseParser.parse(hTTPRequest.getURI(), AuthorizationResponse.parseResponseParameters(hTTPRequest), jARMValidator);
    }

    private AuthenticationResponseParser() {
    }
}

