/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.tls;

import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.tls.TLSVersion;

public final class TLSUtils {
    public static SSLSocketFactory createSSLSocketFactory(KeyStore keyStore) throws NoSuchAlgorithmException, KeyStoreException, KeyManagementException, UnrecoverableKeyException {
        return TLSUtils.createSSLSocketFactory(keyStore, null, null, TLSVersion.TLS_1_3);
    }

    public static SSLSocketFactory createSSLSocketFactory(KeyStore keyStore, TLSVersion tLSVersion) throws NoSuchAlgorithmException, KeyStoreException, KeyManagementException, UnrecoverableKeyException {
        return TLSUtils.createSSLSocketFactory(keyStore, null, null, tLSVersion);
    }

    public static SSLSocketFactory createSSLSocketFactory(KeyStore keyStore, KeyStore keyStore2, char[] cArray, TLSVersion tLSVersion) throws NoSuchAlgorithmException, KeyStoreException, KeyManagementException, UnrecoverableKeyException {
        KeyManager[] keyManagerArray;
        SSLContext sSLContext = SSLContext.getInstance(tLSVersion.toString());
        TrustManager[] trustManagerArray = null;
        if (keyStore != null) {
            keyManagerArray = TrustManagerFactory.getInstance("PKIX");
            keyManagerArray.init(keyStore);
            trustManagerArray = keyManagerArray.getTrustManagers();
        }
        keyManagerArray = null;
        if (keyStore2 != null) {
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("PKIX");
            keyManagerFactory.init(keyStore2, cArray);
            keyManagerArray = keyManagerFactory.getKeyManagers();
        }
        sSLContext.init(keyManagerArray, trustManagerArray, null);
        return sSLContext.getSocketFactory();
    }

    private TLSUtils() {
    }
}

