/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.date;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;

public class SimpleDate {
    private final int year;
    private final int month;
    private final int day;

    public SimpleDate(int n2, int n3, int n4) {
        this.year = n2;
        this.month = n3;
        this.day = n4;
    }

    public int getYear() {
        return this.year;
    }

    public int getMonth() {
        return this.month;
    }

    public int getDay() {
        return this.day;
    }

    public String toISO8601String() {
        return this.getYear() + "-" + (this.getMonth() < 10 ? "0" : "") + this.getMonth() + "-" + (this.getDay() < 10 ? "0" : "") + this.getDay();
    }

    public String toString() {
        return this.toISO8601String();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof SimpleDate)) {
            return false;
        }
        SimpleDate simpleDate = (SimpleDate)object;
        return this.getYear() == simpleDate.getYear() && this.getMonth() == simpleDate.getMonth() && this.getDay() == simpleDate.getDay();
    }

    public int hashCode() {
        return Objects.hash(this.getYear(), this.getMonth(), this.getDay());
    }

    public static SimpleDate parseISO8601String(String string) throws ParseException {
        Pattern pattern = Pattern.compile("(\\d{4})-(\\d{2})-(\\d{2})");
        Matcher matcher = pattern.matcher(string);
        if (!matcher.matches()) {
            throw new ParseException("Invalid ISO 8601 date: YYYY-MM-DD");
        }
        return new SimpleDate(Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2)), Integer.parseInt(matcher.group(3)));
    }
}

