/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util;

import java.io.IOException;
import java.math.BigInteger;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Date;
import javax.security.auth.x500.X500Principal;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.X509CertUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.Issuer;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.Subject;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;

public final class X509CertificateUtils {
    public static boolean hasMatchingIssuerAndSubject(X509Certificate x509Certificate) {
        Principal principal = x509Certificate.getIssuerDN();
        Principal principal2 = x509Certificate.getSubjectDN();
        return principal != null && principal.equals(principal2);
    }

    public static boolean isSelfIssued(X509Certificate x509Certificate) {
        return X509CertificateUtils.hasMatchingIssuerAndSubject(x509Certificate) && X509CertificateUtils.isSelfSigned(x509Certificate);
    }

    public static boolean isSelfSigned(X509Certificate x509Certificate) {
        PublicKey publicKey = x509Certificate.getPublicKey();
        return X509CertificateUtils.hasValidSignature(x509Certificate, publicKey);
    }

    public static boolean hasValidSignature(X509Certificate x509Certificate, PublicKey publicKey) {
        try {
            x509Certificate.verify(publicKey);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public static boolean publicKeyMatches(X509Certificate x509Certificate, PublicKey publicKey) {
        PublicKey publicKey2 = x509Certificate.getPublicKey();
        return Arrays.equals(publicKey2.getEncoded(), publicKey.getEncoded());
    }

    public static X509Certificate generate(X500Principal x500Principal, X500Principal x500Principal2, Date date, Date date2, PublicKey publicKey, PrivateKey privateKey) throws OperatorCreationException, IOException {
        String string;
        BigInteger bigInteger = new BigInteger(64, new SecureRandom());
        if ("RSA".equalsIgnoreCase(privateKey.getAlgorithm())) {
            string = "SHA256withRSA";
        } else if ("EC".equalsIgnoreCase(privateKey.getAlgorithm())) {
            string = "SHA256withECDSA";
        } else {
            throw new OperatorCreationException("Unsupported signing key algorithm: " + privateKey.getAlgorithm());
        }
        X509CertificateHolder x509CertificateHolder = new JcaX509v3CertificateBuilder(x500Principal, bigInteger, date, date2, x500Principal2, publicKey).build(new JcaContentSignerBuilder(string).build(privateKey));
        return X509CertUtils.parse(x509CertificateHolder.getEncoded());
    }

    public static X509Certificate generate(Issuer issuer, Subject subject, Date date, Date date2, PublicKey publicKey, PrivateKey privateKey) throws OperatorCreationException, IOException {
        return X509CertificateUtils.generate(new X500Principal("cn=" + issuer), new X500Principal("cn=" + subject), date, date2, publicKey, privateKey);
    }

    public static X509Certificate generateSelfSigned(Issuer issuer, Date date, Date date2, PublicKey publicKey, PrivateKey privateKey) throws OperatorCreationException, IOException {
        return X509CertificateUtils.generate(issuer, new Subject(issuer.getValue()), date, date2, publicKey, privateKey);
    }

    private X509CertificateUtils() {
    }
}

