/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.token;

import java.net.URI;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.Scope;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.token.AccessTokenType;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.token.TokenSchemeError;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.Immutable;

@Immutable
public class BearerTokenError
extends TokenSchemeError {
    private static final long serialVersionUID = -5209789923955060584L;
    public static final BearerTokenError MISSING_TOKEN = new BearerTokenError(null, null, 401);
    public static final BearerTokenError INVALID_REQUEST = new BearerTokenError("invalid_request", "Invalid request", 400);
    public static final BearerTokenError INVALID_TOKEN = new BearerTokenError("invalid_token", "Invalid access token", 401);
    public static final BearerTokenError INSUFFICIENT_SCOPE = new BearerTokenError("insufficient_scope", "Insufficient scope", 403);

    public BearerTokenError(String string, String string2) {
        this(string, string2, 0, null, null, null);
    }

    public BearerTokenError(String string, String string2, int n2) {
        this(string, string2, n2, null, null, null);
    }

    public BearerTokenError(String string, String string2, int n2, URI uRI, String string3, Scope scope) {
        super(AccessTokenType.BEARER, string, string2, n2, uRI, string3, scope);
    }

    @Override
    public BearerTokenError setDescription(String string) {
        return new BearerTokenError(super.getCode(), string, super.getHTTPStatusCode(), super.getURI(), this.getRealm(), this.getScope());
    }

    @Override
    public BearerTokenError appendDescription(String string) {
        String string2 = this.getDescription() != null ? this.getDescription() + string : string;
        return new BearerTokenError(super.getCode(), string2, super.getHTTPStatusCode(), super.getURI(), this.getRealm(), this.getScope());
    }

    @Override
    public BearerTokenError setHTTPStatusCode(int n2) {
        return new BearerTokenError(super.getCode(), super.getDescription(), n2, super.getURI(), this.getRealm(), this.getScope());
    }

    @Override
    public BearerTokenError setURI(URI uRI) {
        return new BearerTokenError(super.getCode(), super.getDescription(), super.getHTTPStatusCode(), uRI, this.getRealm(), this.getScope());
    }

    @Override
    public BearerTokenError setRealm(String string) {
        return new BearerTokenError(this.getCode(), this.getDescription(), this.getHTTPStatusCode(), this.getURI(), string, this.getScope());
    }

    @Override
    public BearerTokenError setScope(Scope scope) {
        return new BearerTokenError(this.getCode(), this.getDescription(), this.getHTTPStatusCode(), this.getURI(), this.getRealm(), scope);
    }

    public static BearerTokenError parse(String string) throws ParseException {
        TokenSchemeError tokenSchemeError = TokenSchemeError.parse(string, AccessTokenType.BEARER);
        return new BearerTokenError(tokenSchemeError.getCode(), tokenSchemeError.getDescription(), tokenSchemeError.getHTTPStatusCode(), tokenSchemeError.getURI(), tokenSchemeError.getRealm(), tokenSchemeError.getScope());
    }
}

