/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.pkce;

import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.auth.Secret;

public class CodeVerifier
extends Secret {
    private static final long serialVersionUID = 1L;
    public static final int MIN_LENGTH = 43;
    public static final int MAX_LENGTH = 128;

    public CodeVerifier(String string) {
        super(string);
        if (string.length() < 43) {
            throw new IllegalArgumentException("The code verifier must be at least 43 characters");
        }
        if (string.length() > 128) {
            throw new IllegalArgumentException("The code verifier must not be longer than 128 characters");
        }
        if (!CodeVerifier.isLegal(string)) {
            throw new IllegalArgumentException("Illegal char(s) in code verifier, see RFC 7636, section 4.1");
        }
    }

    public CodeVerifier() {
        super(32);
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof CodeVerifier && super.equals(object);
    }

    static boolean isLegal(String string) {
        if (string == null) {
            return true;
        }
        for (char c2 : string.toCharArray()) {
            if (CodeVerifier.isLegal(c2)) continue;
            return false;
        }
        return true;
    }

    static boolean isLegal(char c2) {
        if (c2 > '\u007f') {
            return false;
        }
        return c2 >= 'A' && c2 <= 'Z' || c2 >= 'a' && c2 <= 'z' || c2 >= '0' && c2 <= '9' || c2 == '-' || c2 == '.' || c2 == '_' || c2 == '~';
    }
}

