/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.pkce;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.Base64URL;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.Identifier;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.pkce.CodeChallengeMethod;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.pkce.CodeVerifier;

public class CodeChallenge
extends Identifier {
    private static final long serialVersionUID = 1353706942392517197L;

    private CodeChallenge(String string) {
        super(string);
    }

    public static CodeChallenge compute(CodeChallengeMethod codeChallengeMethod, CodeVerifier codeVerifier) {
        if (CodeChallengeMethod.PLAIN.equals(codeChallengeMethod)) {
            return new CodeChallenge(codeVerifier.getValue());
        }
        if (CodeChallengeMethod.S256.equals(codeChallengeMethod)) {
            MessageDigest messageDigest;
            try {
                messageDigest = MessageDigest.getInstance("SHA-256");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new IllegalStateException(noSuchAlgorithmException.getMessage());
            }
            byte[] byArray = messageDigest.digest(codeVerifier.getValueBytes());
            return new CodeChallenge(Base64URL.encode(byArray).toString());
        }
        throw new IllegalArgumentException("Unsupported code challenge method: " + codeChallengeMethod);
    }

    public static CodeChallenge parse(String string) throws ParseException {
        try {
            return new CodeChallenge(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ParseException("Invalid code challenge: " + illegalArgumentException.getMessage(), illegalArgumentException);
        }
    }
}

