/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.dpop.verifiers;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.Base64URL;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.dpop.verifiers.DPoPIssuer;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.JWTID;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.singleuse.AlreadyUsedException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.singleuse.SingleUseChecker;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class DefaultDPoPSingleUseChecker
implements SingleUseChecker<Map.Entry<DPoPIssuer, JWTID>> {
    private final Timer timer;
    private final ConcurrentHashMap<String, Long> cachedJTIs = new ConcurrentHashMap();

    public DefaultDPoPSingleUseChecker(final long l2, long l3) {
        this.timer = new Timer("dpop-single-use-jti-cache-purge-task", true);
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                long l22 = new Date().getTime();
                long l3 = l22 - l2 * 1000L;
                for (Map.Entry entry : DefaultDPoPSingleUseChecker.this.cachedJTIs.entrySet()) {
                    if ((Long)entry.getValue() >= l3) continue;
                    DefaultDPoPSingleUseChecker.this.cachedJTIs.remove(entry.getKey());
                }
            }
        }, l3 * 1000L, l3 * 1000L);
    }

    private static Base64URL computeSHA256(JWTID jWTID) {
        byte[] byArray;
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            byArray = messageDigest.digest(jWTID.getValue().getBytes(StandardCharsets.UTF_8));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException(noSuchAlgorithmException.getMessage(), noSuchAlgorithmException);
        }
        return Base64URL.encode(byArray);
    }

    @Override
    public void markAsUsed(Map.Entry<DPoPIssuer, JWTID> entry) throws AlreadyUsedException {
        long l2;
        String string = entry.getKey().getValue() + ":" + DefaultDPoPSingleUseChecker.computeSHA256(entry.getValue());
        if (this.cachedJTIs.putIfAbsent(string, l2 = new Date().getTime()) != null) {
            throw new AlreadyUsedException("Detected jti replay");
        }
    }

    public int getCacheSize() {
        return this.cachedJTIs.size();
    }

    public void shutdown() {
        this.timer.cancel();
    }
}

