/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.dpop;

import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JOSEException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.Base64URL;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.JWTClaimsSet;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.JWTID;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.token.AccessToken;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.StringUtils;

public final class DPoPUtils {
    public static JWTClaimsSet createJWTClaimsSet(JWTID jWTID, String string, URI uRI, Date date, AccessToken accessToken) throws JOSEException {
        if (StringUtils.isBlank(string)) {
            throw new IllegalArgumentException("The HTTP method (htu) is required");
        }
        if (uRI.getQuery() != null) {
            throw new IllegalArgumentException("The HTTP URI (htu) must not have a query");
        }
        if (uRI.getFragment() != null) {
            throw new IllegalArgumentException("The HTTP URI (htu) must not have a fragment");
        }
        if (date == null) {
            throw new IllegalArgumentException("The issue time (iat) is required");
        }
        JWTClaimsSet.Builder builder = new JWTClaimsSet.Builder().jwtID(jWTID.getValue()).claim("htm", string).claim("htu", uRI.toString()).issueTime(date);
        if (accessToken != null) {
            builder = builder.claim("ath", DPoPUtils.computeSHA256(accessToken).toString());
        }
        return builder.build();
    }

    public static Base64URL computeSHA256(AccessToken accessToken) throws JOSEException {
        byte[] byArray;
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            byArray = messageDigest.digest(accessToken.getValue().getBytes(StandardCharsets.UTF_8));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new JOSEException(noSuchAlgorithmException.getMessage(), noSuchAlgorithmException);
        }
        return Base64URL.encode(byArray);
    }

    private DPoPUtils() {
    }
}

