/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.client;

import java.net.URI;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.common.contenttype.ContentType;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWSObject;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.JWTClaimsSet;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.SignedJWT;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ProtectedResourceRequest;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.SerializeException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.client.ClientMetadata;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.http.HTTPRequest;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.token.BearerAccessToken;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.StringUtils;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.Immutable;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONObject;

@Immutable
public class ClientRegistrationRequest
extends ProtectedResourceRequest {
    private final ClientMetadata metadata;
    private final SignedJWT softwareStatement;

    public ClientRegistrationRequest(URI uRI, ClientMetadata clientMetadata, BearerAccessToken bearerAccessToken) {
        this(uRI, clientMetadata, null, bearerAccessToken);
    }

    public ClientRegistrationRequest(URI uRI, ClientMetadata clientMetadata, SignedJWT signedJWT, BearerAccessToken bearerAccessToken) {
        super(uRI, bearerAccessToken);
        if (clientMetadata == null) {
            throw new IllegalArgumentException("The client metadata must not be null");
        }
        this.metadata = clientMetadata;
        if (signedJWT != null) {
            JWTClaimsSet jWTClaimsSet;
            if (signedJWT.getState() == JWSObject.State.UNSIGNED) {
                throw new IllegalArgumentException("The software statement JWT must be signed");
            }
            try {
                jWTClaimsSet = signedJWT.getJWTClaimsSet();
            }
            catch (java.text.ParseException parseException) {
                throw new IllegalArgumentException("The software statement is not a valid signed JWT: " + parseException.getMessage());
            }
            if (jWTClaimsSet.getIssuer() == null) {
                throw new IllegalArgumentException("The software statement JWT must contain an 'iss' claim");
            }
        }
        this.softwareStatement = signedJWT;
    }

    public ClientMetadata getClientMetadata() {
        return this.metadata;
    }

    public SignedJWT getSoftwareStatement() {
        return this.softwareStatement;
    }

    @Override
    public HTTPRequest toHTTPRequest() {
        if (this.getEndpointURI() == null) {
            throw new SerializeException("The endpoint URI is not specified");
        }
        HTTPRequest hTTPRequest = new HTTPRequest(HTTPRequest.Method.POST, this.getEndpointURI());
        if (this.getAccessToken() != null) {
            hTTPRequest.setAuthorization(this.getAccessToken().toAuthorizationHeader());
        }
        hTTPRequest.setEntityContentType(ContentType.APPLICATION_JSON);
        JSONObject jSONObject = this.metadata.toJSONObject();
        if (this.softwareStatement != null) {
            jSONObject.put("software_statement", this.softwareStatement.serialize());
        }
        hTTPRequest.setQuery(jSONObject.toString());
        return hTTPRequest;
    }

    public static ClientRegistrationRequest parse(HTTPRequest hTTPRequest) throws ParseException {
        hTTPRequest.ensureMethod(HTTPRequest.Method.POST);
        JSONObject jSONObject = hTTPRequest.getQueryAsJSONObject();
        SignedJWT signedJWT = null;
        if (jSONObject.containsKey("software_statement")) {
            try {
                signedJWT = SignedJWT.parse(JSONObjectUtils.getString(jSONObject, "software_statement"));
            }
            catch (java.text.ParseException parseException) {
                throw new ParseException("Invalid software statement JWT: " + parseException.getMessage());
            }
            jSONObject.remove("software_statement");
        }
        ClientMetadata clientMetadata = ClientMetadata.parse(jSONObject);
        BearerAccessToken bearerAccessToken = null;
        String string = hTTPRequest.getAuthorization();
        if (StringUtils.isNotBlank(string)) {
            bearerAccessToken = BearerAccessToken.parse(string);
        }
        try {
            return new ClientRegistrationRequest(hTTPRequest.getURI(), clientMetadata, signedJWT, bearerAccessToken);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ParseException(illegalArgumentException.getMessage(), illegalArgumentException);
        }
    }
}

