/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.client;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.EncryptionMethod;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWEAlgorithm;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWSAlgorithm;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWSObject;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.JWKSet;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.SignedJWT;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.langtag.LangTag;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.langtag.LangTagUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.GrantType;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ResponseType;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.Scope;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.auth.ClientAuthenticationMethod;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ciba.BackChannelTokenDeliveryMode;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.client.RegistrationError;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.Identifier;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.SoftwareID;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.SoftwareVersion;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.CollectionUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.URIUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.registration.ClientRegistrationType;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONArray;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONObject;

public class ClientMetadata {
    private static final Set<String> REGISTERED_PARAMETER_NAMES;
    public static final Set<String> PROHIBITED_REDIRECT_URI_SCHEMES;
    private Set<URI> redirectURIs;
    private Scope scope;
    private Set<ResponseType> responseTypes;
    private Set<GrantType> grantTypes;
    private List<String> contacts;
    private final Map<LangTag, String> nameEntries;
    private final Map<LangTag, URI> logoURIEntries;
    private final Map<LangTag, URI> uriEntries;
    private final Map<LangTag, URI> policyURIEntries;
    private final Map<LangTag, URI> tosURIEntries;
    private ClientAuthenticationMethod authMethod;
    private JWSAlgorithm authJWSAlg;
    private URI jwkSetURI;
    private JWKSet jwkSet;
    private Set<URI> requestObjectURIs;
    private JWSAlgorithm requestObjectJWSAlg;
    private JWEAlgorithm requestObjectJWEAlg;
    private EncryptionMethod requestObjectJWEEnc;
    private SoftwareID softwareID;
    private SoftwareVersion softwareVersion;
    private SignedJWT softwareStatement;
    private boolean tlsClientCertificateBoundAccessTokens = false;
    private String tlsClientAuthSubjectDN = null;
    private String tlsClientAuthSanDNS = null;
    private String tlsClientAuthSanURI = null;
    private String tlsClientAuthSanIP = null;
    private String tlsClientAuthSanEmail = null;
    private JWSAlgorithm authzJWSAlg;
    private JWEAlgorithm authzJWEAlg;
    private EncryptionMethod authzJWEEnc;
    private boolean requirePAR = false;
    private BackChannelTokenDeliveryMode backChannelTokenDeliveryMode;
    private URI backChannelClientNotificationEndpoint;
    private JWSAlgorithm backChannelAuthRequestJWSAlg;
    private boolean backChannelUserCodeParam = false;
    private List<ClientRegistrationType> clientRegistrationTypes;
    private String organizationName;
    private JSONObject customFields;

    public ClientMetadata() {
        this.nameEntries = new HashMap<LangTag, String>();
        this.logoURIEntries = new HashMap<LangTag, URI>();
        this.uriEntries = new HashMap<LangTag, URI>();
        this.policyURIEntries = new HashMap<LangTag, URI>();
        this.tosURIEntries = new HashMap<LangTag, URI>();
        this.customFields = new JSONObject();
    }

    public ClientMetadata(ClientMetadata clientMetadata) {
        this.redirectURIs = clientMetadata.getRedirectionURIs();
        this.scope = clientMetadata.getScope();
        this.responseTypes = clientMetadata.getResponseTypes();
        this.grantTypes = clientMetadata.getGrantTypes();
        this.contacts = clientMetadata.getEmailContacts();
        this.nameEntries = clientMetadata.getNameEntries();
        this.logoURIEntries = clientMetadata.getLogoURIEntries();
        this.uriEntries = clientMetadata.getURIEntries();
        this.policyURIEntries = clientMetadata.getPolicyURIEntries();
        this.tosURIEntries = clientMetadata.getTermsOfServiceURIEntries();
        this.authMethod = clientMetadata.getTokenEndpointAuthMethod();
        this.authJWSAlg = clientMetadata.getTokenEndpointAuthJWSAlg();
        this.jwkSetURI = clientMetadata.getJWKSetURI();
        this.jwkSet = clientMetadata.getJWKSet();
        this.requestObjectURIs = clientMetadata.getRequestObjectURIs();
        this.requestObjectJWSAlg = clientMetadata.getRequestObjectJWSAlg();
        this.requestObjectJWEAlg = clientMetadata.getRequestObjectJWEAlg();
        this.requestObjectJWEEnc = clientMetadata.getRequestObjectJWEEnc();
        this.softwareID = clientMetadata.getSoftwareID();
        this.softwareVersion = clientMetadata.getSoftwareVersion();
        this.softwareStatement = clientMetadata.getSoftwareStatement();
        this.tlsClientCertificateBoundAccessTokens = clientMetadata.getTLSClientCertificateBoundAccessTokens();
        this.tlsClientAuthSubjectDN = clientMetadata.getTLSClientAuthSubjectDN();
        this.tlsClientAuthSanDNS = clientMetadata.getTLSClientAuthSanDNS();
        this.tlsClientAuthSanURI = clientMetadata.getTLSClientAuthSanURI();
        this.tlsClientAuthSanIP = clientMetadata.getTLSClientAuthSanIP();
        this.tlsClientAuthSanEmail = clientMetadata.getTLSClientAuthSanEmail();
        this.authzJWSAlg = clientMetadata.getAuthorizationJWSAlg();
        this.authzJWEAlg = clientMetadata.getAuthorizationJWEAlg();
        this.authzJWEEnc = clientMetadata.getAuthorizationJWEEnc();
        this.requirePAR = clientMetadata.requiresPushedAuthorizationRequests();
        this.backChannelTokenDeliveryMode = clientMetadata.getBackChannelTokenDeliveryMode();
        this.backChannelClientNotificationEndpoint = clientMetadata.getBackChannelClientNotificationEndpoint();
        this.backChannelAuthRequestJWSAlg = clientMetadata.getBackChannelAuthRequestJWSAlg();
        this.backChannelUserCodeParam = clientMetadata.supportsBackChannelUserCodeParam();
        this.clientRegistrationTypes = clientMetadata.getClientRegistrationTypes();
        this.organizationName = clientMetadata.getOrganizationName();
        this.customFields = clientMetadata.getCustomFields();
    }

    public static Set<String> getRegisteredParameterNames() {
        return REGISTERED_PARAMETER_NAMES;
    }

    public Set<URI> getRedirectionURIs() {
        return this.redirectURIs;
    }

    public URI getRedirectionURI() {
        if (this.redirectURIs != null && !this.redirectURIs.isEmpty()) {
            return this.redirectURIs.iterator().next();
        }
        return null;
    }

    public Set<String> getRedirectionURIStrings() {
        if (this.redirectURIs == null) {
            return null;
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (URI uRI : this.redirectURIs) {
            hashSet.add(uRI.toString());
        }
        return hashSet;
    }

    public void setRedirectionURIs(Set<URI> set) {
        if (set != null) {
            for (URI uRI : set) {
                if (uRI == null) {
                    throw new IllegalArgumentException("The redirect_uri must not be null");
                }
                if (uRI.getFragment() != null) {
                    throw new IllegalArgumentException("The redirect_uri must not contain fragment");
                }
                URIUtils.ensureSchemeIsNotProhibited(uRI, PROHIBITED_REDIRECT_URI_SCHEMES);
            }
            this.redirectURIs = Collections.unmodifiableSet(set);
        } else {
            this.redirectURIs = null;
        }
    }

    public void setRedirectionURI(URI uRI) {
        this.setRedirectionURIs(uRI != null ? Collections.singleton(uRI) : null);
    }

    public Scope getScope() {
        return this.scope;
    }

    public boolean hasScopeValue(Scope.Value value) {
        return this.scope != null && this.scope.contains(value);
    }

    public void setScope(Scope scope) {
        this.scope = scope;
    }

    public Set<ResponseType> getResponseTypes() {
        return this.responseTypes;
    }

    public void setResponseTypes(Set<ResponseType> set) {
        this.responseTypes = set;
    }

    public Set<GrantType> getGrantTypes() {
        return this.grantTypes;
    }

    public void setGrantTypes(Set<GrantType> set) {
        this.grantTypes = set;
    }

    public List<String> getEmailContacts() {
        return this.contacts;
    }

    public void setEmailContacts(List<String> list) {
        this.contacts = list;
    }

    public String getName() {
        return this.getName(null);
    }

    public String getName(LangTag langTag) {
        return this.nameEntries.get(langTag);
    }

    public Map<LangTag, String> getNameEntries() {
        return this.nameEntries;
    }

    public void setName(String string) {
        this.nameEntries.put(null, string);
    }

    public void setName(String string, LangTag langTag) {
        this.nameEntries.put(langTag, string);
    }

    public URI getLogoURI() {
        return this.getLogoURI(null);
    }

    public URI getLogoURI(LangTag langTag) {
        return this.logoURIEntries.get(langTag);
    }

    public Map<LangTag, URI> getLogoURIEntries() {
        return this.logoURIEntries;
    }

    public void setLogoURI(URI uRI) {
        this.logoURIEntries.put(null, uRI);
    }

    public void setLogoURI(URI uRI, LangTag langTag) {
        this.logoURIEntries.put(langTag, uRI);
    }

    public URI getURI() {
        return this.getURI(null);
    }

    public URI getURI(LangTag langTag) {
        return this.uriEntries.get(langTag);
    }

    public Map<LangTag, URI> getURIEntries() {
        return this.uriEntries;
    }

    public void setURI(URI uRI) {
        URIUtils.ensureSchemeIsHTTPSorHTTP(uRI);
        this.uriEntries.put(null, uRI);
    }

    public void setURI(URI uRI, LangTag langTag) {
        URIUtils.ensureSchemeIsHTTPSorHTTP(uRI);
        this.uriEntries.put(langTag, uRI);
    }

    public URI getPolicyURI() {
        return this.getPolicyURI(null);
    }

    public URI getPolicyURI(LangTag langTag) {
        return this.policyURIEntries.get(langTag);
    }

    public Map<LangTag, URI> getPolicyURIEntries() {
        return this.policyURIEntries;
    }

    public void setPolicyURI(URI uRI) {
        URIUtils.ensureSchemeIsHTTPSorHTTP(uRI);
        this.policyURIEntries.put(null, uRI);
    }

    public void setPolicyURI(URI uRI, LangTag langTag) {
        URIUtils.ensureSchemeIsHTTPSorHTTP(uRI);
        this.policyURIEntries.put(langTag, uRI);
    }

    public URI getTermsOfServiceURI() {
        return this.getTermsOfServiceURI(null);
    }

    public URI getTermsOfServiceURI(LangTag langTag) {
        return this.tosURIEntries.get(langTag);
    }

    public Map<LangTag, URI> getTermsOfServiceURIEntries() {
        return this.tosURIEntries;
    }

    public void setTermsOfServiceURI(URI uRI) {
        URIUtils.ensureSchemeIsHTTPSorHTTP(uRI);
        this.tosURIEntries.put(null, uRI);
    }

    public void setTermsOfServiceURI(URI uRI, LangTag langTag) {
        URIUtils.ensureSchemeIsHTTPSorHTTP(uRI);
        this.tosURIEntries.put(langTag, uRI);
    }

    public ClientAuthenticationMethod getTokenEndpointAuthMethod() {
        return this.authMethod;
    }

    public void setTokenEndpointAuthMethod(ClientAuthenticationMethod clientAuthenticationMethod) {
        this.authMethod = clientAuthenticationMethod;
    }

    public JWSAlgorithm getTokenEndpointAuthJWSAlg() {
        return this.authJWSAlg;
    }

    public void setTokenEndpointAuthJWSAlg(JWSAlgorithm jWSAlgorithm) {
        this.authJWSAlg = jWSAlgorithm;
    }

    public URI getJWKSetURI() {
        return this.jwkSetURI;
    }

    public void setJWKSetURI(URI uRI) {
        this.jwkSetURI = uRI;
    }

    public JWKSet getJWKSet() {
        return this.jwkSet;
    }

    public void setJWKSet(JWKSet jWKSet) {
        this.jwkSet = jWKSet;
    }

    public Set<URI> getRequestObjectURIs() {
        return this.requestObjectURIs;
    }

    public void setRequestObjectURIs(Set<URI> set) {
        this.requestObjectURIs = set;
    }

    public JWSAlgorithm getRequestObjectJWSAlg() {
        return this.requestObjectJWSAlg;
    }

    public void setRequestObjectJWSAlg(JWSAlgorithm jWSAlgorithm) {
        this.requestObjectJWSAlg = jWSAlgorithm;
    }

    public JWEAlgorithm getRequestObjectJWEAlg() {
        return this.requestObjectJWEAlg;
    }

    public void setRequestObjectJWEAlg(JWEAlgorithm jWEAlgorithm) {
        this.requestObjectJWEAlg = jWEAlgorithm;
    }

    public EncryptionMethod getRequestObjectJWEEnc() {
        return this.requestObjectJWEEnc;
    }

    public void setRequestObjectJWEEnc(EncryptionMethod encryptionMethod) {
        this.requestObjectJWEEnc = encryptionMethod;
    }

    public SoftwareID getSoftwareID() {
        return this.softwareID;
    }

    public void setSoftwareID(SoftwareID softwareID) {
        this.softwareID = softwareID;
    }

    public SoftwareVersion getSoftwareVersion() {
        return this.softwareVersion;
    }

    public void setSoftwareVersion(SoftwareVersion softwareVersion) {
        this.softwareVersion = softwareVersion;
    }

    public SignedJWT getSoftwareStatement() {
        return this.softwareStatement;
    }

    public void setSoftwareStatement(SignedJWT signedJWT) {
        if (signedJWT != null && signedJWT.getState().equals((Object)JWSObject.State.UNSIGNED)) {
            throw new IllegalArgumentException("The software statement must be signed");
        }
        this.softwareStatement = signedJWT;
    }

    public boolean getTLSClientCertificateBoundAccessTokens() {
        return this.tlsClientCertificateBoundAccessTokens;
    }

    public void setTLSClientCertificateBoundAccessTokens(boolean bl2) {
        this.tlsClientCertificateBoundAccessTokens = bl2;
    }

    @Deprecated
    public boolean getMutualTLSSenderConstrainedAccessTokens() {
        return this.tlsClientCertificateBoundAccessTokens;
    }

    @Deprecated
    public void setMutualTLSSenderConstrainedAccessTokens(boolean bl2) {
        this.tlsClientCertificateBoundAccessTokens = bl2;
    }

    public String getTLSClientAuthSubjectDN() {
        return this.tlsClientAuthSubjectDN;
    }

    public void setTLSClientAuthSubjectDN(String string) {
        this.tlsClientAuthSubjectDN = string;
    }

    public String getTLSClientAuthSanDNS() {
        return this.tlsClientAuthSanDNS;
    }

    public void setTLSClientAuthSanDNS(String string) {
        this.tlsClientAuthSanDNS = string;
    }

    public String getTLSClientAuthSanURI() {
        return this.tlsClientAuthSanURI;
    }

    public void setTLSClientAuthSanURI(String string) {
        this.tlsClientAuthSanURI = string;
    }

    public String getTLSClientAuthSanIP() {
        return this.tlsClientAuthSanIP;
    }

    public void setTLSClientAuthSanIP(String string) {
        this.tlsClientAuthSanIP = string;
    }

    public String getTLSClientAuthSanEmail() {
        return this.tlsClientAuthSanEmail;
    }

    public void setTLSClientAuthSanEmail(String string) {
        this.tlsClientAuthSanEmail = string;
    }

    private void ensureExactlyOneCertSubjectFieldForTLSClientAuth() throws IllegalStateException {
        if (!ClientAuthenticationMethod.TLS_CLIENT_AUTH.equals(this.getTokenEndpointAuthMethod())) {
            return;
        }
        if (this.tlsClientAuthSubjectDN == null && this.tlsClientAuthSanDNS == null && this.tlsClientAuthSanURI == null && this.tlsClientAuthSanIP == null && this.tlsClientAuthSanEmail == null) {
            throw new IllegalStateException("A certificate field must be specified to indicate the subject in tls_client_auth: tls_client_auth_subject_dn, tls_client_auth_san_dns, tls_client_auth_san_uri, tls_client_auth_san_ip or tls_client_auth_san_email");
        }
        String string = "Exactly one certificate field must be specified to indicate the subject in tls_client_auth: tls_client_auth_subject_dn, tls_client_auth_san_dns, tls_client_auth_san_uri, tls_client_auth_san_ip or tls_client_auth_san_email";
        if (this.tlsClientAuthSubjectDN != null && (this.tlsClientAuthSanDNS != null || this.tlsClientAuthSanURI != null || this.tlsClientAuthSanIP != null || this.tlsClientAuthSanEmail != null)) {
            throw new IllegalStateException(string);
        }
        if (this.tlsClientAuthSanDNS != null && (this.tlsClientAuthSanURI != null || this.tlsClientAuthSanIP != null || this.tlsClientAuthSanEmail != null)) {
            throw new IllegalStateException(string);
        }
        if (this.tlsClientAuthSanURI != null && (this.tlsClientAuthSanIP != null || this.tlsClientAuthSanEmail != null)) {
            throw new IllegalStateException(string);
        }
        if (this.tlsClientAuthSanIP != null && this.tlsClientAuthSanEmail != null) {
            throw new IllegalStateException(string);
        }
    }

    public JWSAlgorithm getAuthorizationJWSAlg() {
        return this.authzJWSAlg;
    }

    public void setAuthorizationJWSAlg(JWSAlgorithm jWSAlgorithm) {
        if (new JWSAlgorithm("none").equals(jWSAlgorithm)) {
            throw new IllegalArgumentException("The JWS algorithm must not be \"none\"");
        }
        this.authzJWSAlg = jWSAlgorithm;
    }

    public JWEAlgorithm getAuthorizationJWEAlg() {
        return this.authzJWEAlg;
    }

    public void setAuthorizationJWEAlg(JWEAlgorithm jWEAlgorithm) {
        this.authzJWEAlg = jWEAlgorithm;
    }

    public EncryptionMethod getAuthorizationJWEEnc() {
        return this.authzJWEEnc;
    }

    public void setAuthorizationJWEEnc(EncryptionMethod encryptionMethod) {
        this.authzJWEEnc = encryptionMethod;
    }

    public boolean requiresPushedAuthorizationRequests() {
        return this.requirePAR;
    }

    public void requiresPushedAuthorizationRequests(boolean bl2) {
        this.requirePAR = bl2;
    }

    public BackChannelTokenDeliveryMode getBackChannelTokenDeliveryMode() {
        return this.backChannelTokenDeliveryMode;
    }

    public void setBackChannelTokenDeliveryMode(BackChannelTokenDeliveryMode backChannelTokenDeliveryMode) {
        this.backChannelTokenDeliveryMode = backChannelTokenDeliveryMode;
    }

    public URI getBackChannelClientNotificationEndpoint() {
        return this.backChannelClientNotificationEndpoint;
    }

    public void setBackChannelClientNotificationEndpoint(URI uRI) {
        this.backChannelClientNotificationEndpoint = uRI;
    }

    public JWSAlgorithm getBackChannelAuthRequestJWSAlg() {
        return this.backChannelAuthRequestJWSAlg;
    }

    public void setBackChannelAuthRequestJWSAlg(JWSAlgorithm jWSAlgorithm) {
        this.backChannelAuthRequestJWSAlg = jWSAlgorithm;
    }

    public boolean supportsBackChannelUserCodeParam() {
        return this.backChannelUserCodeParam;
    }

    public void setSupportsBackChannelUserCodeParam(boolean bl2) {
        this.backChannelUserCodeParam = bl2;
    }

    public List<ClientRegistrationType> getClientRegistrationTypes() {
        return this.clientRegistrationTypes;
    }

    public void setClientRegistrationTypes(List<ClientRegistrationType> list) {
        this.clientRegistrationTypes = list;
    }

    public String getOrganizationName() {
        return this.organizationName;
    }

    public void setOrganizationName(String string) {
        this.organizationName = string;
    }

    public Object getCustomField(String string) {
        return this.customFields.get(string);
    }

    public JSONObject getCustomFields() {
        return this.customFields;
    }

    public void setCustomField(String string, Object object) {
        this.customFields.put(string, object);
    }

    public void setCustomFields(JSONObject jSONObject) {
        if (jSONObject == null) {
            throw new IllegalArgumentException("The custom fields JSON object must not be null");
        }
        this.customFields = jSONObject;
    }

    public void applyDefaults() {
        if (this.responseTypes == null) {
            this.responseTypes = new HashSet<ResponseType>();
            this.responseTypes.add(ResponseType.getDefault());
        }
        if (this.grantTypes == null) {
            this.grantTypes = new HashSet<GrantType>();
            this.grantTypes.add(GrantType.AUTHORIZATION_CODE);
        }
        if (this.authMethod == null) {
            this.authMethod = this.grantTypes.contains(GrantType.IMPLICIT) && this.grantTypes.size() == 1 ? ClientAuthenticationMethod.NONE : ClientAuthenticationMethod.getDefault();
        }
        if (this.authzJWEAlg != null && this.authzJWEEnc == null) {
            this.authzJWEEnc = EncryptionMethod.A128CBC_HS256;
        }
    }

    public JSONObject toJSONObject() {
        return this.toJSONObject(true);
    }

    public JSONObject toJSONObject(boolean bl2) {
        Object object;
        Iterator<Map.Entry<LangTag, URI>> iterator;
        this.ensureExactlyOneCertSubjectFieldForTLSClientAuth();
        JSONObject jSONObject = bl2 ? new JSONObject(this.customFields) : new JSONObject();
        if (this.redirectURIs != null) {
            jSONObject.put("redirect_uris", URIUtils.toStringList(this.redirectURIs));
        }
        if (this.scope != null) {
            jSONObject.put("scope", this.scope.toString());
        }
        if (this.responseTypes != null) {
            iterator = new JSONArray();
            for (ResponseType responseType : this.responseTypes) {
                ((ArrayList)((Object)iterator)).add((Map.Entry<LangTag, URI>)((Object)responseType.toString()));
            }
            jSONObject.put("response_types", iterator);
        }
        if (this.grantTypes != null) {
            iterator = new JSONArray();
            for (GrantType grantType : this.grantTypes) {
                ((ArrayList)((Object)iterator)).add((Map.Entry<LangTag, URI>)((Object)grantType.toString()));
            }
            jSONObject.put("grant_types", iterator);
        }
        if (this.contacts != null) {
            jSONObject.put("contacts", this.contacts);
        }
        if (!this.nameEntries.isEmpty()) {
            for (Map.Entry<LangTag, URI> entry : this.nameEntries.entrySet()) {
                LangTag langTag = entry.getKey();
                object = (String)((Object)entry.getValue());
                if (object == null) continue;
                if (langTag == null) {
                    jSONObject.put("client_name", entry.getValue());
                    continue;
                }
                jSONObject.put("client_name#" + langTag, entry.getValue());
            }
        }
        if (!this.logoURIEntries.isEmpty()) {
            for (Map.Entry<LangTag, URI> entry : this.logoURIEntries.entrySet()) {
                LangTag langTag = entry.getKey();
                object = entry.getValue();
                if (object == null) continue;
                if (langTag == null) {
                    jSONObject.put("logo_uri", entry.getValue().toString());
                    continue;
                }
                jSONObject.put("logo_uri#" + langTag, entry.getValue().toString());
            }
        }
        if (!this.uriEntries.isEmpty()) {
            for (Map.Entry<LangTag, URI> entry : this.uriEntries.entrySet()) {
                LangTag langTag = entry.getKey();
                object = entry.getValue();
                if (object == null) continue;
                if (langTag == null) {
                    jSONObject.put("client_uri", entry.getValue().toString());
                    continue;
                }
                jSONObject.put("client_uri#" + langTag, entry.getValue().toString());
            }
        }
        if (!this.policyURIEntries.isEmpty()) {
            for (Map.Entry<LangTag, URI> entry : this.policyURIEntries.entrySet()) {
                LangTag langTag = entry.getKey();
                object = entry.getValue();
                if (object == null) continue;
                if (langTag == null) {
                    jSONObject.put("policy_uri", entry.getValue().toString());
                    continue;
                }
                jSONObject.put("policy_uri#" + langTag, entry.getValue().toString());
            }
        }
        if (!this.tosURIEntries.isEmpty()) {
            for (Map.Entry<LangTag, URI> entry : this.tosURIEntries.entrySet()) {
                LangTag langTag = entry.getKey();
                object = entry.getValue();
                if (object == null) continue;
                if (langTag == null) {
                    jSONObject.put("tos_uri", entry.getValue().toString());
                    continue;
                }
                jSONObject.put("tos_uri#" + langTag, entry.getValue().toString());
            }
        }
        if (this.authMethod != null) {
            jSONObject.put("token_endpoint_auth_method", this.authMethod.toString());
        }
        if (this.authJWSAlg != null) {
            jSONObject.put("token_endpoint_auth_signing_alg", this.authJWSAlg.getName());
        }
        if (this.jwkSetURI != null) {
            jSONObject.put("jwks_uri", this.jwkSetURI.toString());
        }
        if (this.jwkSet != null) {
            jSONObject.put("jwks", JSONObjectUtils.toJSONObject(this.jwkSet.toPublicJWKSet()));
        }
        if (this.requestObjectURIs != null) {
            jSONObject.put("request_uris", URIUtils.toStringList(this.requestObjectURIs));
        }
        if (this.requestObjectJWSAlg != null) {
            jSONObject.put("request_object_signing_alg", this.requestObjectJWSAlg.getName());
        }
        if (this.requestObjectJWEAlg != null) {
            jSONObject.put("request_object_encryption_alg", this.requestObjectJWEAlg.getName());
        }
        if (this.requestObjectJWEEnc != null) {
            jSONObject.put("request_object_encryption_enc", this.requestObjectJWEEnc.getName());
        }
        if (this.softwareID != null) {
            jSONObject.put("software_id", this.softwareID.getValue());
        }
        if (this.softwareVersion != null) {
            jSONObject.put("software_version", this.softwareVersion.getValue());
        }
        if (this.softwareStatement != null) {
            jSONObject.put("software_statement", this.softwareStatement.serialize());
        }
        if (this.getTLSClientCertificateBoundAccessTokens()) {
            jSONObject.put("tls_client_certificate_bound_access_tokens", this.tlsClientCertificateBoundAccessTokens);
        }
        if (this.tlsClientAuthSubjectDN != null) {
            jSONObject.put("tls_client_auth_subject_dn", this.tlsClientAuthSubjectDN);
        }
        if (this.tlsClientAuthSanDNS != null) {
            jSONObject.put("tls_client_auth_san_dns", this.tlsClientAuthSanDNS);
        }
        if (this.tlsClientAuthSanURI != null) {
            jSONObject.put("tls_client_auth_san_uri", this.tlsClientAuthSanURI);
        }
        if (this.tlsClientAuthSanIP != null) {
            jSONObject.put("tls_client_auth_san_ip", this.tlsClientAuthSanIP);
        }
        if (this.tlsClientAuthSanEmail != null) {
            jSONObject.put("tls_client_auth_san_email", this.tlsClientAuthSanEmail);
        }
        if (this.authzJWSAlg != null) {
            jSONObject.put("authorization_signed_response_alg", this.authzJWSAlg.getName());
        }
        if (this.authzJWEAlg != null) {
            jSONObject.put("authorization_encrypted_response_alg", this.authzJWEAlg.getName());
        }
        if (this.authzJWEEnc != null) {
            jSONObject.put("authorization_encrypted_response_enc", this.authzJWEEnc.getName());
        }
        if (this.requirePAR) {
            jSONObject.put("require_pushed_authorization_requests", true);
        }
        if (this.backChannelTokenDeliveryMode != null) {
            jSONObject.put("backchannel_token_delivery_mode", this.backChannelTokenDeliveryMode.getValue());
        }
        if (this.backChannelClientNotificationEndpoint != null) {
            jSONObject.put("backchannel_client_notification_endpoint", this.backChannelClientNotificationEndpoint.toString());
        }
        if (this.backChannelAuthRequestJWSAlg != null) {
            jSONObject.put("backchannel_authentication_request_signing_alg", this.backChannelAuthRequestJWSAlg.getName());
        }
        if (this.backChannelUserCodeParam) {
            jSONObject.put("backchannel_user_code_parameter", true);
        }
        if (CollectionUtils.isNotEmpty(this.clientRegistrationTypes)) {
            jSONObject.put("client_registration_types", Identifier.toStringList(this.clientRegistrationTypes));
            jSONObject.put("federation_type", Identifier.toStringList(this.clientRegistrationTypes));
        }
        if (this.organizationName != null) {
            jSONObject.put("organization_name", this.organizationName);
        }
        return jSONObject;
    }

    public String toString() {
        return this.toJSONObject().toJSONString();
    }

    public static ClientMetadata parse(JSONObject jSONObject) throws ParseException {
        return ClientMetadata.parseFromModifiableJSONObject(new JSONObject(jSONObject));
    }

    /*
     * WARNING - void declaration
     */
    private static ClientMetadata parseFromModifiableJSONObject(JSONObject jSONObject) throws ParseException {
        Map<LangTag, Object> map;
        ClientMetadata clientMetadata = new ClientMetadata();
        if (jSONObject.get("redirect_uris") != null) {
            map = new LinkedHashSet<URI>();
            for (String string : JSONObjectUtils.getStringArray(jSONObject, "redirect_uris")) {
                URI uRI;
                try {
                    uRI = new URI(string);
                }
                catch (URISyntaxException uRISyntaxException) {
                    throw new ParseException("Invalid redirect_uris parameter: " + uRISyntaxException.getMessage(), RegistrationError.INVALID_REDIRECT_URI.appendDescription(": " + uRISyntaxException.getMessage()));
                }
                map.add(uRI);
            }
            try {
                clientMetadata.setRedirectionURIs((Set<URI>)((Object)map));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new ParseException("Invalid redirect_uris parameter: " + illegalArgumentException.getMessage(), RegistrationError.INVALID_REDIRECT_URI.appendDescription(": " + illegalArgumentException.getMessage()));
            }
            jSONObject.remove("redirect_uris");
        }
        try {
            Object object;
            if (jSONObject.get("scope") != null) {
                clientMetadata.setScope(Scope.parse(JSONObjectUtils.getString(jSONObject, "scope")));
                jSONObject.remove("scope");
            }
            if (jSONObject.get("response_types") != null) {
                map = new LinkedHashSet();
                for (String string : JSONObjectUtils.getStringArray(jSONObject, "response_types")) {
                    map.add(ResponseType.parse(string));
                }
                clientMetadata.setResponseTypes((Set<ResponseType>)((Object)map));
                jSONObject.remove("response_types");
            }
            if (jSONObject.get("grant_types") != null) {
                map = new LinkedHashSet();
                for (String string : JSONObjectUtils.getStringArray(jSONObject, "grant_types")) {
                    map.add(GrantType.parse(string));
                }
                clientMetadata.setGrantTypes((Set<GrantType>)((Object)map));
                jSONObject.remove("grant_types");
            }
            if (jSONObject.get("contacts") != null) {
                clientMetadata.setEmailContacts(JSONObjectUtils.getStringList(jSONObject, "contacts"));
                jSONObject.remove("contacts");
            }
            map = LangTagUtils.find("client_name", jSONObject);
            for (Map.Entry entry : map.entrySet()) {
                try {
                    clientMetadata.setName((String)entry.getValue(), (LangTag)entry.getKey());
                }
                catch (ClassCastException exception) {
                    throw new ParseException("Invalid client_name (language tag) parameter");
                }
                ClientMetadata.removeMember(jSONObject, "client_name", (LangTag)entry.getKey());
            }
            map = LangTagUtils.find("logo_uri", jSONObject);
            for (Map.Entry entry : map.entrySet()) {
                if (entry.getValue() == null) continue;
                try {
                    clientMetadata.setLogoURI(new URI((String)entry.getValue()), (LangTag)entry.getKey());
                }
                catch (Exception exception) {
                    throw new ParseException("Invalid logo_uri (language tag) parameter");
                }
                ClientMetadata.removeMember(jSONObject, "logo_uri", (LangTag)entry.getKey());
            }
            map = LangTagUtils.find("client_uri", jSONObject);
            for (Map.Entry entry : map.entrySet()) {
                if (entry.getValue() == null) continue;
                try {
                    clientMetadata.setURI(new URI((String)entry.getValue()), (LangTag)entry.getKey());
                }
                catch (Exception exception) {
                    throw new ParseException("Invalid client_uri (language tag) parameter: " + exception.getMessage());
                }
                ClientMetadata.removeMember(jSONObject, "client_uri", (LangTag)entry.getKey());
            }
            map = LangTagUtils.find("policy_uri", jSONObject);
            for (Map.Entry entry : map.entrySet()) {
                if (entry.getValue() == null) continue;
                try {
                    clientMetadata.setPolicyURI(new URI((String)entry.getValue()), (LangTag)entry.getKey());
                }
                catch (Exception string) {
                    throw new ParseException("Invalid policy_uri (language tag) parameter: " + string.getMessage());
                }
                ClientMetadata.removeMember(jSONObject, "policy_uri", (LangTag)entry.getKey());
            }
            map = LangTagUtils.find("tos_uri", jSONObject);
            for (Map.Entry entry : map.entrySet()) {
                if (entry.getValue() == null) continue;
                try {
                    clientMetadata.setTermsOfServiceURI(new URI((String)entry.getValue()), (LangTag)entry.getKey());
                }
                catch (Exception string) {
                    throw new ParseException("Invalid tos_uri (language tag) parameter: " + string.getMessage());
                }
                ClientMetadata.removeMember(jSONObject, "tos_uri", (LangTag)entry.getKey());
            }
            if (jSONObject.get("token_endpoint_auth_method") != null) {
                clientMetadata.setTokenEndpointAuthMethod(ClientAuthenticationMethod.parse(JSONObjectUtils.getString(jSONObject, "token_endpoint_auth_method")));
                jSONObject.remove("token_endpoint_auth_method");
            }
            if (jSONObject.get("token_endpoint_auth_signing_alg") != null) {
                clientMetadata.setTokenEndpointAuthJWSAlg(JWSAlgorithm.parse(JSONObjectUtils.getString(jSONObject, "token_endpoint_auth_signing_alg")));
                jSONObject.remove("token_endpoint_auth_signing_alg");
            }
            if (jSONObject.get("jwks_uri") != null) {
                clientMetadata.setJWKSetURI(JSONObjectUtils.getURI(jSONObject, "jwks_uri"));
                jSONObject.remove("jwks_uri");
            }
            if (jSONObject.get("jwks") != null) {
                try {
                    clientMetadata.setJWKSet(JWKSet.parse(JSONObjectUtils.getJSONObject(jSONObject, "jwks")));
                }
                catch (java.text.ParseException parseException) {
                    throw new ParseException(parseException.getMessage(), parseException);
                }
                jSONObject.remove("jwks");
            }
            if (jSONObject.get("request_uris") != null) {
                void var6_33;
                object = new LinkedHashSet();
                String[] stringArray = JSONObjectUtils.getStringArray(jSONObject, "request_uris");
                int exception = stringArray.length;
                boolean bl2 = false;
                while (var6_33 < exception) {
                    String string = stringArray[var6_33];
                    try {
                        object.add(new URI(string));
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        throw new ParseException("Invalid request_uris parameter");
                    }
                    ++var6_33;
                }
                clientMetadata.setRequestObjectURIs((Set<URI>)object);
                jSONObject.remove("request_uris");
            }
            if (jSONObject.get("request_object_signing_alg") != null) {
                clientMetadata.setRequestObjectJWSAlg(JWSAlgorithm.parse(JSONObjectUtils.getString(jSONObject, "request_object_signing_alg")));
                jSONObject.remove("request_object_signing_alg");
            }
            if (jSONObject.get("request_object_encryption_alg") != null) {
                clientMetadata.setRequestObjectJWEAlg(JWEAlgorithm.parse(JSONObjectUtils.getString(jSONObject, "request_object_encryption_alg")));
                jSONObject.remove("request_object_encryption_alg");
            }
            if (jSONObject.get("request_object_encryption_enc") != null) {
                clientMetadata.setRequestObjectJWEEnc(EncryptionMethod.parse(JSONObjectUtils.getString(jSONObject, "request_object_encryption_enc")));
                jSONObject.remove("request_object_encryption_enc");
            }
            if (jSONObject.get("software_id") != null) {
                clientMetadata.setSoftwareID(new SoftwareID(JSONObjectUtils.getString(jSONObject, "software_id")));
                jSONObject.remove("software_id");
            }
            if (jSONObject.get("software_version") != null) {
                clientMetadata.setSoftwareVersion(new SoftwareVersion(jSONObject.get("software_version").toString()));
                jSONObject.remove("software_version");
            }
            if (jSONObject.get("software_statement") != null) {
                try {
                    clientMetadata.setSoftwareStatement(SignedJWT.parse(JSONObjectUtils.getString(jSONObject, "software_statement")));
                }
                catch (java.text.ParseException parseException) {
                    throw new ParseException("Invalid software_statement JWT: " + parseException.getMessage());
                }
                jSONObject.remove("software_statement");
            }
            if (jSONObject.get("tls_client_certificate_bound_access_tokens") != null) {
                clientMetadata.setTLSClientCertificateBoundAccessTokens(JSONObjectUtils.getBoolean(jSONObject, "tls_client_certificate_bound_access_tokens"));
                jSONObject.remove("tls_client_certificate_bound_access_tokens");
            }
            if (jSONObject.get("tls_client_auth_subject_dn") != null) {
                clientMetadata.setTLSClientAuthSubjectDN(JSONObjectUtils.getString(jSONObject, "tls_client_auth_subject_dn"));
                jSONObject.remove("tls_client_auth_subject_dn");
            }
            if (jSONObject.get("tls_client_auth_san_dns") != null) {
                clientMetadata.setTLSClientAuthSanDNS(JSONObjectUtils.getString(jSONObject, "tls_client_auth_san_dns"));
                jSONObject.remove("tls_client_auth_san_dns");
            }
            if (jSONObject.get("tls_client_auth_san_uri") != null) {
                clientMetadata.setTLSClientAuthSanURI(JSONObjectUtils.getString(jSONObject, "tls_client_auth_san_uri"));
                jSONObject.remove("tls_client_auth_san_uri");
            }
            if (jSONObject.get("tls_client_auth_san_ip") != null) {
                clientMetadata.setTLSClientAuthSanIP(JSONObjectUtils.getString(jSONObject, "tls_client_auth_san_ip"));
                jSONObject.remove("tls_client_auth_san_ip");
            }
            if (jSONObject.get("tls_client_auth_san_email") != null) {
                clientMetadata.setTLSClientAuthSanEmail(JSONObjectUtils.getString(jSONObject, "tls_client_auth_san_email"));
                jSONObject.remove("tls_client_auth_san_email");
            }
            clientMetadata.ensureExactlyOneCertSubjectFieldForTLSClientAuth();
            if (jSONObject.get("authorization_signed_response_alg") != null) {
                clientMetadata.setAuthorizationJWSAlg(JWSAlgorithm.parse(JSONObjectUtils.getString(jSONObject, "authorization_signed_response_alg")));
                jSONObject.remove("authorization_signed_response_alg");
            }
            if (jSONObject.get("authorization_encrypted_response_alg") != null) {
                clientMetadata.setAuthorizationJWEAlg(JWEAlgorithm.parse(JSONObjectUtils.getString(jSONObject, "authorization_encrypted_response_alg")));
                jSONObject.remove("authorization_encrypted_response_alg");
            }
            if (jSONObject.get("authorization_encrypted_response_enc") != null) {
                clientMetadata.setAuthorizationJWEEnc(EncryptionMethod.parse(JSONObjectUtils.getString(jSONObject, "authorization_encrypted_response_enc")));
                jSONObject.remove("authorization_encrypted_response_enc");
            }
            if (jSONObject.get("require_pushed_authorization_requests") != null) {
                clientMetadata.requiresPushedAuthorizationRequests(JSONObjectUtils.getBoolean(jSONObject, "require_pushed_authorization_requests"));
                jSONObject.remove("require_pushed_authorization_requests");
            }
            if (jSONObject.get("backchannel_token_delivery_mode") != null) {
                clientMetadata.setBackChannelTokenDeliveryMode(BackChannelTokenDeliveryMode.parse(JSONObjectUtils.getString(jSONObject, "backchannel_token_delivery_mode")));
                jSONObject.remove("backchannel_token_delivery_mode");
            }
            if (jSONObject.get("backchannel_client_notification_endpoint") != null) {
                clientMetadata.setBackChannelClientNotificationEndpoint(JSONObjectUtils.getURI(jSONObject, "backchannel_client_notification_endpoint"));
                jSONObject.remove("backchannel_client_notification_endpoint");
            }
            if (jSONObject.get("backchannel_authentication_request_signing_alg") != null) {
                clientMetadata.setBackChannelAuthRequestJWSAlg(JWSAlgorithm.parse(JSONObjectUtils.getString(jSONObject, "backchannel_authentication_request_signing_alg")));
                jSONObject.remove("backchannel_authentication_request_signing_alg");
            }
            if (jSONObject.get("backchannel_user_code_parameter") != null) {
                clientMetadata.setSupportsBackChannelUserCodeParam(JSONObjectUtils.getBoolean(jSONObject, "backchannel_user_code_parameter"));
                jSONObject.remove("backchannel_user_code_parameter");
            }
            if (jSONObject.get("client_registration_types") != null) {
                object = new LinkedList();
                for (String string : JSONObjectUtils.getStringList(jSONObject, "client_registration_types")) {
                    object.add(new ClientRegistrationType(string));
                }
                clientMetadata.setClientRegistrationTypes((List<ClientRegistrationType>)object);
                jSONObject.remove("client_registration_types");
            } else if (jSONObject.get("federation_type") != null) {
                object = new LinkedList();
                for (String string : JSONObjectUtils.getStringList(jSONObject, "federation_type")) {
                    object.add(new ClientRegistrationType(string));
                }
                clientMetadata.setClientRegistrationTypes((List<ClientRegistrationType>)object);
                jSONObject.remove("federation_type");
            }
            if (jSONObject.get("organization_name") != null) {
                clientMetadata.setOrganizationName(JSONObjectUtils.getString(jSONObject, "organization_name"));
                jSONObject.remove("organization_name");
            }
        }
        catch (IllegalStateException | ParseException exception) {
            throw new ParseException(exception.getMessage(), RegistrationError.INVALID_CLIENT_METADATA.appendDescription(": " + exception.getMessage()), exception.getCause());
        }
        clientMetadata.customFields = jSONObject;
        return clientMetadata;
    }

    private static void removeMember(JSONObject jSONObject, String string, LangTag langTag) {
        if (langTag == null) {
            jSONObject.remove(string);
        } else {
            jSONObject.remove(string + "#" + langTag);
        }
    }

    static {
        PROHIBITED_REDIRECT_URI_SCHEMES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("data", "javascript", "vbscript")));
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("redirect_uris");
        hashSet.add("scope");
        hashSet.add("response_types");
        hashSet.add("grant_types");
        hashSet.add("contacts");
        hashSet.add("client_name");
        hashSet.add("logo_uri");
        hashSet.add("client_uri");
        hashSet.add("policy_uri");
        hashSet.add("tos_uri");
        hashSet.add("token_endpoint_auth_method");
        hashSet.add("token_endpoint_auth_signing_alg");
        hashSet.add("jwks_uri");
        hashSet.add("jwks");
        hashSet.add("request_uris");
        hashSet.add("request_object_signing_alg");
        hashSet.add("request_object_encryption_alg");
        hashSet.add("request_object_encryption_enc");
        hashSet.add("require_pushed_authorization_requests");
        hashSet.add("software_id");
        hashSet.add("software_version");
        hashSet.add("software_statement");
        hashSet.add("tls_client_certificate_bound_access_tokens");
        hashSet.add("tls_client_auth_subject_dn");
        hashSet.add("tls_client_auth_san_dns");
        hashSet.add("tls_client_auth_san_uri");
        hashSet.add("tls_client_auth_san_ip");
        hashSet.add("tls_client_auth_san_email");
        hashSet.add("authorization_signed_response_alg");
        hashSet.add("authorization_encrypted_response_alg");
        hashSet.add("authorization_encrypted_response_enc");
        hashSet.add("backchannel_token_delivery_mode");
        hashSet.add("backchannel_client_notification_endpoint");
        hashSet.add("backchannel_authentication_request_signing_alg");
        hashSet.add("backchannel_user_code_parameter");
        hashSet.add("client_registration_types");
        hashSet.add("organization_name");
        REGISTERED_PARAMETER_NAMES = Collections.unmodifiableSet(hashSet);
    }
}

