/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.assertions.jwt;

import java.util.Set;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.proc.SecurityContext;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.JWTClaimsSet;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.proc.BadJWTException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.proc.DefaultJWTClaimsVerifier;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.Audience;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.CollectionUtils;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.Immutable;

@Immutable
public class JWTAssertionDetailsVerifier
extends DefaultJWTClaimsVerifier {
    private static final BadJWTException MISSING_EXP_CLAIM_EXCEPTION = new BadJWTException("Missing JWT expiration claim");
    private static final BadJWTException MISSING_AUD_CLAIM_EXCEPTION = new BadJWTException("Missing JWT audience claim");
    private static final BadJWTException MISSING_SUB_CLAIM_EXCEPTION = new BadJWTException("Missing JWT subject claim");
    private static final BadJWTException MISSING_ISS_CLAIM_EXCEPTION = new BadJWTException("Missing JWT issuer claim");
    private final Set<Audience> expectedAudience;

    public JWTAssertionDetailsVerifier(Set<Audience> set) {
        if (CollectionUtils.isEmpty(set)) {
            throw new IllegalArgumentException("The expected audience set must not be null or empty");
        }
        this.expectedAudience = set;
    }

    public Set<Audience> getExpectedAudience() {
        return this.expectedAudience;
    }

    @Override
    public void verify(JWTClaimsSet jWTClaimsSet, SecurityContext securityContext) throws BadJWTException {
        super.verify(jWTClaimsSet, null);
        if (jWTClaimsSet.getExpirationTime() == null) {
            throw MISSING_EXP_CLAIM_EXCEPTION;
        }
        if (jWTClaimsSet.getAudience() == null || jWTClaimsSet.getAudience().isEmpty()) {
            throw MISSING_AUD_CLAIM_EXCEPTION;
        }
        boolean bl2 = false;
        for (String string : jWTClaimsSet.getAudience()) {
            if (string == null || string.isEmpty() || !this.expectedAudience.contains(new Audience(string))) continue;
            bl2 = true;
        }
        if (!bl2) {
            throw new BadJWTException("Invalid JWT audience claim, expected " + this.expectedAudience);
        }
        if (jWTClaimsSet.getIssuer() == null) {
            throw MISSING_ISS_CLAIM_EXCEPTION;
        }
        if (jWTClaimsSet.getSubject() == null) {
            throw MISSING_SUB_CLAIM_EXCEPTION;
        }
    }
}

