/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.assertions.jwt;

import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.JWTClaimsSet;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.util.DateUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.assertions.AssertionDetails;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.Audience;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.Identifier;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.Issuer;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.JWTID;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.Subject;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.Immutable;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONObject;

@Immutable
public class JWTAssertionDetails
extends AssertionDetails {
    private static final Set<String> reservedClaimsNames = new LinkedHashSet<String>();
    private final Date nbf;
    private final Map<String, Object> other;

    public static Set<String> getReservedClaimsNames() {
        return Collections.unmodifiableSet(reservedClaimsNames);
    }

    public JWTAssertionDetails(Issuer issuer, Subject subject, Audience audience) {
        this(issuer, subject, audience.toSingleAudienceList(), new Date(new Date().getTime() + 300000L), null, null, new JWTID(), null);
    }

    public JWTAssertionDetails(Issuer issuer, Subject subject, List<Audience> list, Date date, Date date2, Date date3, JWTID jWTID, Map<String, Object> map) {
        super(issuer, subject, list, date3, date, jWTID);
        this.nbf = date2;
        this.other = map;
    }

    public Date getNotBeforeTime() {
        return this.nbf;
    }

    public JWTID getJWTID() {
        Identifier identifier = this.getID();
        return identifier != null ? new JWTID(identifier.getValue()) : null;
    }

    public Map<String, Object> getCustomClaims() {
        return this.other;
    }

    public JSONObject toJSONObject() {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("iss", this.getIssuer().getValue());
        jSONObject.put("sub", this.getSubject().getValue());
        jSONObject.put("aud", Audience.toStringList(this.getAudience()));
        jSONObject.put("exp", DateUtils.toSecondsSinceEpoch(this.getExpirationTime()));
        if (this.nbf != null) {
            jSONObject.put("nbf", DateUtils.toSecondsSinceEpoch(this.nbf));
        }
        if (this.getIssueTime() != null) {
            jSONObject.put("iat", DateUtils.toSecondsSinceEpoch(this.getIssueTime()));
        }
        if (this.getID() != null) {
            jSONObject.put("jti", this.getID().getValue());
        }
        if (this.other != null) {
            jSONObject.putAll(this.other);
        }
        return jSONObject;
    }

    public JWTClaimsSet toJWTClaimsSet() {
        JWTClaimsSet.Builder builder = new JWTClaimsSet.Builder().issuer(this.getIssuer().getValue()).subject(this.getSubject().getValue()).audience(Audience.toStringList(this.getAudience())).expirationTime(this.getExpirationTime()).notBeforeTime(this.nbf).issueTime(this.getIssueTime()).jwtID(this.getID() != null ? this.getJWTID().getValue() : null);
        if (this.other != null) {
            for (Map.Entry<String, Object> entry : this.other.entrySet()) {
                builder = builder.claim(entry.getKey(), entry.getValue());
            }
        }
        return builder.build();
    }

    public static JWTAssertionDetails parse(JSONObject jSONObject) throws ParseException {
        Issuer issuer = new Issuer(JSONObjectUtils.getString(jSONObject, "iss"));
        Subject subject = new Subject(JSONObjectUtils.getString(jSONObject, "sub"));
        List<Audience> list = jSONObject.get("aud") instanceof String ? new Audience(JSONObjectUtils.getString(jSONObject, "aud")).toSingleAudienceList() : Audience.create(JSONObjectUtils.getStringList(jSONObject, "aud"));
        Date date = DateUtils.fromSecondsSinceEpoch(JSONObjectUtils.getLong(jSONObject, "exp"));
        Date date2 = null;
        if (jSONObject.containsKey("nbf")) {
            date2 = DateUtils.fromSecondsSinceEpoch(JSONObjectUtils.getLong(jSONObject, "nbf"));
        }
        Date date3 = null;
        if (jSONObject.containsKey("iat")) {
            date3 = DateUtils.fromSecondsSinceEpoch(JSONObjectUtils.getLong(jSONObject, "iat"));
        }
        JWTID jWTID = null;
        if (jSONObject.containsKey("jti")) {
            jWTID = new JWTID(JSONObjectUtils.getString(jSONObject, "jti"));
        }
        LinkedHashMap<String, Object> linkedHashMap = null;
        Set set = jSONObject.keySet();
        if (set.removeAll(reservedClaimsNames)) {
            linkedHashMap = new LinkedHashMap<String, Object>();
            for (String string : set) {
                linkedHashMap.put(string, jSONObject.get(string));
            }
        }
        return new JWTAssertionDetails(issuer, subject, list, date, date2, date3, jWTID, linkedHashMap);
    }

    public static JWTAssertionDetails parse(JWTClaimsSet jWTClaimsSet) throws ParseException {
        return JWTAssertionDetails.parse(JSONObjectUtils.toJSONObject(jWTClaimsSet));
    }

    static {
        reservedClaimsNames.add("iss");
        reservedClaimsNames.add("sub");
        reservedClaimsNames.add("aud");
        reservedClaimsNames.add("exp");
        reservedClaimsNames.add("nbf");
        reservedClaimsNames.add("iat");
        reservedClaimsNames.add("jti");
    }
}

