/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.as;

import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.as.ReadOnlyAuthorizationServerEndpointMetadata;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.OrderedJSONObject;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONObject;

public class AuthorizationServerEndpointMetadata
implements ReadOnlyAuthorizationServerEndpointMetadata {
    private static final Set<String> REGISTERED_PARAMETER_NAMES;
    private URI authzEndpoint;
    private URI tokenEndpoint;
    private URI regEndpoint;
    private URI introspectionEndpoint;
    private URI revocationEndpoint;
    private URI requestObjectEndpoint;
    private URI parEndpoint;
    private URI deviceAuthzEndpoint;
    private URI backChannelAuthEndpoint;

    public static Set<String> getRegisteredParameterNames() {
        return REGISTERED_PARAMETER_NAMES;
    }

    @Override
    public URI getAuthorizationEndpointURI() {
        return this.authzEndpoint;
    }

    public void setAuthorizationEndpointURI(URI uRI) {
        this.authzEndpoint = uRI;
    }

    @Override
    public URI getTokenEndpointURI() {
        return this.tokenEndpoint;
    }

    public void setTokenEndpointURI(URI uRI) {
        this.tokenEndpoint = uRI;
    }

    @Override
    public URI getRegistrationEndpointURI() {
        return this.regEndpoint;
    }

    public void setRegistrationEndpointURI(URI uRI) {
        this.regEndpoint = uRI;
    }

    @Override
    public URI getIntrospectionEndpointURI() {
        return this.introspectionEndpoint;
    }

    public void setIntrospectionEndpointURI(URI uRI) {
        this.introspectionEndpoint = uRI;
    }

    @Override
    public URI getRevocationEndpointURI() {
        return this.revocationEndpoint;
    }

    public void setRevocationEndpointURI(URI uRI) {
        this.revocationEndpoint = uRI;
    }

    @Override
    @Deprecated
    public URI getRequestObjectEndpoint() {
        return this.requestObjectEndpoint;
    }

    @Deprecated
    public void setRequestObjectEndpoint(URI uRI) {
        this.requestObjectEndpoint = uRI;
    }

    @Override
    public URI getPushedAuthorizationRequestEndpointURI() {
        return this.parEndpoint;
    }

    public void setPushedAuthorizationRequestEndpointURI(URI uRI) {
        this.parEndpoint = uRI;
    }

    @Override
    public URI getDeviceAuthorizationEndpointURI() {
        return this.deviceAuthzEndpoint;
    }

    public void setDeviceAuthorizationEndpointURI(URI uRI) {
        this.deviceAuthzEndpoint = uRI;
    }

    @Override
    public URI getBackChannelAuthenticationEndpointURI() {
        return this.backChannelAuthEndpoint;
    }

    @Override
    @Deprecated
    public URI getBackChannelAuthenticationEndpoint() {
        return this.getBackChannelAuthenticationEndpointURI();
    }

    public void setBackChannelAuthenticationEndpointURI(URI uRI) {
        this.backChannelAuthEndpoint = uRI;
    }

    @Deprecated
    public void setBackChannelAuthenticationEndpoint(URI uRI) {
        this.setBackChannelAuthenticationEndpointURI(uRI);
    }

    @Override
    public JSONObject toJSONObject() {
        OrderedJSONObject orderedJSONObject = new OrderedJSONObject();
        if (this.getAuthorizationEndpointURI() != null) {
            ((HashMap)orderedJSONObject).put("authorization_endpoint", this.getAuthorizationEndpointURI().toString());
        }
        if (this.getTokenEndpointURI() != null) {
            ((HashMap)orderedJSONObject).put("token_endpoint", this.getTokenEndpointURI().toString());
        }
        if (this.getRegistrationEndpointURI() != null) {
            ((HashMap)orderedJSONObject).put("registration_endpoint", this.getRegistrationEndpointURI().toString());
        }
        if (this.getIntrospectionEndpointURI() != null) {
            ((HashMap)orderedJSONObject).put("introspection_endpoint", this.getIntrospectionEndpointURI().toString());
        }
        if (this.getRevocationEndpointURI() != null) {
            ((HashMap)orderedJSONObject).put("revocation_endpoint", this.getRevocationEndpointURI().toString());
        }
        if (this.getRequestObjectEndpoint() != null) {
            ((HashMap)orderedJSONObject).put("request_object_endpoint", this.getRequestObjectEndpoint().toString());
        }
        if (this.getPushedAuthorizationRequestEndpointURI() != null) {
            ((HashMap)orderedJSONObject).put("pushed_authorization_request_endpoint", this.getPushedAuthorizationRequestEndpointURI().toString());
        }
        if (this.getDeviceAuthorizationEndpointURI() != null) {
            ((HashMap)orderedJSONObject).put("device_authorization_endpoint", this.getDeviceAuthorizationEndpointURI().toString());
        }
        if (this.getBackChannelAuthenticationEndpointURI() != null) {
            ((HashMap)orderedJSONObject).put("backchannel_authentication_endpoint", this.getBackChannelAuthenticationEndpointURI().toString());
        }
        return orderedJSONObject;
    }

    public String toString() {
        return this.toJSONObject().toJSONString();
    }

    public static AuthorizationServerEndpointMetadata parse(JSONObject jSONObject) throws ParseException {
        AuthorizationServerEndpointMetadata authorizationServerEndpointMetadata = new AuthorizationServerEndpointMetadata();
        authorizationServerEndpointMetadata.authzEndpoint = JSONObjectUtils.getURI(jSONObject, "authorization_endpoint", null);
        authorizationServerEndpointMetadata.tokenEndpoint = JSONObjectUtils.getURI(jSONObject, "token_endpoint", null);
        authorizationServerEndpointMetadata.regEndpoint = JSONObjectUtils.getURI(jSONObject, "registration_endpoint", null);
        authorizationServerEndpointMetadata.introspectionEndpoint = JSONObjectUtils.getURI(jSONObject, "introspection_endpoint", null);
        authorizationServerEndpointMetadata.revocationEndpoint = JSONObjectUtils.getURI(jSONObject, "revocation_endpoint", null);
        authorizationServerEndpointMetadata.requestObjectEndpoint = JSONObjectUtils.getURI(jSONObject, "request_object_endpoint", null);
        authorizationServerEndpointMetadata.parEndpoint = JSONObjectUtils.getURI(jSONObject, "pushed_authorization_request_endpoint", null);
        authorizationServerEndpointMetadata.deviceAuthzEndpoint = JSONObjectUtils.getURI(jSONObject, "device_authorization_endpoint", null);
        authorizationServerEndpointMetadata.backChannelAuthEndpoint = JSONObjectUtils.getURI(jSONObject, "backchannel_authentication_endpoint", null);
        return authorizationServerEndpointMetadata;
    }

    static {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("authorization_endpoint");
        hashSet.add("token_endpoint");
        hashSet.add("registration_endpoint");
        hashSet.add("introspection_endpoint");
        hashSet.add("revocation_endpoint");
        hashSet.add("request_object_endpoint");
        hashSet.add("pushed_authorization_request_endpoint");
        hashSet.add("device_authorization_endpoint");
        hashSet.add("backchannel_authentication_endpoint");
        REGISTERED_PARAMETER_NAMES = Collections.unmodifiableSet(hashSet);
    }
}

