/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk;

import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.common.contenttype.ContentType;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.AbstractOptionallyIdentifiedRequest;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.SerializeException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.auth.ClientAuthentication;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.http.HTTPRequest;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.ClientID;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.token.AccessToken;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.token.RefreshToken;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.token.Token;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.token.TypelessAccessToken;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.MultivaluedMapUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.StringUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.URLUtils;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.Immutable;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONObject;

@Immutable
public final class TokenRevocationRequest
extends AbstractOptionallyIdentifiedRequest {
    private final Token token;

    public TokenRevocationRequest(URI uRI, ClientAuthentication clientAuthentication, Token token) {
        super(uRI, clientAuthentication);
        if (clientAuthentication == null) {
            throw new IllegalArgumentException("The client authentication must not be null");
        }
        if (token == null) {
            throw new IllegalArgumentException("The token must not be null");
        }
        this.token = token;
    }

    public TokenRevocationRequest(URI uRI, ClientID clientID, Token token) {
        super(uRI, clientID);
        if (clientID == null) {
            throw new IllegalArgumentException("The client ID must not be null");
        }
        if (token == null) {
            throw new IllegalArgumentException("The token must not be null");
        }
        this.token = token;
    }

    public Token getToken() {
        return this.token;
    }

    @Override
    public HTTPRequest toHTTPRequest() {
        if (this.getEndpointURI() == null) {
            throw new SerializeException("The endpoint URI is not specified");
        }
        HTTPRequest hTTPRequest = new HTTPRequest(HTTPRequest.Method.POST, this.getEndpointURI());
        hTTPRequest.setEntityContentType(ContentType.APPLICATION_URLENCODED);
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
        if (this.getClientID() != null) {
            hashMap.put("client_id", Collections.singletonList(this.getClientID().getValue()));
        }
        hashMap.put("token", Collections.singletonList(this.token.getValue()));
        if (this.token instanceof AccessToken) {
            hashMap.put("token_type_hint", Collections.singletonList("access_token"));
        } else if (this.token instanceof RefreshToken) {
            hashMap.put("token_type_hint", Collections.singletonList("refresh_token"));
        }
        hTTPRequest.setQuery(URLUtils.serializeParameters(hashMap));
        if (this.getClientAuthentication() != null) {
            this.getClientAuthentication().applyTo(hTTPRequest);
        }
        return hTTPRequest;
    }

    public static TokenRevocationRequest parse(HTTPRequest hTTPRequest) throws ParseException {
        hTTPRequest.ensureMethod(HTTPRequest.Method.POST);
        hTTPRequest.ensureEntityContentType(ContentType.APPLICATION_URLENCODED);
        Map<String, List<String>> map = hTTPRequest.getQueryParameters();
        final String string = MultivaluedMapUtils.getFirstValue(map, "token");
        if (string == null || string.isEmpty()) {
            throw new ParseException("Missing required token parameter");
        }
        Token token = null;
        String string2 = MultivaluedMapUtils.getFirstValue(map, "token_type_hint");
        if (string2 == null) {
            token = new Token(){
                private static final long serialVersionUID = 8606135001277432930L;

                @Override
                public String getValue() {
                    return string;
                }

                @Override
                public Set<String> getParameterNames() {
                    return Collections.emptySet();
                }

                @Override
                public JSONObject toJSONObject() {
                    return new JSONObject();
                }

                @Override
                public boolean equals(Object object) {
                    return object instanceof Token && object.toString().equals(string);
                }
            };
        } else if (string2.equals("access_token")) {
            token = new TypelessAccessToken(string);
        } else if (string2.equals("refresh_token")) {
            token = new RefreshToken(string);
        }
        URI uRI = hTTPRequest.getURI();
        ClientAuthentication clientAuthentication = ClientAuthentication.parse(hTTPRequest);
        if (clientAuthentication != null) {
            return new TokenRevocationRequest(uRI, clientAuthentication, token);
        }
        String string3 = MultivaluedMapUtils.getFirstValue(map, "client_id");
        if (StringUtils.isBlank(string3)) {
            throw new ParseException("Invalid token revocation request: No client authentication or client_id parameter found");
        }
        return new TokenRevocationRequest(uRI, new ClientID(string3), token);
    }
}

