/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util;

import java.math.BigInteger;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.Base64;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.Base64Codec;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.BigIntegerUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.StandardCharset;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.Immutable;

@Immutable
public class Base64URL
extends Base64 {
    public Base64URL(String string) {
        super(string);
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof Base64URL && this.toString().equals(object.toString());
    }

    public static Base64URL from(String string) {
        if (string == null) {
            return null;
        }
        return new Base64URL(string);
    }

    public static Base64URL encode(byte[] byArray) {
        return new Base64URL(Base64Codec.encodeToString(byArray, true));
    }

    public static Base64URL encode(BigInteger bigInteger) {
        return Base64URL.encode(BigIntegerUtils.toBytesUnsigned(bigInteger));
    }

    public static Base64URL encode(String string) {
        return Base64URL.encode(string.getBytes(StandardCharset.UTF_8));
    }
}

