/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.json.writer;

import java.io.IOException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.json.JSONStyle;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.json.JSONValue;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.json.writer.JsonReader;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.json.writer.JsonReaderI;

public class CompessorMapper
extends JsonReaderI<CompessorMapper> {
    private Appendable out;
    private JSONStyle compression;
    private Boolean _isObj;
    private boolean needSep = false;
    private boolean isOpen = false;
    private boolean isClosed = false;

    private boolean isArray() {
        return this._isObj == Boolean.FALSE;
    }

    private boolean isObject() {
        return this._isObj == Boolean.TRUE;
    }

    private boolean isCompressor(Object object) {
        return object instanceof CompessorMapper;
    }

    public CompessorMapper(JsonReader jsonReader, Appendable appendable, JSONStyle jSONStyle) {
        this(jsonReader, appendable, jSONStyle, null);
    }

    public CompessorMapper(JsonReader jsonReader, Appendable appendable, JSONStyle jSONStyle, Boolean bl2) {
        super(jsonReader);
        this.out = appendable;
        this.compression = jSONStyle;
        this._isObj = bl2;
    }

    @Override
    public JsonReaderI<?> startObject(String string) throws IOException {
        this.open(this);
        this.startKey(string);
        CompessorMapper compessorMapper = new CompessorMapper(this.base, this.out, this.compression, true);
        this.open(compessorMapper);
        return compessorMapper;
    }

    @Override
    public JsonReaderI<?> startArray(String string) throws IOException {
        this.open(this);
        this.startKey(string);
        CompessorMapper compessorMapper = new CompessorMapper(this.base, this.out, this.compression, false);
        this.open(compessorMapper);
        return compessorMapper;
    }

    private void startKey(String string) throws IOException {
        this.addComma();
        if (this.isArray()) {
            return;
        }
        if (!this.compression.mustProtectKey(string)) {
            this.out.append(string);
        } else {
            this.out.append('\"');
            JSONValue.escape(string, this.out, this.compression);
            this.out.append('\"');
        }
        this.out.append(':');
    }

    @Override
    public void setValue(Object object, String string, Object object2) throws IOException {
        if (this.isCompressor(object2)) {
            this.addComma();
            return;
        }
        this.startKey(string);
        this.writeValue(object2);
    }

    @Override
    public void addValue(Object object, Object object2) throws IOException {
        this.addComma();
        this.writeValue(object2);
    }

    private void addComma() throws IOException {
        if (this.needSep) {
            this.out.append(',');
        } else {
            this.needSep = true;
        }
    }

    private void writeValue(Object object) throws IOException {
        if (object instanceof String) {
            this.compression.writeString(this.out, (String)object);
        } else if (this.isCompressor(object)) {
            this.close(object);
        } else {
            JSONValue.writeJSONString(object, this.out, this.compression);
        }
    }

    @Override
    public Object createObject() {
        this._isObj = true;
        try {
            this.open(this);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this;
    }

    @Override
    public Object createArray() {
        this._isObj = false;
        try {
            this.open(this);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this;
    }

    @Override
    public CompessorMapper convert(Object object) {
        try {
            this.close(object);
            return this;
        }
        catch (Exception exception) {
            return this;
        }
    }

    private void close(Object object) throws IOException {
        if (!this.isCompressor(object)) {
            return;
        }
        if (((CompessorMapper)object).isClosed) {
            return;
        }
        ((CompessorMapper)object).isClosed = true;
        if (((CompessorMapper)object).isObject()) {
            this.out.append('}');
            this.needSep = true;
        } else if (((CompessorMapper)object).isArray()) {
            this.out.append(']');
            this.needSep = true;
        }
    }

    private void open(Object object) throws IOException {
        if (!this.isCompressor(object)) {
            return;
        }
        if (((CompessorMapper)object).isOpen) {
            return;
        }
        ((CompessorMapper)object).isOpen = true;
        if (((CompessorMapper)object).isObject()) {
            this.out.append('{');
            this.needSep = false;
        } else if (((CompessorMapper)object).isArray()) {
            this.out.append('[');
            this.needSep = false;
        }
    }
}

