/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.json.parser;

import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.json.JSONValue;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.json.parser.JSONParserByteArray;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.json.parser.JSONParserInputStream;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.json.parser.JSONParserReader;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.json.parser.JSONParserString;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.json.parser.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.json.writer.JsonReaderI;

public class JSONParser {
    public static final int ACCEPT_SIMPLE_QUOTE = 1;
    public static final int ACCEPT_NON_QUOTE = 2;
    public static final int ACCEPT_NAN = 4;
    public static final int IGNORE_CONTROL_CHAR = 8;
    public static final int USE_INTEGER_STORAGE = 16;
    public static final int ACCEPT_LEADING_ZERO = 32;
    public static final int ACCEPT_USELESS_COMMA = 64;
    public static final int USE_HI_PRECISION_FLOAT = 128;
    public static final int ACCEPT_TAILLING_DATA = 256;
    public static final int ACCEPT_TAILLING_SPACE = 512;
    public static final int REJECT_127_CHAR = 1024;
    public static final int BIG_DIGIT_UNRESTRICTED = 2048;
    public static final int MODE_PERMISSIVE = -1;
    public static final int MODE_RFC4627 = 656;
    public static final int MODE_JSON_SIMPLE = 4032;
    public static final int MODE_STRICTEST = 1168;
    public static int DEFAULT_PERMISSIVE_MODE = System.getProperty("JSON_SMART_SIMPLE") != null ? 4032 : -1;
    private int mode;
    private JSONParserInputStream pBinStream;
    private JSONParserByteArray pBytes;
    private JSONParserReader pStream;
    private JSONParserString pString;

    private JSONParserReader getPStream() {
        if (this.pStream == null) {
            this.pStream = new JSONParserReader(this.mode);
        }
        return this.pStream;
    }

    private JSONParserInputStream getPBinStream() {
        if (this.pBinStream == null) {
            this.pBinStream = new JSONParserInputStream(this.mode);
        }
        return this.pBinStream;
    }

    private JSONParserString getPString() {
        if (this.pString == null) {
            this.pString = new JSONParserString(this.mode);
        }
        return this.pString;
    }

    private JSONParserByteArray getPBytes() {
        if (this.pBytes == null) {
            this.pBytes = new JSONParserByteArray(this.mode);
        }
        return this.pBytes;
    }

    public JSONParser() {
        this.mode = DEFAULT_PERMISSIVE_MODE;
    }

    public JSONParser(int n2) {
        this.mode = n2;
    }

    public Object parse(byte[] byArray) throws ParseException {
        return this.getPBytes().parse(byArray);
    }

    public <T> T parse(byte[] byArray, JsonReaderI<T> jsonReaderI) throws ParseException {
        return this.getPBytes().parse(byArray, jsonReaderI);
    }

    public <T> T parse(byte[] byArray, Class<T> clazz) throws ParseException {
        return this.getPBytes().parse(byArray, JSONValue.defaultReader.getMapper(clazz));
    }

    public Object parse(InputStream inputStream) throws ParseException, UnsupportedEncodingException {
        return this.getPBinStream().parse(inputStream);
    }

    public <T> T parse(InputStream inputStream, JsonReaderI<T> jsonReaderI) throws ParseException, UnsupportedEncodingException {
        return this.getPBinStream().parse(inputStream, jsonReaderI);
    }

    public <T> T parse(InputStream inputStream, Class<T> clazz) throws ParseException, UnsupportedEncodingException {
        return this.getPBinStream().parse(inputStream, JSONValue.defaultReader.getMapper(clazz));
    }

    public Object parse(Reader reader) throws ParseException {
        return this.getPStream().parse(reader);
    }

    public <T> T parse(Reader reader, JsonReaderI<T> jsonReaderI) throws ParseException {
        return this.getPStream().parse(reader, jsonReaderI);
    }

    public <T> T parse(Reader reader, Class<T> clazz) throws ParseException {
        return this.getPStream().parse(reader, JSONValue.defaultReader.getMapper(clazz));
    }

    public Object parse(String string) throws ParseException {
        return this.getPString().parse(string);
    }

    public <T> T parse(String string, JsonReaderI<T> jsonReaderI) throws ParseException {
        return this.getPString().parse(string, jsonReaderI);
    }

    public <T> T parse(String string, Class<T> clazz) throws ParseException {
        return this.getPString().parse(string, JSONValue.defaultReader.getMapper(clazz));
    }
}

