/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.proc;

import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.Algorithm;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.EncryptionMethod;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JOSEObject;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWEObject;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWSObject;

public class JOSEMatcher {
    private final Set<Class<? extends JOSEObject>> classes;
    private final Set<Algorithm> algs;
    private final Set<EncryptionMethod> encs;
    private final Set<URI> jkus;
    private final Set<String> kids;

    public JOSEMatcher(Set<Class<? extends JOSEObject>> set, Set<Algorithm> set2, Set<EncryptionMethod> set3, Set<URI> set4, Set<String> set5) {
        this.classes = set;
        this.algs = set2;
        this.encs = set3;
        this.jkus = set4;
        this.kids = set5;
    }

    public Set<Class<? extends JOSEObject>> getJOSEClasses() {
        return this.classes;
    }

    public Set<Algorithm> getAlgorithms() {
        return this.algs;
    }

    public Set<EncryptionMethod> getEncryptionMethods() {
        return this.encs;
    }

    public Set<URI> getJWKURLs() {
        return this.jkus;
    }

    public Set<String> getKeyIDs() {
        return this.kids;
    }

    public boolean matches(JOSEObject jOSEObject) {
        URI uRI;
        if (this.classes != null) {
            boolean bl2 = false;
            for (Class<? extends JOSEObject> clazz : this.classes) {
                if (clazz == null || !clazz.isInstance(jOSEObject)) continue;
                bl2 = true;
                break;
            }
            if (!bl2) {
                return false;
            }
        }
        if (this.algs != null && !this.algs.contains(jOSEObject.getHeader().getAlgorithm())) {
            return false;
        }
        if (this.encs != null) {
            if (!(jOSEObject instanceof JWEObject)) {
                return false;
            }
            JWEObject jWEObject = (JWEObject)jOSEObject;
            if (!this.encs.contains(jWEObject.getHeader().getEncryptionMethod())) {
                return false;
            }
        }
        if (this.jkus != null && !this.jkus.contains(uRI = jOSEObject instanceof JWSObject ? ((JWSObject)jOSEObject).getHeader().getJWKURL() : (jOSEObject instanceof JWEObject ? ((JWEObject)jOSEObject).getHeader().getJWKURL() : null))) {
            return false;
        }
        if (this.kids != null) {
            String string = jOSEObject instanceof JWSObject ? ((JWSObject)jOSEObject).getHeader().getKeyID() : (jOSEObject instanceof JWEObject ? ((JWEObject)jOSEObject).getHeader().getKeyID() : null);
            return this.kids.contains(string);
        }
        return true;
    }

    public static class Builder {
        private Set<Class<? extends JOSEObject>> classes;
        private Set<Algorithm> algs;
        private Set<EncryptionMethod> encs;
        private Set<URI> jkus;
        private Set<String> kids;

        public Builder joseClass(Class<? extends JOSEObject> clazz) {
            this.classes = clazz == null ? null : new HashSet<Class<? extends JOSEObject>>(Collections.singletonList(clazz));
            return this;
        }

        public Builder joseClasses(Class<? extends JOSEObject> ... classArray) {
            this.joseClasses(new HashSet<Class<? extends JOSEObject>>(Arrays.asList(classArray)));
            return this;
        }

        public Builder joseClasses(Set<Class<? extends JOSEObject>> set) {
            this.classes = set;
            return this;
        }

        public Builder algorithm(Algorithm algorithm) {
            this.algs = algorithm == null ? null : new HashSet<Algorithm>(Collections.singletonList(algorithm));
            return this;
        }

        public Builder algorithms(Algorithm ... algorithmArray) {
            this.algorithms(new HashSet<Algorithm>(Arrays.asList(algorithmArray)));
            return this;
        }

        public Builder algorithms(Set<Algorithm> set) {
            this.algs = set;
            return this;
        }

        public Builder encryptionMethod(EncryptionMethod encryptionMethod) {
            this.encs = encryptionMethod == null ? null : new HashSet<EncryptionMethod>(Collections.singletonList(encryptionMethod));
            return this;
        }

        public Builder encryptionMethods(EncryptionMethod ... encryptionMethodArray) {
            this.encryptionMethods(new HashSet<EncryptionMethod>(Arrays.asList(encryptionMethodArray)));
            return this;
        }

        public Builder encryptionMethods(Set<EncryptionMethod> set) {
            this.encs = set;
            return this;
        }

        public Builder jwkURL(URI uRI) {
            this.jkus = uRI == null ? null : new HashSet<URI>(Collections.singletonList(uRI));
            return this;
        }

        public Builder jwkURLs(URI ... uRIArray) {
            this.jwkURLs(new HashSet<URI>(Arrays.asList(uRIArray)));
            return this;
        }

        public Builder jwkURLs(Set<URI> set) {
            this.jkus = set;
            return this;
        }

        public Builder keyID(String string) {
            this.kids = string == null ? null : new HashSet<String>(Collections.singletonList(string));
            return this;
        }

        public Builder keyIDs(String ... stringArray) {
            this.keyIDs(new HashSet<String>(Arrays.asList(stringArray)));
            return this;
        }

        public Builder keyIDs(Set<String> set) {
            this.kids = set;
            return this;
        }

        public JOSEMatcher build() {
            return new JOSEMatcher(this.classes, this.algs, this.encs, this.jkus, this.kids);
        }
    }
}

