/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.proc;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JOSEObjectType;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.proc.BadJOSEException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.proc.JOSEObjectTypeVerifier;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.proc.SecurityContext;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.Immutable;

@Immutable
public class DefaultJOSEObjectTypeVerifier<C extends SecurityContext>
implements JOSEObjectTypeVerifier<C> {
    private final Set<JOSEObjectType> allowedTypes;
    public static final DefaultJOSEObjectTypeVerifier JOSE = new DefaultJOSEObjectTypeVerifier(JOSEObjectType.JOSE, null);
    public static final DefaultJOSEObjectTypeVerifier JWT = new DefaultJOSEObjectTypeVerifier(JOSEObjectType.JWT, null);

    public DefaultJOSEObjectTypeVerifier() {
        this.allowedTypes = Collections.singleton(null);
    }

    public DefaultJOSEObjectTypeVerifier(Set<JOSEObjectType> set) {
        if (set == null || set.isEmpty()) {
            throw new IllegalArgumentException("The allowed types must not be null or empty");
        }
        this.allowedTypes = set;
    }

    public DefaultJOSEObjectTypeVerifier(JOSEObjectType ... jOSEObjectTypeArray) {
        if (jOSEObjectTypeArray == null || jOSEObjectTypeArray.length == 0) {
            throw new IllegalArgumentException("The allowed types must not be null or empty");
        }
        this.allowedTypes = new HashSet<JOSEObjectType>(Arrays.asList(jOSEObjectTypeArray));
    }

    public Set<JOSEObjectType> getAllowedTypes() {
        return this.allowedTypes;
    }

    @Override
    public void verify(JOSEObjectType jOSEObjectType, C c2) throws BadJOSEException {
        if (jOSEObjectType == null && !this.allowedTypes.contains(null)) {
            throw new BadJOSEException("Required JOSE header typ (type) parameter is missing");
        }
        if (!this.allowedTypes.contains(jOSEObjectType)) {
            throw new BadJOSEException("JOSE header typ (type) " + jOSEObjectType + " not allowed");
        }
    }
}

