/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.mint;

import java.util.List;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JOSEException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWSHeader;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWSObject;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.Payload;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.factories.DefaultJWSSignerFactory;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.JWK;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.JWKMatcher;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.JWKSelector;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.JWKSet;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.source.JWKSource;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.mint.ConfigurableJWSMinter;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.proc.JWKSecurityContext;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.proc.SecurityContext;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.produce.JWSSignerFactory;

public class DefaultJWSMinter<C extends SecurityContext>
implements ConfigurableJWSMinter<C> {
    private JWKSource<C> jwkSource;
    private JWSSignerFactory jwsSignerFactory = new DefaultJWSSignerFactory();

    @Override
    public JWSObject mint(JWSHeader jWSHeader, Payload payload, C c2) throws JOSEException {
        List<JWK> list = this.jwks(jWSHeader, c2);
        if (list.isEmpty()) {
            throw new JOSEException("No JWKs found for signing");
        }
        JWK jWK = list.get(0);
        JWSHeader jWSHeader2 = new JWSHeader.Builder(jWSHeader).keyID(jWK.getKeyID()).x509CertURL(jWK.getX509CertURL()).x509CertChain(jWK.getX509CertChain()).x509CertSHA256Thumbprint(jWK.getX509CertSHA256Thumbprint()).x509CertThumbprint(jWK.getX509CertThumbprint()).build();
        JWSObject jWSObject = new JWSObject(jWSHeader2, payload);
        if (this.jwsSignerFactory == null) {
            throw new JOSEException("No JWS signer factory configured");
        }
        jWSObject.sign(this.jwsSignerFactory.createJWSSigner(jWK));
        return jWSObject;
    }

    private List<JWK> jwks(JWSHeader jWSHeader, C c2) throws JOSEException {
        JWKMatcher jWKMatcher = JWKMatcher.forJWSHeader(jWSHeader);
        JWKSelector jWKSelector = new JWKSelector(jWKMatcher);
        if (c2 instanceof JWKSecurityContext) {
            return jWKSelector.select(new JWKSet(((JWKSecurityContext)c2).getKeys()));
        }
        if (this.jwkSource == null) {
            throw new JOSEException("No JWK source configured");
        }
        return this.jwkSource.get(jWKSelector, c2);
    }

    @Override
    public JWKSource<C> getJWKSource() {
        return this.jwkSource;
    }

    @Override
    public void setJWKSource(JWKSource<C> jWKSource) {
        this.jwkSource = jWKSource;
    }

    @Override
    public JWSSignerFactory getJWSSignerFactory() {
        return this.jwsSignerFactory;
    }

    @Override
    public void setJWSSignerFactory(JWSSignerFactory jWSSignerFactory) {
        this.jwsSignerFactory = jWSSignerFactory;
    }
}

