/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.source;

import java.util.Date;
import java.util.concurrent.TimeUnit;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.JWKSet;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.source.JWKSetCache;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.source.JWKSetWithTimestamp;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class DefaultJWKSetCache
implements JWKSetCache {
    public static final long DEFAULT_LIFESPAN_MINUTES = 15L;
    public static final long DEFAULT_REFRESH_TIME_MINUTES = 5L;
    private final long lifespan;
    private final long refreshTime;
    private final TimeUnit timeUnit;
    private volatile JWKSetWithTimestamp jwkSetWithTimestamp;

    public DefaultJWKSetCache() {
        this(15L, 5L, TimeUnit.MINUTES);
    }

    public DefaultJWKSetCache(long l2, long l3, TimeUnit timeUnit) {
        this.lifespan = l2;
        this.refreshTime = l3;
        if ((l2 > -1L || l3 > -1L) && timeUnit == null) {
            throw new IllegalArgumentException("A time unit must be specified for non-negative lifespans or refresh times");
        }
        this.timeUnit = timeUnit;
    }

    @Override
    public void put(JWKSet jWKSet) {
        JWKSetWithTimestamp jWKSetWithTimestamp = jWKSet != null ? new JWKSetWithTimestamp(jWKSet) : null;
        this.jwkSetWithTimestamp = jWKSetWithTimestamp;
    }

    @Override
    public JWKSet get() {
        if (this.jwkSetWithTimestamp == null || this.isExpired()) {
            return null;
        }
        return this.jwkSetWithTimestamp.getJWKSet();
    }

    @Override
    public boolean requiresRefresh() {
        return this.jwkSetWithTimestamp != null && this.refreshTime > -1L && new Date().getTime() > this.jwkSetWithTimestamp.getDate().getTime() + TimeUnit.MILLISECONDS.convert(this.refreshTime, this.timeUnit);
    }

    public long getPutTimestamp() {
        return this.jwkSetWithTimestamp != null ? this.jwkSetWithTimestamp.getDate().getTime() : -1L;
    }

    public boolean isExpired() {
        return this.jwkSetWithTimestamp != null && this.lifespan > -1L && new Date().getTime() > this.jwkSetWithTimestamp.getDate().getTime() + TimeUnit.MILLISECONDS.convert(this.lifespan, this.timeUnit);
    }

    public long getLifespan(TimeUnit timeUnit) {
        if (this.lifespan < 0L) {
            return this.lifespan;
        }
        return timeUnit.convert(this.lifespan, this.timeUnit);
    }

    public long getRefreshTime(TimeUnit timeUnit) {
        if (this.refreshTime < 0L) {
            return this.refreshTime;
        }
        return timeUnit.convert(this.refreshTime, this.timeUnit);
    }
}

