/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.LinkedHashMap;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JOSEException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.JWK;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.Base64URL;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.JSONObjectUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.StandardCharset;

public final class ThumbprintUtils {
    public static Base64URL compute(JWK jWK) throws JOSEException {
        return ThumbprintUtils.compute("SHA-256", jWK);
    }

    public static Base64URL compute(String string, JWK jWK) throws JOSEException {
        LinkedHashMap<String, ?> linkedHashMap = jWK.getRequiredParams();
        return ThumbprintUtils.compute(string, linkedHashMap);
    }

    public static Base64URL compute(String string, LinkedHashMap<String, ?> linkedHashMap) throws JOSEException {
        MessageDigest messageDigest;
        String string2 = JSONObjectUtils.toJSONString(linkedHashMap);
        try {
            messageDigest = MessageDigest.getInstance(string);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new JOSEException("Couldn't compute JWK thumbprint: Unsupported hash algorithm: " + noSuchAlgorithmException.getMessage(), noSuchAlgorithmException);
        }
        messageDigest.update(string2.getBytes(StandardCharset.UTF_8));
        return Base64URL.encode(messageDigest.digest());
    }
}

