/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.Algorithm;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWEHeader;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWSAlgorithm;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWSHeader;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.Curve;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.CurveBasedJWK;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.JWK;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.KeyOperation;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.KeyType;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.KeyUse;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.Base64URL;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.Immutable;

@Immutable
public class JWKMatcher {
    private final Set<KeyType> types;
    private final Set<KeyUse> uses;
    private final Set<KeyOperation> ops;
    private final Set<Algorithm> algs;
    private final Set<String> ids;
    private final boolean hasUse;
    private final boolean hasID;
    private final boolean privateOnly;
    private final boolean publicOnly;
    private final int minSizeBits;
    private final int maxSizeBits;
    private final Set<Integer> sizesBits;
    private final Set<Curve> curves;
    private final Set<Base64URL> x5tS256s;

    @Deprecated
    public JWKMatcher(Set<KeyType> set, Set<KeyUse> set2, Set<KeyOperation> set3, Set<Algorithm> set4, Set<String> set5, boolean bl2, boolean bl3) {
        this(set, set2, set3, set4, set5, bl2, bl3, 0, 0);
    }

    @Deprecated
    public JWKMatcher(Set<KeyType> set, Set<KeyUse> set2, Set<KeyOperation> set3, Set<Algorithm> set4, Set<String> set5, boolean bl2, boolean bl3, int n2, int n3) {
        this(set, set2, set3, set4, set5, bl2, bl3, n2, n3, null);
    }

    @Deprecated
    public JWKMatcher(Set<KeyType> set, Set<KeyUse> set2, Set<KeyOperation> set3, Set<Algorithm> set4, Set<String> set5, boolean bl2, boolean bl3, int n2, int n3, Set<Curve> set6) {
        this(set, set2, set3, set4, set5, bl2, bl3, n2, n3, null, set6);
    }

    @Deprecated
    public JWKMatcher(Set<KeyType> set, Set<KeyUse> set2, Set<KeyOperation> set3, Set<Algorithm> set4, Set<String> set5, boolean bl2, boolean bl3, int n2, int n3, Set<Integer> set6, Set<Curve> set7) {
        this(set, set2, set3, set4, set5, false, false, bl2, bl3, n2, n3, set6, set7);
    }

    @Deprecated
    public JWKMatcher(Set<KeyType> set, Set<KeyUse> set2, Set<KeyOperation> set3, Set<Algorithm> set4, Set<String> set5, boolean bl2, boolean bl3, boolean bl4, boolean bl5, int n2, int n3, Set<Integer> set6, Set<Curve> set7) {
        this(set, set2, set3, set4, set5, bl2, bl3, bl4, bl5, n2, n3, set6, set7, null);
    }

    public JWKMatcher(Set<KeyType> set, Set<KeyUse> set2, Set<KeyOperation> set3, Set<Algorithm> set4, Set<String> set5, boolean bl2, boolean bl3, boolean bl4, boolean bl5, int n2, int n3, Set<Integer> set6, Set<Curve> set7, Set<Base64URL> set8) {
        this.types = set;
        this.uses = set2;
        this.ops = set3;
        this.algs = set4;
        this.ids = set5;
        this.hasUse = bl2;
        this.hasID = bl3;
        this.privateOnly = bl4;
        this.publicOnly = bl5;
        this.minSizeBits = n2;
        this.maxSizeBits = n3;
        this.sizesBits = set6;
        this.curves = set7;
        this.x5tS256s = set8;
    }

    public static JWKMatcher forJWEHeader(JWEHeader jWEHeader) {
        return new Builder().keyType(KeyType.forAlgorithm(jWEHeader.getAlgorithm())).keyID(jWEHeader.getKeyID()).keyUses(KeyUse.ENCRYPTION, null).algorithms(jWEHeader.getAlgorithm(), null).build();
    }

    public static JWKMatcher forJWSHeader(JWSHeader jWSHeader) {
        JWSAlgorithm jWSAlgorithm = jWSHeader.getAlgorithm();
        if (JWSAlgorithm.Family.RSA.contains(jWSAlgorithm) || JWSAlgorithm.Family.EC.contains(jWSAlgorithm)) {
            return new Builder().keyType(KeyType.forAlgorithm(jWSAlgorithm)).keyID(jWSHeader.getKeyID()).keyUses(KeyUse.SIGNATURE, null).algorithms(jWSAlgorithm, null).x509CertSHA256Thumbprint(jWSHeader.getX509CertSHA256Thumbprint()).build();
        }
        if (JWSAlgorithm.Family.HMAC_SHA.contains(jWSAlgorithm)) {
            return new Builder().keyType(KeyType.forAlgorithm(jWSAlgorithm)).keyID(jWSHeader.getKeyID()).privateOnly(true).algorithms(jWSAlgorithm, null).build();
        }
        if (JWSAlgorithm.Family.ED.contains(jWSAlgorithm)) {
            return new Builder().keyType(KeyType.forAlgorithm(jWSAlgorithm)).keyID(jWSHeader.getKeyID()).keyUses(KeyUse.SIGNATURE, null).algorithms(jWSAlgorithm, null).curves(Curve.forJWSAlgorithm(jWSAlgorithm)).build();
        }
        return null;
    }

    public Set<KeyType> getKeyTypes() {
        return this.types;
    }

    public Set<KeyUse> getKeyUses() {
        return this.uses;
    }

    public Set<KeyOperation> getKeyOperations() {
        return this.ops;
    }

    public Set<Algorithm> getAlgorithms() {
        return this.algs;
    }

    public Set<String> getKeyIDs() {
        return this.ids;
    }

    public boolean hasKeyUse() {
        return this.hasUse;
    }

    public boolean hasKeyID() {
        return this.hasID;
    }

    public boolean isPrivateOnly() {
        return this.privateOnly;
    }

    public boolean isPublicOnly() {
        return this.publicOnly;
    }

    @Deprecated
    public int getMinSize() {
        return this.getMinKeySize();
    }

    public int getMinKeySize() {
        return this.minSizeBits;
    }

    @Deprecated
    public int getMaxSize() {
        return this.getMaxKeySize();
    }

    public int getMaxKeySize() {
        return this.maxSizeBits;
    }

    public Set<Integer> getKeySizes() {
        return this.sizesBits;
    }

    public Set<Curve> getCurves() {
        return this.curves;
    }

    public Set<Base64URL> getX509CertSHA256Thumbprints() {
        return this.x5tS256s;
    }

    public boolean matches(JWK jWK) {
        if (this.hasUse && jWK.getKeyUse() == null) {
            return false;
        }
        if (this.hasID && (jWK.getKeyID() == null || jWK.getKeyID().trim().isEmpty())) {
            return false;
        }
        if (this.privateOnly && !jWK.isPrivate()) {
            return false;
        }
        if (this.publicOnly && jWK.isPrivate()) {
            return false;
        }
        if (this.types != null && !this.types.contains(jWK.getKeyType())) {
            return false;
        }
        if (this.uses != null && !this.uses.contains(jWK.getKeyUse())) {
            return false;
        }
        if (!(this.ops == null || this.ops.contains(null) && jWK.getKeyOperations() == null || jWK.getKeyOperations() != null && this.ops.containsAll(jWK.getKeyOperations()))) {
            return false;
        }
        if (this.algs != null && !this.algs.contains(jWK.getAlgorithm())) {
            return false;
        }
        if (this.ids != null && !this.ids.contains(jWK.getKeyID())) {
            return false;
        }
        if (this.minSizeBits > 0 && jWK.size() < this.minSizeBits) {
            return false;
        }
        if (this.maxSizeBits > 0 && jWK.size() > this.maxSizeBits) {
            return false;
        }
        if (this.sizesBits != null && !this.sizesBits.contains(jWK.size())) {
            return false;
        }
        if (this.curves != null) {
            if (!(jWK instanceof CurveBasedJWK)) {
                return false;
            }
            CurveBasedJWK curveBasedJWK = (CurveBasedJWK)((Object)jWK);
            if (!this.curves.contains(curveBasedJWK.getCurve())) {
                return false;
            }
        }
        if (this.x5tS256s != null) {
            return this.x5tS256s.contains(jWK.getX509CertSHA256Thumbprint());
        }
        return true;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        JWKMatcher.append(stringBuilder, "kty", this.types);
        JWKMatcher.append(stringBuilder, "use", this.uses);
        JWKMatcher.append(stringBuilder, "key_ops", this.ops);
        JWKMatcher.append(stringBuilder, "alg", this.algs);
        JWKMatcher.append(stringBuilder, "kid", this.ids);
        if (this.hasUse) {
            stringBuilder.append("has_use=true ");
        }
        if (this.hasID) {
            stringBuilder.append("has_id=true ");
        }
        if (this.privateOnly) {
            stringBuilder.append("private_only=true ");
        }
        if (this.publicOnly) {
            stringBuilder.append("public_only=true ");
        }
        if (this.minSizeBits > 0) {
            stringBuilder.append("min_size=" + this.minSizeBits + " ");
        }
        if (this.maxSizeBits > 0) {
            stringBuilder.append("max_size=" + this.maxSizeBits + " ");
        }
        JWKMatcher.append(stringBuilder, "size", this.sizesBits);
        JWKMatcher.append(stringBuilder, "crv", this.curves);
        JWKMatcher.append(stringBuilder, "x5t#S256", this.x5tS256s);
        return stringBuilder.toString().trim();
    }

    private static void append(StringBuilder stringBuilder, String string, Set<?> set) {
        if (set != null) {
            stringBuilder.append(string);
            stringBuilder.append('=');
            if (set.size() == 1) {
                Object obj = set.iterator().next();
                if (obj == null) {
                    stringBuilder.append("ANY");
                } else {
                    stringBuilder.append(obj.toString().trim());
                }
            } else {
                stringBuilder.append(set.toString().trim());
            }
            stringBuilder.append(' ');
        }
    }

    public static class Builder {
        private Set<KeyType> types;
        private Set<KeyUse> uses;
        private Set<KeyOperation> ops;
        private Set<Algorithm> algs;
        private Set<String> ids;
        private boolean hasUse = false;
        private boolean hasID = false;
        private boolean privateOnly = false;
        private boolean publicOnly = false;
        private int minSizeBits = 0;
        private int maxSizeBits = 0;
        private Set<Integer> sizesBits;
        private Set<Curve> curves;
        private Set<Base64URL> x5tS256s;

        public Builder keyType(KeyType keyType) {
            this.types = keyType == null ? null : new HashSet<KeyType>(Collections.singletonList(keyType));
            return this;
        }

        public Builder keyTypes(KeyType ... keyTypeArray) {
            this.keyTypes(new LinkedHashSet<KeyType>(Arrays.asList(keyTypeArray)));
            return this;
        }

        public Builder keyTypes(Set<KeyType> set) {
            this.types = set;
            return this;
        }

        public Builder keyUse(KeyUse keyUse) {
            this.uses = keyUse == null ? null : new HashSet<KeyUse>(Collections.singletonList(keyUse));
            return this;
        }

        public Builder keyUses(KeyUse ... keyUseArray) {
            this.keyUses(new LinkedHashSet<KeyUse>(Arrays.asList(keyUseArray)));
            return this;
        }

        public Builder keyUses(Set<KeyUse> set) {
            this.uses = set;
            return this;
        }

        public Builder keyOperation(KeyOperation keyOperation) {
            this.ops = keyOperation == null ? null : new HashSet<KeyOperation>(Collections.singletonList(keyOperation));
            return this;
        }

        public Builder keyOperations(KeyOperation ... keyOperationArray) {
            this.keyOperations(new LinkedHashSet<KeyOperation>(Arrays.asList(keyOperationArray)));
            return this;
        }

        public Builder keyOperations(Set<KeyOperation> set) {
            this.ops = set;
            return this;
        }

        public Builder algorithm(Algorithm algorithm) {
            this.algs = algorithm == null ? null : new HashSet<Algorithm>(Collections.singletonList(algorithm));
            return this;
        }

        public Builder algorithms(Algorithm ... algorithmArray) {
            this.algorithms(new LinkedHashSet<Algorithm>(Arrays.asList(algorithmArray)));
            return this;
        }

        public Builder algorithms(Set<Algorithm> set) {
            this.algs = set;
            return this;
        }

        public Builder keyID(String string) {
            this.ids = string == null ? null : new HashSet<String>(Collections.singletonList(string));
            return this;
        }

        public Builder keyIDs(String ... stringArray) {
            this.keyIDs(new LinkedHashSet<String>(Arrays.asList(stringArray)));
            return this;
        }

        public Builder keyIDs(Set<String> set) {
            this.ids = set;
            return this;
        }

        public Builder hasKeyUse(boolean bl2) {
            this.hasUse = bl2;
            return this;
        }

        public Builder hasKeyID(boolean bl2) {
            this.hasID = bl2;
            return this;
        }

        public Builder privateOnly(boolean bl2) {
            this.privateOnly = bl2;
            return this;
        }

        public Builder publicOnly(boolean bl2) {
            this.publicOnly = bl2;
            return this;
        }

        public Builder minKeySize(int n2) {
            this.minSizeBits = n2;
            return this;
        }

        public Builder maxKeySize(int n2) {
            this.maxSizeBits = n2;
            return this;
        }

        public Builder keySize(int n2) {
            this.sizesBits = n2 <= 0 ? null : Collections.singleton(n2);
            return this;
        }

        public Builder keySizes(int ... nArray) {
            LinkedHashSet<Integer> linkedHashSet = new LinkedHashSet<Integer>();
            for (int n2 : nArray) {
                linkedHashSet.add(n2);
            }
            this.keySizes(linkedHashSet);
            return this;
        }

        public Builder keySizes(Set<Integer> set) {
            this.sizesBits = set;
            return this;
        }

        public Builder curve(Curve curve) {
            this.curves = curve == null ? null : Collections.singleton(curve);
            return this;
        }

        public Builder curves(Curve ... curveArray) {
            this.curves(new LinkedHashSet<Curve>(Arrays.asList(curveArray)));
            return this;
        }

        public Builder curves(Set<Curve> set) {
            this.curves = set;
            return this;
        }

        public Builder x509CertSHA256Thumbprint(Base64URL base64URL) {
            this.x5tS256s = base64URL == null ? null : Collections.singleton(base64URL);
            return this;
        }

        public Builder x509CertSHA256Thumbprints(Base64URL ... base64URLArray) {
            return this.x509CertSHA256Thumbprints(new LinkedHashSet<Base64URL>(Arrays.asList(base64URLArray)));
        }

        public Builder x509CertSHA256Thumbprints(Set<Base64URL> set) {
            this.x5tS256s = set;
            return this;
        }

        public JWKMatcher build() {
            return new JWKMatcher(this.types, this.uses, this.ops, this.algs, this.ids, this.hasUse, this.hasID, this.privateOnly, this.publicOnly, this.minSizeBits, this.maxSizeBits, this.sizesBits, this.curves, this.x5tS256s);
        }
    }
}

